/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.impl.AbstractBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.Comparator;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;

public class ComparatorExpressionImpl
extends AbstractBaseExpressionImpl {
    private IField field;
    private Object object;
    private Comparator comparator;

    public ComparatorExpressionImpl(IObjectFormatter objectFormatter, IField field, Object object, Comparator comparator) {
        super(objectFormatter);
        this.field = field;
        this.object = object;
        this.comparator = comparator;
    }

    public IField getField() {
        return this.field;
    }

    public void setField(IField field) {
        this.field = field;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        bf.append(" ");
        bf.append(this.comparator.getOperatore());
        if (this.object != null) {
            bf.append(" ");
            try {
                bf.append(super.getObjectFormatter().toString(this.object));
            }
            catch (Exception e) {
                return "ERROR: " + e.getMessage();
            }
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    @Override
    public boolean inUseField(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        return this.field.equals(field);
    }

    @Override
    public List<Object> getFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return null;
        }
        if (this.field.equals(field)) {
            ArrayList<Object> lista = new ArrayList<Object>();
            lista.add(this.object);
            return lista;
        }
        return null;
    }

    @Override
    public boolean inUseModel(IModel<?> model) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        if (model.getBaseField() != null) {
            if (this.field instanceof ComplexField) {
                ComplexField c = (ComplexField)this.field;
                return c.getFather().equals(model.getBaseField());
            }
            return model.getModeledClass().getName().equals(this.field.getClassType().getName());
        }
        return model.getModeledClass().getName().equals(this.field.getClassType().getName());
    }

    @Override
    public List<IField> getFields() throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return null;
        }
        ArrayList<IField> lista = new ArrayList<IField>();
        lista.add(this.field);
        return lista;
    }
}

