/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jpa;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.dao.jpa.JPAExpression;
import org.openspcoop2.generic_project.dao.jpa.JPAPaginatedExpression;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;

public class JPAUtilities {
    public static Query createQuery(EntityManager em, String queryPrefix, JPAExpression expression) throws ExpressionException, ExpressionNotImplementedException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        String sqlJPA = expression.toSqlForJPA(map);
        Query q = null;
        q = sqlJPA == null || "".equals(sqlJPA) ? em.createQuery(queryPrefix) : (expression.isWhereConditionsPresent() ? em.createQuery(queryPrefix + " " + sqlJPA) : em.createQuery(queryPrefix + " WHERE " + sqlJPA));
        Enumeration<String> ids = map.keys();
        while (ids.hasMoreElements()) {
            String id = ids.nextElement();
            Object val = map.get(id);
            if (val instanceof Calendar) {
                q.setParameter(id, ((Calendar)val).getTime(), TemporalType.TIMESTAMP);
                continue;
            }
            if (val instanceof Date) {
                q.setParameter(id, (Date)val, TemporalType.TIMESTAMP);
                continue;
            }
            if (val instanceof IEnumeration) {
                IEnumeration e = (IEnumeration)map.get(id);
                q.setParameter(id, (Object)e.toString());
                continue;
            }
            q.setParameter(id, map.get(id));
        }
        return q;
    }

    public static Query createQuery(EntityManager em, String queryPrefix, JPAPaginatedExpression expression) throws ExpressionException, ExpressionNotImplementedException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        String sqlJPA = expression.toSqlForJPA(map);
        Query q = null;
        q = sqlJPA == null || "".equals(sqlJPA) ? em.createQuery(queryPrefix) : (expression.isWhereConditionsPresent() ? em.createQuery(queryPrefix + " " + sqlJPA) : em.createQuery(queryPrefix + " WHERE " + sqlJPA));
        Enumeration<String> ids = map.keys();
        while (ids.hasMoreElements()) {
            String id = ids.nextElement();
            Object val = map.get(id);
            if (val instanceof Calendar) {
                q.setParameter(id, ((Calendar)val).getTime(), TemporalType.TIMESTAMP);
                continue;
            }
            if (val instanceof Date) {
                q.setParameter(id, (Date)val, TemporalType.TIMESTAMP);
                continue;
            }
            if (val instanceof IEnumeration) {
                IEnumeration e = (IEnumeration)map.get(id);
                q.setParameter(id, (Object)e.toString());
                continue;
            }
            q.setParameter(id, map.get(id));
        }
        return q;
    }
}

