/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jdbc.utils;

import java.net.URI;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCDefaultForXSDType;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class JDBCParameterUtilities {
    private TipiDatabase tipoDatabase = null;
    private IJDBCAdapter jdbcAdapter = null;

    public JDBCParameterUtilities(TipiDatabase tipoDatabaseOpenSPCoop2) throws SQLQueryObjectException, JDBCAdapterException {
        this.tipoDatabase = tipoDatabaseOpenSPCoop2;
        this.jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.tipoDatabase.getNome());
    }

    public void setParameters(PreparedStatement pstmt, JDBCObject ... params) throws SQLException, JDBCAdapterException, UtilsException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.setParameter(pstmt, i + 1, params[i]);
            }
        }
    }

    public void setParameter(PreparedStatement pstmt, int index, JDBCObject param) throws SQLException, JDBCAdapterException, UtilsException {
        Object value = param.getObject();
        Class<?> type = param.getTypeObject();
        if (value != null && value instanceof IEnumeration) {
            IEnumeration enumObject = (IEnumeration)value;
            Object valueEnum = enumObject.getValue();
            Class<?> cValueEnum = null;
            if (valueEnum != null) {
                cValueEnum = valueEnum.getClass();
            }
            JDBCObject jdbcObject = new JDBCObject(valueEnum, cValueEnum);
            this.setParameter(pstmt, index, jdbcObject);
        } else if (type.getName().equals(String.class.getName())) {
            String valueWrapped = null;
            if (value != null && value instanceof String) {
                valueWrapped = (String)value;
            } else if (value != null && value instanceof Character) {
                valueWrapped = ((Character)value).charValue() + "";
            } else if (value != null) {
                throw new UtilsException("Tipo[" + type.getName() + "] non compatibile con l'oggetto fornito[" + value.getClass().getName() + "]");
            }
            if (value == null) {
                pstmt.setNull(index, 12);
            } else {
                pstmt.setString(index, valueWrapped);
            }
        } else if (type.getName().equals(Character.class.getName())) {
            Character valueWrapped = null;
            String charValue = null;
            if (value != null) {
                valueWrapped = (Character)value;
                char charPrimitiveValue = valueWrapped.charValue();
                charValue = valueWrapped.charValue() + "";
                if (charPrimitiveValue == '\u0000') {
                    charValue = null;
                }
            }
            if (charValue != null) {
                pstmt.setString(index, charValue);
            } else {
                pstmt.setNull(index, 12);
            }
        } else if (type.getName().equals(Character.TYPE.getName())) {
            Character valueWrapped = null;
            String charValue = null;
            if (value != null) {
                valueWrapped = (Character)value;
                char charPrimitiveValue = valueWrapped.charValue();
                charValue = valueWrapped.charValue() + "";
                if (charPrimitiveValue == '\u0000') {
                    charValue = null;
                }
            }
            if (charValue != null) {
                pstmt.setString(index, charValue);
            } else {
                pstmt.setNull(index, 12);
            }
        } else if (type.getName().equals(Boolean.class.getName())) {
            if (value != null) {
                Boolean valueWrapped = (Boolean)value;
                pstmt.setBoolean(index, valueWrapped);
            } else if (TipiDatabase.ORACLE.equals(this.tipoDatabase) || TipiDatabase.DB2.equals(this.tipoDatabase)) {
                pstmt.setNull(index, 4);
            } else {
                pstmt.setNull(index, 16);
            }
        } else if (type.getName().equals(Boolean.TYPE.getName())) {
            if (value != null) {
                Boolean valueWrapped = (Boolean)value;
                pstmt.setBoolean(index, valueWrapped);
            } else if (TipiDatabase.ORACLE.equals(this.tipoDatabase) || TipiDatabase.DB2.equals(this.tipoDatabase)) {
                pstmt.setNull(index, 4);
            } else {
                pstmt.setNull(index, 16);
            }
        } else if (type.getName().equals(Byte.class.getName())) {
            if (value != null) {
                Byte valueWrapped = (Byte)value;
                pstmt.setInt(index, valueWrapped.intValue());
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.getName().equals(Byte.TYPE.getName())) {
            if (value != null) {
                Byte valueWrapped = (Byte)value;
                pstmt.setInt(index, valueWrapped.intValue());
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.getName().equals(Short.class.getName())) {
            if (value != null) {
                Short valueWrapped = (Short)value;
                pstmt.setShort(index, valueWrapped);
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.getName().equals(Short.TYPE.getName())) {
            if (value != null) {
                Short valueWrapped = (Short)value;
                pstmt.setShort(index, valueWrapped);
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.getName().equals(Integer.class.getName())) {
            if (value != null) {
                Integer valueWrapped = (Integer)value;
                pstmt.setInt(index, valueWrapped);
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.getName().equals(Integer.TYPE.getName())) {
            if (value != null) {
                Integer valueWrapped = (Integer)value;
                pstmt.setInt(index, valueWrapped);
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.getName().equals(Long.class.getName())) {
            if (value != null) {
                Long valueWrapped = (Long)value;
                pstmt.setLong(index, valueWrapped);
            } else {
                pstmt.setNull(index, -5);
            }
        } else if (type.getName().equals(Long.TYPE.getName())) {
            if (value != null) {
                Long valueWrapped = (Long)value;
                pstmt.setLong(index, valueWrapped);
            } else {
                pstmt.setNull(index, -5);
            }
        } else if (type.getName().equals(Double.class.getName())) {
            if (value != null) {
                Double valueWrapped = (Double)value;
                pstmt.setDouble(index, valueWrapped);
            } else {
                pstmt.setNull(index, 8);
            }
        } else if (type.getName().equals(Double.TYPE.getName())) {
            if (value != null) {
                Double valueWrapped = (Double)value;
                pstmt.setDouble(index, valueWrapped);
            } else {
                pstmt.setNull(index, 8);
            }
        } else if (type.getName().equals(Float.class.getName())) {
            if (value != null) {
                Float valueWrapped = (Float)value;
                pstmt.setFloat(index, valueWrapped.floatValue());
            } else {
                pstmt.setNull(index, 6);
            }
        } else if (type.getName().equals(Float.TYPE.getName())) {
            if (value != null) {
                Float valueWrapped = (Float)value;
                pstmt.setFloat(index, valueWrapped.floatValue());
            } else {
                pstmt.setNull(index, 6);
            }
        } else if (type.getName().equals(java.util.Date.class.getName())) {
            java.util.Date valueWrapped = null;
            if (value != null) {
                valueWrapped = (java.util.Date)value;
            }
            if (value != null) {
                pstmt.setTimestamp(index, new Timestamp(valueWrapped.getTime()));
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.getName().equals(Date.class.getName())) {
            Date valueWrapped = null;
            if (value != null) {
                valueWrapped = (Date)value;
            }
            if (value != null) {
                pstmt.setTimestamp(index, new Timestamp(valueWrapped.getTime()));
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.getName().equals(Timestamp.class.getName())) {
            if (value != null) {
                Timestamp valueWrapped = (Timestamp)value;
                pstmt.setTimestamp(index, valueWrapped);
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.getName().equals(Calendar.class.getName())) {
            Calendar valueWrapped = null;
            if (value != null) {
                valueWrapped = (Calendar)value;
            }
            if (value != null) {
                pstmt.setTimestamp(index, new Timestamp(valueWrapped.getTime().getTime()));
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.getName().equals(byte[].class.getName())) {
            byte[] valueWrapped = null;
            if (value != null) {
                valueWrapped = (byte[])value;
            }
            this.jdbcAdapter.setBinaryData(pstmt, index, valueWrapped);
        } else if (type.getName().equals(URI.class.getName())) {
            if (value != null) {
                URI valueWrapped = (URI)value;
                pstmt.setString(index, valueWrapped.toString());
            } else {
                pstmt.setNull(index, 93);
            }
        } else {
            throw new SQLException("Tipo di oggetto (posizione " + index + ") non gestito: " + type.getClass().getName() + " - " + type);
        }
    }

    public String readStringParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (String)this.readParameter(rs, index, String.class);
    }

    public String readStringParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (String)this.readParameter(rs, name, String.class);
    }

    public Character readCharParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Character)this.readParameter(rs, index, Character.class);
    }

    public Character readCharParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Character)this.readParameter(rs, name, Character.class);
    }

    public Boolean readBooleanParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Boolean)this.readParameter(rs, index, Boolean.class);
    }

    public Boolean readBooleanParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Boolean)this.readParameter(rs, name, Boolean.class);
    }

    public Byte readByteParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Byte)this.readParameter(rs, index, Byte.class);
    }

    public Byte readByteParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Byte)this.readParameter(rs, name, Byte.class);
    }

    public Short readShortParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Short)this.readParameter(rs, index, Short.class);
    }

    public Short readShortParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Short)this.readParameter(rs, name, Short.class);
    }

    public Integer readIntegerParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Integer)this.readParameter(rs, index, Integer.class);
    }

    public Integer readIntegerParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Integer)this.readParameter(rs, name, Integer.class);
    }

    public Long readLongParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Long)this.readParameter(rs, index, Long.class);
    }

    public Long readLongParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Long)this.readParameter(rs, name, Long.class);
    }

    public Double readDoubleParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Double)this.readParameter(rs, index, Double.class);
    }

    public Double readDoubleParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Double)this.readParameter(rs, name, Double.class);
    }

    public Float readFloatParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Float)this.readParameter(rs, index, Float.class);
    }

    public Float readFloatParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Float)this.readParameter(rs, name, Float.class);
    }

    public java.util.Date readDateParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (java.util.Date)this.readParameter(rs, index, java.util.Date.class);
    }

    public java.util.Date readDateParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (java.util.Date)this.readParameter(rs, name, java.util.Date.class);
    }

    public Date readSqlDateParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Date)this.readParameter(rs, index, Date.class);
    }

    public Date readSqlDateParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Date)this.readParameter(rs, name, Date.class);
    }

    public Timestamp readTimestampParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Timestamp)this.readParameter(rs, index, Timestamp.class);
    }

    public Timestamp readTimestampParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Timestamp)this.readParameter(rs, name, Timestamp.class);
    }

    public Calendar readCalendarParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Calendar)this.readParameter(rs, index, Calendar.class);
    }

    public Calendar readCalendarParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Calendar)this.readParameter(rs, name, Calendar.class);
    }

    public URI readURIParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (URI)this.readParameter(rs, index, URI.class);
    }

    public URI readURIParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (URI)this.readParameter(rs, name, URI.class);
    }

    public Object readParameter(ResultSet rs, int index, Class<?> type) throws SQLException, UtilsException {
        return this.readParameter(rs, index, null, type, JDBCDefaultForXSDType.NONE);
    }

    public Object readParameter(ResultSet rs, String name, Class<?> type) throws SQLException, UtilsException {
        return this.readParameter(rs, -1, name, type, JDBCDefaultForXSDType.NONE);
    }

    public Object readParameter(ResultSet rs, String name, Class<?> type, JDBCDefaultForXSDType jdbcDefaultForXSDType) throws SQLException, UtilsException {
        return this.readParameter(rs, -1, name, type, jdbcDefaultForXSDType);
    }

    private Object readParameter(ResultSet rs, int index, String name, Class<?> type, JDBCDefaultForXSDType jdbcDefaultForXSDType) throws SQLException, UtilsException {
        if (type.toString().equals(String.class.toString())) {
            if (name != null) {
                return rs.getString(name);
            }
            return rs.getString(index);
        }
        if (type.toString().equals(Character.class.toString()) || type.toString().equals(Character.TYPE.toString())) {
            String s = null;
            s = name != null ? rs.getString(name) : rs.getString(index);
            if (s != null) {
                return new Character(s.charAt(0));
            }
            if (type.toString().equals(Character.TYPE.toString())) {
                return Character.valueOf('\u0000');
            }
            return null;
        }
        if (type.toString().equals(Boolean.class.toString()) || type.toString().equals(Boolean.TYPE.toString())) {
            boolean booleanValue = name != null ? rs.getBoolean(name) : rs.getBoolean(index);
            if (type.toString().equals(Boolean.class.toString()) && rs.wasNull()) {
                return null;
            }
            return booleanValue;
        }
        if (type.toString().equals(Byte.class.toString()) || type.toString().equals(Byte.TYPE.toString())) {
            byte byteValue = name != null ? (byte)rs.getInt(name) : (byte)rs.getInt(index);
            if (byteValue == 0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Byte.class.toString()) && rs.wasNull()) {
                return null;
            }
            return byteValue;
        }
        if (type.toString().equals(Short.class.toString()) || type.toString().equals(Short.TYPE.toString())) {
            short shortValue = name != null ? rs.getShort(name) : rs.getShort(index);
            if (shortValue == 0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Short.class.toString()) && rs.wasNull()) {
                return null;
            }
            return shortValue;
        }
        if (type.toString().equals(Integer.class.toString()) || type.toString().equals(Integer.TYPE.toString())) {
            int intValue = name != null ? rs.getInt(name) : rs.getInt(index);
            if (intValue == 0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Integer.class.toString()) && rs.wasNull()) {
                return null;
            }
            return intValue;
        }
        if (type.toString().equals(Long.class.toString()) || type.toString().equals(Long.TYPE.toString())) {
            long longValue = name != null ? rs.getLong(name) : rs.getLong(index);
            if (longValue == 0L && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Long.class.toString()) && rs.wasNull()) {
                return null;
            }
            return longValue;
        }
        if (type.toString().equals(Double.class.toString()) || type.toString().equals(Double.TYPE.toString())) {
            double doubleValue = name != null ? rs.getDouble(name) : rs.getDouble(index);
            if (doubleValue == 0.0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Double.class.toString()) && rs.wasNull()) {
                return null;
            }
            return doubleValue;
        }
        if (type.toString().equals(Float.class.toString()) || type.toString().equals(Float.TYPE.toString())) {
            float floatValue = name != null ? rs.getFloat(name) : rs.getFloat(index);
            if (floatValue == 0.0f && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Float.class.toString()) && rs.wasNull()) {
                return null;
            }
            return Float.valueOf(floatValue);
        }
        if (type.toString().equals(java.util.Date.class.toString())) {
            Timestamp ts = null;
            ts = name != null ? rs.getTimestamp(name) : rs.getTimestamp(index);
            if (ts != null) {
                return new java.util.Date(ts.getTime());
            }
            return null;
        }
        if (type.toString().equals(Date.class.toString())) {
            Timestamp ts = null;
            ts = name != null ? rs.getTimestamp(name) : rs.getTimestamp(index);
            if (ts != null) {
                return new Date(ts.getTime());
            }
            return null;
        }
        if (type.toString().equals(Timestamp.class.toString())) {
            if (name != null) {
                return rs.getTimestamp(name);
            }
            return rs.getTimestamp(index);
        }
        if (type.toString().equals(Calendar.class.toString())) {
            Timestamp ts = null;
            ts = name != null ? rs.getTimestamp(name) : rs.getTimestamp(index);
            if (ts != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(new java.util.Date(ts.getTime()));
                return c;
            }
            return null;
        }
        if (type.getName().equals(byte[].class.getName())) {
            if (name != null) {
                return this.jdbcAdapter.getBinaryData(rs, name);
            }
            return this.jdbcAdapter.getBinaryData(rs, index);
        }
        if (type.getName().equals(URI.class.getName())) {
            String uri = null;
            uri = name != null ? rs.getString(name) : rs.getString(index);
            if (uri != null) {
                try {
                    return new URI(uri);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }
        if (name != null) {
            throw new SQLException("Tipo di oggetto (nome " + name + ") non gestito: " + type.getClass().getName() + " - " + type);
        }
        throw new SQLException("Tipo di oggetto (posizione " + index + ") non gestito: " + type.getClass().getName() + " - " + type);
    }
}

