/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import java.util.Date;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class UnixTimestampIntervalField
extends CustomField {
    public UnixTimestampIntervalField(String fieldName, ISQLFieldConverter fieldConverter, boolean appendTablePrefix, IField maxInterval, IField minInterval) throws ExpressionException, SQLQueryObjectException {
        super(fieldName, Long.class, UnixTimestampIntervalField.buildFunction(fieldConverter, appendTablePrefix, maxInterval, minInterval), fieldName, "", "");
    }

    private static String buildFunction(ISQLFieldConverter fieldConverter, boolean appendTablePrefix, IField maxInterval, IField minInterval) throws ExpressionException, SQLQueryObjectException {
        if (maxInterval == null) {
            throw new ExpressionException("MaxInterval is null");
        }
        if (minInterval == null) {
            throw new ExpressionException("MinInterval is null");
        }
        if (!Date.class.getName().equals(maxInterval.getFieldType().getName())) {
            throw new ExpressionException("MaxInterval with wrong type, expected:" + Date.class.getName() + " found:" + maxInterval.getFieldType());
        }
        if (!Date.class.getName().equals(minInterval.getFieldType().getName())) {
            throw new ExpressionException("MinInterval with wrong type, expected:" + Date.class.getName() + " found:" + minInterval.getFieldType());
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((TipiDatabase)fieldConverter.getDatabaseType());
        return sqlQueryObject.getDiffUnixTimestamp(fieldConverter.toColumn(maxInterval, appendTablePrefix), fieldConverter.toColumn(minInterval, appendTablePrefix));
    }
}

