/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.UnionOrderedColumn;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.SortOrder;

public class Union {
    private boolean unionAll;
    private List<String> fields = new ArrayList<String>();
    private Hashtable<String, Function> mapFieldsToFunction = new Hashtable();
    private Hashtable<String, String> mapFieldsToAliasFunction = new Hashtable();
    private SortOrder sortOrder = null;
    private List<UnionOrderedColumn> orderByList = new ArrayList<UnionOrderedColumn>();
    private List<String> groupByList = new ArrayList<String>();
    private Integer offset = null;
    private Integer limit = null;

    public boolean isUnionAll() {
        return this.unionAll;
    }

    public void setUnionAll(boolean unionAll) {
        this.unionAll = unionAll;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Function getFunction(String alias) {
        return this.mapFieldsToFunction.get(alias);
    }

    public String getParamAliasFunction(String alias) {
        return this.mapFieldsToAliasFunction.get(alias);
    }

    public void addField(String alias) throws ExpressionException {
        if (this.fields.contains(alias)) {
            throw new ExpressionException("Alias[" + alias + "] already used");
        }
        this.fields.add(alias);
    }

    public void addField(String alias, Function function, String functionParamAlias) throws ExpressionException {
        if (this.fields.contains(alias)) {
            throw new ExpressionException("Alias[" + alias + "] already used");
        }
        this.fields.add(alias);
        this.mapFieldsToFunction.put(alias, function);
        this.mapFieldsToAliasFunction.put(alias, functionParamAlias);
    }

    public SortOrder getSortOrder() throws ExpressionException {
        if ((this.sortOrder == null || SortOrder.UNSORTED.equals(this.sortOrder)) && this.orderByList != null && this.orderByList.size() > 0) {
            for (UnionOrderedColumn unionOrderedColumn : this.orderByList) {
                if (unionOrderedColumn.getSortOrder() == null) continue;
                return unionOrderedColumn.getSortOrder();
            }
            throw new ExpressionException("To add order by conditions must first be defined the sort order (by sortOrder method or as parameter by addOrderBy method)");
        }
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void addOrderBy(String alias) {
        UnionOrderedColumn uoo = new UnionOrderedColumn(alias);
        this.orderByList.add(uoo);
    }

    public void addOrderBy(String alias, SortOrder sortOrder) throws ExpressionException {
        if (sortOrder == null) {
            throw new ExpressionException("Sort order parameter undefined");
        }
        if (SortOrder.UNSORTED.equals(sortOrder)) {
            throw new ExpressionException("Sort order parameter not valid (use ASC or DESC)");
        }
        UnionOrderedColumn uoo = new UnionOrderedColumn(alias, sortOrder);
        this.orderByList.add(uoo);
    }

    public List<UnionOrderedColumn> getOrderByList() {
        return this.orderByList;
    }

    public void addGroupBy(String alias) {
        this.groupByList.add(alias);
    }

    public List<String> getGroupByList() {
        return this.groupByList;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

