/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DynamicNamespaceContext
implements NamespaceContext {
    private Properties context = new Properties();
    private String prefixChildSoapBody = null;
    private boolean soapFault = false;
    private boolean soapBodyEmpty = false;

    public Object clone() {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        if (this.context != null) {
            dnc.context = new Properties();
            if (this.context.size() > 0) {
                for (Object key : this.context.keySet()) {
                    dnc.context.put(key, this.context.get(key));
                }
            }
        }
        if (this.prefixChildSoapBody != null) {
            dnc.prefixChildSoapBody = new String(this.prefixChildSoapBody);
        }
        dnc.soapFault = this.soapFault;
        dnc.soapBodyEmpty = this.soapBodyEmpty;
        return dnc;
    }

    public boolean isSoapBodyEmpty() {
        return this.soapBodyEmpty;
    }

    public void setSoapBodyEmpty(boolean soapBodyEmpty) {
        this.soapBodyEmpty = soapBodyEmpty;
    }

    public boolean isSoapFault() {
        return this.soapFault;
    }

    public void setSoapFault(boolean soapFault) {
        this.soapFault = soapFault;
    }

    public String getPrefixChildSoapBody() {
        return this.prefixChildSoapBody;
    }

    public void setPrefixChildSoapBody(String prefixChildSoapBody) {
        this.prefixChildSoapBody = prefixChildSoapBody;
    }

    public DynamicNamespaceContext() {
        this.context.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.context.put("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public void addNamespace(String prefix, String url) {
        if (!this.context.containsKey(prefix)) {
            this.context.setProperty(prefix, url);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix [" + prefix + "] not defined");
        }
        if ("".equals(prefix)) {
            if (this.context.containsKey(prefix)) {
                return this.context.getProperty(prefix);
            }
            return "";
        }
        if ("xml".equals(prefix)) {
            return this.context.getProperty(prefix);
        }
        if ("xmlns".equals(prefix)) {
            return this.context.getProperty(prefix);
        }
        if (this.context.containsKey(prefix)) {
            Enumeration<?> en = this.context.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!key.equals(prefix)) continue;
                return this.context.getProperty(key);
            }
        }
        return "";
    }

    @Override
    public String getPrefix(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace [" + namespace + "] not defined");
        }
        if (this.context.containsValue(namespace)) {
            Enumeration<?> en = this.context.propertyNames();
            while (en.hasMoreElements()) {
                String prefix = (String)en.nextElement();
                if (!this.context.getProperty(prefix).equals(namespace)) continue;
                return prefix;
            }
        }
        return "";
    }

    @Override
    public Iterator<String> getPrefixes(String namespace) {
        ArrayList<String> v = new ArrayList<String>();
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace [" + namespace + "] not defined");
        }
        if (this.context.containsValue(namespace)) {
            Enumeration<?> en = this.context.propertyNames();
            while (en.hasMoreElements()) {
                String prefix = (String)en.nextElement();
                if (!this.context.getProperty(prefix).equals(namespace)) continue;
                v.add(prefix);
            }
            return v.iterator();
        }
        return v.iterator();
    }

    public Enumeration<?> getPrefixes() {
        return this.context.keys();
    }

    public void findPrefixNamespace(Node node) {
        NamedNodeMap mapAttribute;
        int i;
        NodeList list;
        if (node == null) {
            return;
        }
        String namespace = node.getNamespaceURI();
        if (namespace != null && !"".equals(namespace)) {
            String prefix = node.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            this.addNamespace(prefix, node.getNamespaceURI());
        }
        if ((list = node.getChildNodes()) != null) {
            int nodes = list.getLength();
            for (i = 0; i < nodes; ++i) {
                Node child = list.item(i);
                this.findPrefixNamespace(child);
            }
        }
        if ((mapAttribute = node.getAttributes()) != null && mapAttribute.getLength() > 0) {
            for (i = 0; i < mapAttribute.getLength(); ++i) {
                String prefix;
                Attr attr;
                Node n = mapAttribute.item(i);
                if (!(n instanceof Attr) || !"http://www.w3.org/2000/xmlns/".equals((attr = (Attr)n).getNamespaceURI()) || (prefix = attr.getLocalName()) == null || "xmlns".equals(prefix) || !"xmlns".equals(attr.getPrefix()) || attr.getNodeValue() == null || "".equals(attr.getNodeValue())) continue;
                this.addNamespace(prefix, attr.getNodeValue());
            }
        }
    }
}

