/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.ResourceTypeNode;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.wadl.MessageListener;
import org.openspcoop2.utils.wadl.SchemaCallback;
import org.openspcoop2.utils.wadl.WADLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLException;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class WADLReader {
    private SchemaCallback schemaCallback;
    private boolean processInclude;
    private MessageListener messageListener;
    private WadlAstBuilder wadlBuilder;
    private AbstractXMLUtils xmlUtils;
    private WADLUtilities wadlUtilities;
    private Logger log;

    public WADLReader(Logger log, AbstractXMLUtils xmlUtils, boolean verbose, boolean processInclude, boolean processInlineSchema) {
        this.log = log;
        this.xmlUtils = xmlUtils;
        this.wadlUtilities = new WADLUtilities(this.xmlUtils);
        this.schemaCallback = new SchemaCallback(this.log, this.xmlUtils, processInclude, processInlineSchema);
        this.processInclude = processInclude;
        this.messageListener = new MessageListener(this.log, verbose, true);
        this.wadlBuilder = new WadlAstBuilder((WadlAstBuilder.SchemaCallback)this.schemaCallback, (org.jvnet.ws.wadl.util.MessageListener)this.messageListener);
    }

    public void addSchema(String name, byte[] content) throws XMLException {
        this.schemaCallback.addResource(name, content);
    }

    public ApplicationNode readWADL(String file) throws InvalidWADLException, IOException {
        return this.readWADL(new File(file));
    }

    public ApplicationNode readWADL(File file) throws InvalidWADLException, IOException {
        File fTpm = null;
        try {
            if (this.processInclude) {
                ApplicationNode applicationNode = this.wadlBuilder.buildAst(file.toURI());
                return applicationNode;
            }
            byte[] wadl = FileSystemUtilities.readBytesFromFile(file);
            Document d = this.xmlUtils.newDocument(wadl);
            this.wadlUtilities.removeIncludes(d);
            fTpm = FileSystemUtilities.createTempFile("wadl", "tmp");
            this.xmlUtils.writeTo(d, fTpm);
            ApplicationNode applicationNode = this.wadlBuilder.buildAst(fTpm.toURI());
            return applicationNode;
        }
        catch (InvalidWADLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (fTpm == null || !fTpm.delete()) {
                // empty if block
            }
        }
    }

    public ApplicationNode readWADL(URI uri) throws InvalidWADLException, IOException {
        if (this.processInclude) {
            return this.wadlBuilder.buildAst(uri);
        }
        return this.readWADL(new File(uri));
    }

    public Map<String, ResourceTypeNode> getInterfaceMap() {
        return this.wadlBuilder.getInterfaceMap();
    }

    public Map<String, byte[]> getResources() {
        return this.schemaCallback.getResources();
    }

    public Map<String, List<String>> getMappingNamespaceLocations() {
        return this.schemaCallback.getMappingNamespaceLocations();
    }
}

