/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.threads;

import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.threads.IRunnableInstance;
import org.openspcoop2.utils.threads.RunnableLogger;

public class Runnable
extends Thread {
    private RunnableLogger log = null;
    private boolean stop = false;
    private boolean finished = false;
    private int checkIntervalMs = -1;
    private IRunnableInstance instance;
    private boolean initialized = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Runnable(RunnableLogger runnableLogger, IRunnableInstance instance, int checkIntervalMs) throws UtilsException {
        this.initialized = true;
        this.log = runnableLogger;
        this.instance = instance;
        this.checkIntervalMs = checkIntervalMs;
        this.instance.initialize(runnableLogger);
        this.log.info("Avviato");
    }

    public Runnable(IRunnableInstance instance, int checkIntervalMs) throws UtilsException {
        this.instance = instance;
        this.checkIntervalMs = checkIntervalMs;
    }

    public void initialize(RunnableLogger runnableLogger) throws UtilsException {
        this.initialized = true;
        this.log = runnableLogger;
        this.instance.initialize(runnableLogger);
        this.log.info("Avviato");
    }

    public String getIdentifier() {
        return this.instance.getIdentifier();
    }

    @Override
    public void run() {
        if (!this.initialized) {
            return;
        }
        while (!this.stop) {
            try {
                this.instance.check();
            }
            catch (Exception e) {
                this.log.error("Errore generale: " + e.getMessage(), e);
            }
            if (!this.instance.isContinuousRunning()) {
                this.stop = true;
            }
            if (this.stop) continue;
            if (this.checkIntervalMs <= 1000) {
                Utilities.sleep(1000L);
                continue;
            }
            int checkIntervalSeconds = this.checkIntervalMs / 1000;
            int checkInterval_resto = this.checkIntervalMs % 1000;
            for (int i = 0; i < checkIntervalSeconds; ++i) {
                Utilities.sleep(1000L);
                if (this.stop) break;
            }
            if (this.stop || checkInterval_resto <= 0) continue;
            Utilities.sleep(checkInterval_resto);
        }
        this.finished = true;
    }
}

