/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.sql.CastColumnType;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class Case {
    private List<String> condizioni = new ArrayList<String>();
    private List<String> valori = new ArrayList<String>();
    private CastColumnType tipoColonna;
    private int dimensioneColonna = 255;
    private String valoreDefault;
    private boolean stringValueType = false;

    public Case(CastColumnType type) throws SQLQueryObjectException {
        this.stringValueType = false;
        this.tipoColonna = type;
        if (this.tipoColonna == null) {
            throw new SQLQueryObjectException("Tipo Colonna non fornito");
        }
    }

    public Case(CastColumnType type, String valoreDefault) throws SQLQueryObjectException {
        this(type, false, valoreDefault);
    }

    public Case(CastColumnType type, boolean stringValueType, String valoreDefault) throws SQLQueryObjectException {
        this.stringValueType = stringValueType;
        if (valoreDefault == null) {
            throw new SQLQueryObjectException("Valore di default non fornito");
        }
        this.valoreDefault = valoreDefault;
        this.tipoColonna = type;
        if (this.tipoColonna == null) {
            throw new SQLQueryObjectException("Tipo Colonna non fornito");
        }
    }

    public void addCase(String condizione, String valore) throws SQLQueryObjectException {
        this.condizioni.add(condizione);
        this.valori.add(valore);
        if (condizione == null) {
            throw new SQLQueryObjectException("Condizione non fornita");
        }
        if (valore == null) {
            throw new SQLQueryObjectException("Valore non fornito");
        }
    }

    public List<String> getCondizioni() {
        return this.condizioni;
    }

    public List<String> getValori() {
        return this.valori;
    }

    public boolean isStringValueType() {
        return this.stringValueType;
    }

    public void setStringValueType(boolean stringValueType) {
        this.stringValueType = stringValueType;
    }

    public String getValoreDefault() {
        return this.valoreDefault;
    }

    public CastColumnType getTipoColonna() {
        return this.tipoColonna;
    }

    public int getDimensioneColonna() {
        return this.dimensioneColonna;
    }

    public void setDimensioneColonna(int dimensioneColonna) {
        this.dimensioneColonna = dimensioneColonna;
    }
}

