/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.fault.jaxrs;

import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemRFC7807;
import org.openspcoop2.utils.transport.http.HttpUtilities;

public class FaultCode {
    public static final FaultCode RICHIESTA_NON_VALIDA = new FaultCode(400, "RICHIESTA NON VALIDA", "Richiesta non correttamente formata");
    public static final FaultCode AUTENTICAZIONE = new FaultCode(401, "AUTENTICAZIONE", "Mittente della richiesta non autenticato");
    public static final FaultCode AUTORIZZAZIONE = new FaultCode(403, "AUTORIZZAZIONE", "Richiesta non permessa");
    public static final FaultCode NOT_FOUND = new FaultCode(404, "NOT_FOUND", "Risorsa non trovata");
    public static final FaultCode CONFLITTO = new FaultCode(409, "CONFLITTO", "L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente");
    public static final FaultCode RICHIESTA_NON_VALIDA_SEMANTICAMENTE = new FaultCode(422, "RICHIESTA NON VALIDA SEMANTICAMENTE", "Richiesta non processabile");
    public static final FaultCode ERRORE_INTERNO = new FaultCode(500, "ERRORE INTERNO", "Errore interno");
    public static final FaultCode STATUS_OK = new FaultCode(200, "STATUS OK", "Il servizio funziona correttamente");
    private final String name;
    private final String descrizione;
    private final int code;

    public FaultCode(int code, String name, String descrizione) {
        this.code = code;
        this.name = name;
        this.descrizione = descrizione;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public String toString() {
        return this.descrizione;
    }

    public ProblemRFC7807 toFault() {
        ProblemRFC7807 problem = new ProblemRFC7807();
        problem.setType("https://httpstatuses.com/" + this.code);
        problem.setStatus(this.code);
        problem.setTitle(HttpUtilities.getHttpReason(this.code));
        problem.setDetail(this.descrizione);
        return problem;
    }

    public ProblemRFC7807 toFault(String dettaglio) {
        ProblemRFC7807 problem = this.toFault();
        problem.setDetail(dettaglio);
        return problem;
    }

    public ProblemRFC7807 toFault(Throwable e) {
        ProblemRFC7807 problem = this.toFault();
        problem.setDetail(e.getMessage());
        return problem;
    }

    public Response.ResponseBuilder toFaultResponseBuilder() {
        return this.toFaultResponseBuilder(true);
    }

    public Response.ResponseBuilder toFaultResponseBuilder(boolean addFault) {
        ProblemRFC7807 problem = this.toFault();
        Response.ResponseBuilder rb = Response.status((int)this.code);
        if (addFault) {
            rb.entity((Object)problem).type("application/problem+json");
        }
        return rb;
    }

    public Response.ResponseBuilder toFaultResponseBuilder(String dettaglio) {
        ProblemRFC7807 problem = this.toFault(dettaglio);
        return Response.status((int)this.code).entity((Object)problem).type("application/problem+json");
    }

    public Response.ResponseBuilder toFaultResponseBuilder(Throwable e) {
        ProblemRFC7807 problem = this.toFault(e);
        return Response.status((int)this.code).entity((Object)problem).type("application/problem+json");
    }

    public Response toFaultResponse() {
        return this.toFaultResponse(true);
    }

    public Response toFaultResponse(boolean addFault) {
        return this.toFaultResponseBuilder(addFault).build();
    }

    public Response toFaultResponse(String dettaglio) {
        return this.toFaultResponseBuilder(dettaglio).build();
    }

    public Response toFaultResponse(Throwable e) {
        return this.toFaultResponseBuilder(e).build();
    }

    public WebApplicationException toException(Response.ResponseBuilder responseBuilder) {
        return new WebApplicationException(responseBuilder.build());
    }

    public WebApplicationException toException(Response.ResponseBuilder responseBuilder, Map<String, String> headers) {
        if (headers != null && !headers.isEmpty()) {
            headers.keySet().stream().forEach(k -> responseBuilder.header(k, headers.get(k)));
        }
        return new WebApplicationException(responseBuilder.build());
    }

    public WebApplicationException toException(Response response) {
        return this.toException(response, null);
    }

    public WebApplicationException toException(Response response, Throwable e) {
        Exception exception = null;
        String msgException = response.getEntity().toString();
        exception = e != null ? new Exception(msgException, e) : new Exception(msgException);
        return new WebApplicationException((Throwable)exception, response);
    }

    public WebApplicationException toException() {
        return this.toException(true);
    }

    public WebApplicationException toException(boolean addFault) {
        Response r = this.toFaultResponse(addFault);
        return this.toException(r);
    }

    public WebApplicationException toException(String dettaglio) {
        Response r = this.toFaultResponse(dettaglio);
        return this.toException(r);
    }

    public WebApplicationException toException(Throwable e) {
        Response r = this.toFaultResponse(e);
        return this.toException(r, e);
    }

    public void throwException(Response.ResponseBuilder responseBuilder) throws WebApplicationException {
        throw this.toException(responseBuilder);
    }

    public void throwException(Response response) throws WebApplicationException {
        throw this.toException(response);
    }

    public void throwException() throws WebApplicationException {
        throw this.toException();
    }

    public void throwException(boolean addFault) throws WebApplicationException {
        throw this.toException(addFault);
    }

    public void throwException(String dettaglio) throws WebApplicationException {
        throw this.toException(dettaglio);
    }

    public void throwException(Throwable e) throws WebApplicationException {
        throw this.toException(e);
    }
}

