/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context.server;

import org.apache.cxf.interceptor.Fault;
import org.openspcoop2.utils.logger.beans.context.core.Role;
import org.openspcoop2.utils.service.context.dump.DumpConfig;
import org.openspcoop2.utils.service.context.dump.DumpRequest;
import org.openspcoop2.utils.service.context.dump.DumpResponse;
import org.openspcoop2.utils.service.context.dump.DumpUtilities;
import org.openspcoop2.utils.service.context.server.ServerConfig;
import org.openspcoop2.utils.service.context.server.ServerInfoRequest;
import org.openspcoop2.utils.service.context.server.ServerInfoResponse;
import org.openspcoop2.utils.service.context.server.ServerInfoUtilities;

public class ServerInfoContextManuallyAdd {
    private ServerConfig serverConfig;
    private ServerInfoUtilities utilities;
    private DumpUtilities dumpUtilities;
    private DumpConfig dumpConfig;

    public ServerInfoContextManuallyAdd(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.utilities = new ServerInfoUtilities(this.serverConfig);
        this.dumpConfig = this.serverConfig.getDumpConfig();
        if (this.dumpConfig == null) {
            this.dumpConfig = new DumpConfig();
        }
        this.dumpConfig.setRole(Role.CLIENT);
        if (this.serverConfig.isDump() && this.serverConfig.getDumpConfig() == null) {
            this.serverConfig.setDumpConfig(this.dumpConfig);
        }
        this.dumpUtilities = new DumpUtilities(this.serverConfig);
    }

    public void processBeforeSend(ServerInfoRequest request) throws Fault {
        this.processBeforeSend(request, null);
    }

    public void processBeforeSend(ServerInfoRequest request, DumpRequest dumpRequest) throws Fault {
        this.utilities.processBeforeSend(request);
        if (this.serverConfig.isDump() && dumpRequest != null) {
            this.dumpUtilities.processBeforeSend(dumpRequest);
        }
    }

    public void processAfterSend(ServerInfoResponse response) throws Fault {
        this.processAfterSend(response, null);
    }

    public void processAfterSend(ServerInfoResponse response, DumpResponse DumpResponse2) throws Fault {
        this.utilities.processAfterSend(response);
        if (this.serverConfig.isDump() && DumpResponse2 != null) {
            this.dumpUtilities.processAfterSend(DumpResponse2);
        }
    }
}

