/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context.server;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.openspcoop2.utils.logger.beans.context.core.Role;
import org.openspcoop2.utils.service.context.dump.DumpConfig;
import org.openspcoop2.utils.service.context.dump.DumpFeature;
import org.openspcoop2.utils.service.context.server.ServerConfig;
import org.openspcoop2.utils.service.context.server.ServerInfoInInterceptor;
import org.openspcoop2.utils.service.context.server.ServerInfoOutInterceptor;
import org.openspcoop2.utils.service.context.server.ServerInfoUtilities;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class ServerInfoContextFeature
extends AbstractFeature {
    private ServerInfoInInterceptor in = new ServerInfoInInterceptor();
    private ServerInfoOutInterceptor out = new ServerInfoOutInterceptor();
    private ServerConfig serverConfig;

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        ServerInfoUtilities.checkOperationId(this.serverConfig);
        this.in.setServerConfig(this.serverConfig);
        this.out.setServerConfig(this.serverConfig);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (this.serverConfig == null) {
            this.serverConfig = new ServerConfig();
            ServerInfoUtilities.checkOperationId(this.serverConfig);
            this.in.setServerConfig(this.serverConfig);
            this.out.setServerConfig(this.serverConfig);
        }
        provider.getInInterceptors().add(this.in);
        provider.getInFaultInterceptors().add(this.in);
        provider.getOutInterceptors().add(this.out);
        provider.getOutFaultInterceptors().add(this.out);
        if (this.serverConfig.isDump()) {
            DumpFeature dumpFeature = new DumpFeature();
            DumpConfig dumpConfig = this.serverConfig.getDumpConfig();
            if (dumpConfig == null) {
                dumpConfig = new DumpConfig();
            }
            dumpConfig.setRole(Role.CLIENT);
            dumpFeature.setDumpConfig(dumpConfig);
            dumpFeature.setServerConfig(this.serverConfig);
            dumpFeature.doInitializeProvider(provider, bus);
        }
    }
}

