/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.logger.beans.context.core.AbstractContext;
import org.openspcoop2.utils.logger.beans.context.core.Service;
import org.openspcoop2.utils.service.context.ContextConfig;
import org.openspcoop2.utils.service.context.ContextFactory;
import org.openspcoop2.utils.service.context.ContextThreadLocal;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.context.IContextFactory;
import org.slf4j.MDC;

public class ContextInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private IContextFactory contextFactory = new ContextFactory();
    private ContextConfig contextConfig = null;

    public ContextInInterceptor() {
        super("receive");
    }

    public IContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(IContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }

    public void handleMessage(Message message) throws Fault {
        try {
            AbstractContext applicationContext;
            IContext context = this.contextFactory.newContext();
            if (context.getApplicationContext() instanceof AbstractContext && (applicationContext = context.getApplicationContext()).getTransaction() != null) {
                applicationContext.getTransaction().setContext(this.contextConfig.getContext());
                applicationContext.getTransaction().setDomain(this.contextConfig.getDomain());
                applicationContext.getTransaction().setRole(this.contextConfig.getRole());
                if (this.contextConfig.getServiceType() != null || this.contextConfig.getServiceName() != null || this.contextConfig.getServiceVersion() != null) {
                    Service service = new Service();
                    service.setType(this.contextConfig.getServiceType());
                    service.setName(this.contextConfig.getServiceName());
                    service.setVersion(this.contextConfig.getServiceVersion());
                    applicationContext.getTransaction().setService(service);
                }
                applicationContext.getTransaction().setClusterId(this.contextConfig.getClusterId());
            }
            ContextThreadLocal.set(context);
            MDC.put((String)"transactionId", (String)context.getTransactionId());
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(ContextInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }
}

