/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.beans.utils;

import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.service.beans.Lista;
import org.openspcoop2.utils.service.beans.ListaSenzaTotale;

public class ListaUtils {
    public static final Lista costruisciListaPaginata(UriInfo uriInfo, Integer offset, Integer limit, long total) throws InstantiationException, IllegalAccessException {
        return ListaUtils.costruisciListaPaginata(uriInfo, offset, limit, total, Lista.class);
    }

    public static final Lista costruisciListaPaginata(String requestURI, Integer offset, Integer limit, long total) throws InstantiationException, IllegalAccessException {
        return ListaUtils.costruisciListaPaginata(requestURI, offset, limit, total, Lista.class);
    }

    public static final <T extends Lista> T costruisciListaPaginata(UriInfo uriInfo, Integer offset, Integer limit, long total, Class<T> lclass) throws InstantiationException, IllegalAccessException {
        return ListaUtils.costruisciListaPaginata(ListaUtils.getUrl(uriInfo), offset, limit, total, lclass);
    }

    public static final <T extends Lista> T costruisciListaPaginata(String requestURI, Integer offset, Integer limit, long total, Class<T> lclass) throws InstantiationException, IllegalAccessException {
        int realLimit;
        Lista l = (Lista)Utilities.newInstanceThrowInstantiationException(lclass);
        if (total < 0L) {
            throw new IllegalArgumentException("Il numero totale di elementi deve essere positivo");
        }
        l = (Lista)ListaUtils._costruisciLista(requestURI, offset, limit, total, -1L, lclass);
        int realOffset = offset == null || offset < 0 ? 0 : offset;
        int n = realLimit = limit == null || limit <= 0 ? -1 : limit;
        if (realLimit > 0) {
            int paginaCorrente;
            long numeroPagineTotali = total / (long)realLimit;
            long resto = total % (long)realLimit;
            if (resto > 0L) {
                ++numeroPagineTotali;
            }
            if ((long)(paginaCorrente = realOffset / realLimit + 1) < numeroPagineTotali) {
                long lastOffset = (numeroPagineTotali - 1L) * (long)realLimit;
                if (limit == null) {
                    l.setLast(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{lastOffset}).build(new Object[0]).toString());
                } else {
                    l.setLast(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{lastOffset}).queryParam("limit", new Object[]{limit}).build(new Object[0]).toString());
                }
            }
        }
        l.setTotal(total);
        return (T)l;
    }

    public static final ListaSenzaTotale costruisciLista(UriInfo uriInfo, Integer offset, Integer limit, long pageCurrentSize) throws InstantiationException, IllegalAccessException {
        return ListaUtils.costruisciLista(ListaUtils.getUrl(uriInfo), offset, limit, pageCurrentSize, ListaSenzaTotale.class);
    }

    public static final ListaSenzaTotale costruisciLista(String requestURI, Integer offset, Integer limit, long pageCurrentSize) throws InstantiationException, IllegalAccessException {
        return ListaUtils.costruisciLista(requestURI, offset, limit, pageCurrentSize, ListaSenzaTotale.class);
    }

    public static final <T extends ListaSenzaTotale> T costruisciLista(UriInfo uriInfo, Integer offset, Integer limit, long pageCurrentSize, Class<T> lclass) throws InstantiationException, IllegalAccessException {
        return ListaUtils.costruisciLista(ListaUtils.getUrl(uriInfo), offset, limit, pageCurrentSize, lclass);
    }

    public static final <T extends ListaSenzaTotale> T costruisciLista(String requestURI, Integer offset, Integer limit, long pageCurrentSize, Class<T> lclass) throws InstantiationException, IllegalAccessException {
        return ListaUtils._costruisciLista(requestURI, offset, limit, null, pageCurrentSize, lclass);
    }

    private static final <T extends ListaSenzaTotale> T _costruisciLista(String requestURI, Integer offset, Integer limit, Long total, long pageCurrentSize, Class<T> lclass) throws InstantiationException, IllegalAccessException {
        int realLimit;
        ListaSenzaTotale l = (ListaSenzaTotale)Utilities.newInstanceThrowInstantiationException(lclass);
        int realOffset = offset == null || offset < 0 ? 0 : offset;
        int n = realLimit = limit == null || limit <= 0 ? -1 : limit;
        if (realLimit > 0) {
            int paginaCorrente = realOffset / realLimit + 1;
            if (paginaCorrente > 1) {
                if (limit == null || limit <= 0) {
                    l.setFirst(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{0}).build(new Object[0]).toString());
                } else {
                    l.setFirst(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{0}).queryParam("limit", new Object[]{limit}).build(new Object[0]).toString());
                }
            }
            if (paginaCorrente > 1) {
                if (limit == null || limit <= 0) {
                    l.setPrev(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{realOffset - realLimit}).build(new Object[0]).toString());
                } else {
                    l.setPrev(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{realOffset - realLimit}).queryParam("limit", new Object[]{limit}).build(new Object[0]).toString());
                }
            }
            if (total != null && total > 0L) {
                long numeroPagineTotali = total / (long)realLimit;
                long resto = total % (long)realLimit;
                if (resto > 0L) {
                    ++numeroPagineTotali;
                }
                if ((long)paginaCorrente < numeroPagineTotali) {
                    if (limit == null || limit <= 0) {
                        l.setNext(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{realOffset + realLimit}).build(new Object[0]).toString());
                    } else {
                        l.setNext(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{realOffset + realLimit}).queryParam("limit", new Object[]{limit}).build(new Object[0]).toString());
                    }
                }
            } else if (pageCurrentSize >= (long)realLimit) {
                if (limit == null || limit <= 0) {
                    l.setNext(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{realOffset + realLimit}).build(new Object[0]).toString());
                } else {
                    l.setNext(UriBuilder.fromUri((String)requestURI).queryParam("offset", new Object[]{realOffset + realLimit}).queryParam("limit", new Object[]{limit}).build(new Object[0]).toString());
                }
            }
            l.setLimit(realLimit);
            l.setOffset(Long.valueOf(realOffset));
        }
        return (T)l;
    }

    private static String getUrl(UriInfo uriInfo) {
        StringBuilder sb = new StringBuilder();
        String path = uriInfo.getPath();
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        UriBuilder urlBuilder = UriBuilder.fromUri((String)sb.toString());
        if (uriInfo.getQueryParameters() != null && !uriInfo.getQueryParameters().isEmpty()) {
            for (String nome : uriInfo.getQueryParameters().keySet()) {
                List values;
                if ("offset".equalsIgnoreCase(nome) || "limit".equalsIgnoreCase(nome) || (values = (List)uriInfo.getQueryParameters().get((Object)nome)) == null || values.isEmpty()) continue;
                for (String value : values) {
                    urlBuilder.queryParam(nome, new Object[]{value});
                }
            }
        }
        return urlBuilder.build(new Object[0]).toString();
    }
}

