/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.authorization;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.service.authorization.AuthorizationConfigACL;

public class AuthorizationConfig {
    private List<AuthorizationConfigACL> aclList = new ArrayList<AuthorizationConfigACL>();

    public AuthorizationConfig() {
    }

    public AuthorizationConfig(Properties p) throws UtilsException {
        ArrayList<String> aclNames = new ArrayList<String>();
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key;
            Object object = keys.nextElement();
            if (!(object instanceof String) || !(key = (String)object).startsWith("auth.") || !key.endsWith(".resource.method")) continue;
            String aclName = key.substring("auth.".length());
            aclName = aclName.substring(0, aclName.length() - ".resource.method".length());
            aclNames.add(aclName);
        }
        if (aclNames.size() > 0) {
            for (String aclName : aclNames) {
                this.aclList.add(new AuthorizationConfigACL(aclName, p));
            }
        }
    }

    public void addAcl(AuthorizationConfigACL acl) {
        this.aclList.add(acl);
    }

    public List<AuthorizationConfigACL> getAclList() {
        return this.aclList;
    }
}

