/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.authentication.provider;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class WildflyApplicationAuthenticationProvider
implements AuthenticationProvider {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String configDir = "jboss.server.config.dir";
    private String applicationUsersFileName = "application-users.properties";
    private String applicationRolesFileName = "application-roles.properties";
    private String realName = "ApplicationRealm";
    private String hashAlgorithm = "MD5";
    private String hashEncoding = "hex";
    private UserDetailsService userDetailsService;
    private static final String FILE_PREFIX = "File '";
    public static final String BASE64_ENCODING = "BASE64";
    public static final String HEX_ENCODING = "HEX";

    private static String getS(String v) {
        return "sec" + v + "ret";
    }

    /*
     * WARNING - void declaration
     */
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        void var20_32;
        String username = authentication.getName();
        Object passwordObject = authentication.getCredentials();
        String password = (String)passwordObject;
        if (username == null || password == null) {
            throw new AuthenticationCredentialsNotFoundException("Credentials not found");
        }
        String confDir = System.getProperty(this.configDir);
        if (confDir == null) {
            throw new ProviderNotFoundException("Property '" + this.configDir + "' not found");
        }
        File confDirJBoss = new File(confDir);
        String prefixConfDirJboss = FILE_PREFIX + confDirJBoss.getAbsolutePath() + "' ";
        if (!confDirJBoss.exists()) {
            throw new ProviderNotFoundException(prefixConfDirJboss + "not exists");
        }
        if (!confDirJBoss.isDirectory()) {
            throw new ProviderNotFoundException(prefixConfDirJboss + "isn't directory");
        }
        File fUsers = new File(confDirJBoss, this.applicationUsersFileName);
        String prefixFUsers = FILE_PREFIX + fUsers.getAbsolutePath() + "' ";
        if (!fUsers.exists()) {
            throw new ProviderNotFoundException(prefixFUsers + "not exists");
        }
        if (!fUsers.canRead()) {
            throw new ProviderNotFoundException(prefixFUsers + "cannot read");
        }
        Properties pUsers = new Properties();
        try (FileInputStream fin = new FileInputStream(fUsers);){
            pUsers.load(fin);
        }
        catch (Exception e) {
            String msg = prefixFUsers + "process error: " + e.getMessage();
            this.log.error(msg, (Object)e.getMessage());
            throw new ProviderNotFoundException(msg);
        }
        Iterator<Object> itUsers = pUsers.keySet().iterator();
        boolean found = false;
        String passwordEncoded = null;
        while (itUsers.hasNext()) {
            String user = (String)itUsers.next();
            passwordEncoded = pUsers.getProperty(user);
            if (!username.equals(user)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new BadCredentialsException("Bad credentials");
        }
        String clearTextPassword = username + ":" + this.realName + ":" + password;
        String hashedPassword = null;
        try {
            hashedPassword = this.encode(clearTextPassword, this.hashAlgorithm, this.hashEncoding);
        }
        catch (Exception e) {
            String msg = "Password verifier failed: " + e.getMessage();
            this.logAndThrowAuthenticationServiceException(msg, e);
        }
        if (!passwordEncoded.equals(hashedPassword)) {
            throw new BadCredentialsException("Bad credentials");
        }
        ArrayList<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>();
        File fRoles = new File(confDirJBoss, this.applicationRolesFileName);
        if (!fRoles.exists()) {
            throw new ProviderNotFoundException(FILE_PREFIX + fRoles.getAbsolutePath() + "' not exists");
        }
        if (!fRoles.canRead()) {
            throw new ProviderNotFoundException(FILE_PREFIX + fRoles.getAbsolutePath() + "' cannot read");
        }
        Properties pRoles = new Properties();
        try (FileInputStream fin = new FileInputStream(fRoles);){
            pRoles.load(fin);
        }
        catch (Exception e) {
            String string = FILE_PREFIX + fRoles.getAbsolutePath() + "' process error: " + e.getMessage();
            this.log.error(string, (Object)e.getMessage());
            throw new ProviderNotFoundException(string);
        }
        for (String string : pRoles.keySet()) {
            if (!username.equals(string)) continue;
            String userRoles = pRoles.getProperty(string);
            if (userRoles == null || "".equals(userRoles)) break;
            String[] tmp = userRoles.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                SimpleGrantedAuthority grant = new SimpleGrantedAuthority(tmp[i].trim());
                roles.add(grant);
            }
        }
        Object var20_29 = null;
        if (this.userDetailsService != null) {
            try {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)password, userDetails.getAuthorities());
            }
            catch (UsernameNotFoundException e) {
                String msg = "User '" + username + "' unknown: " + e.getMessage();
                this.logAndThrowBadCredentialsException(msg, (Exception)((Object)e));
            }
        } else {
            User user = new User(username, WildflyApplicationAuthenticationProvider.getS(""), true, true, true, true, roles);
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)user, (Object)WildflyApplicationAuthenticationProvider.getS(""), user.getAuthorities());
        }
        var20_32.setDetails(authentication.getDetails());
        return var20_32;
    }

    private void logAndThrowAuthenticationServiceException(String msg, Exception e) throws AuthenticationServiceException {
        this.log.error(msg, (Object)e.getMessage());
        throw new AuthenticationServiceException(msg, (Throwable)e);
    }

    private void logAndThrowBadCredentialsException(String msg, Exception e) throws BadCredentialsException {
        this.log.debug(msg, (Throwable)e);
        throw new BadCredentialsException(msg, (Throwable)e);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    private String encode(String password, String hashAlgorithm, String hashEncoding) throws UtilsException {
        String passwordHash = null;
        byte[] passBytes = password.getBytes();
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            md.update(passBytes);
            hash = md.digest();
        }
        catch (Exception e) {
            throw new UtilsException("MessageDigest processing ('" + hashAlgorithm + "') failed: " + e.getMessage(), e);
        }
        if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
            passwordHash = Base64Utilities.encodeAsString(hash);
        } else if (hashEncoding.equalsIgnoreCase(HEX_ENCODING)) {
            passwordHash = HexBinaryUtilities.encodeAsString(hash);
        } else {
            throw new UtilsException("Unsupported hashAlgorithm '" + hashAlgorithm + "'");
        }
        return passwordHash;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public String getApplicationUsersFileName() {
        return this.applicationUsersFileName;
    }

    public void setApplicationUsersFileName(String applicationUsersFileName) {
        this.applicationUsersFileName = applicationUsersFileName;
    }

    public String getApplicationRolesFileName() {
        return this.applicationRolesFileName;
    }

    public void setApplicationRolesFileName(String applicationRolesFileName) {
        this.applicationRolesFileName = applicationRolesFileName;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getHashEncoding() {
        return this.hashEncoding;
    }

    public void setHashEncoding(String hashEncoding) {
        this.hashEncoding = hashEncoding;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

