/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.bean.BeanMorpher;
import net.sf.ezmorph.bean.MorphDynaBean;
import net.sf.json.util.EnumMorpher;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.serialization.IOException;

public class Utilities {
    public static void normalizeDateObjects(Object o) throws IOException {
        block10: {
            try {
                if (o == null) break block10;
                Method[] methods = o.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    String returnType;
                    String nomeMetodo = methods[i].getName();
                    if (nomeMetodo.length() > 3 && nomeMetodo.startsWith("get") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 0 && methods[i].getReturnType() != null) {
                        String voidS = "void";
                        returnType = methods[i].getReturnType().getName();
                        boolean isVoid = returnType.equals(voidS);
                        if (isVoid) continue;
                        Class<Date> tipoReturn = methods[i].getReturnType();
                        if (tipoReturn.isAssignableFrom(Date.class)) {
                            Object oDate = methods[i].invoke(o, new Object[0]);
                            if (oDate == null || !(oDate instanceof Date)) continue;
                            Date tmp = (Date)oDate;
                            String nomeMetodoSet = "s" + nomeMetodo.subSequence(1, nomeMetodo.length());
                            Method methodSet = o.getClass().getMethod(nomeMetodoSet, Date.class);
                            methodSet.invoke(o, new Date(tmp.getTime()));
                            continue;
                        }
                        if (o.getClass().getPackage() == null || !tipoReturn.getName().startsWith(o.getClass().getPackage().getName()) || tipoReturn.isEnum()) continue;
                        Utilities.normalizeDateObjects(methods[i].invoke(o, new Object[0]));
                        continue;
                    }
                    if (nomeMetodo.length() <= 3 || !nomeMetodo.startsWith("size") || !nomeMetodo.endsWith("List") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() == null) continue;
                    String intS = "int";
                    returnType = methods[i].getReturnType().getName();
                    boolean isInt = returnType.equals(intS);
                    if (!isInt) continue;
                    Object oLista = methods[i].invoke(o, new Object[0]);
                    int sizeLista = (Integer)oLista;
                    for (int j = 0; j < sizeLista; ++j) {
                        Class<?> tipoReturn;
                        String nomeMetodoGet = "get" + nomeMetodo.subSequence("size".length(), nomeMetodo.length() - "List".length());
                        Method methodGet = null;
                        try {
                            methodGet = o.getClass().getMethod(nomeMetodoGet, Integer.TYPE);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (methodGet == null || !(tipoReturn = methodGet.getReturnType()).getName().startsWith(o.getClass().getPackage().getName())) continue;
                        try {
                            Utilities.normalizeDateObjects(methodGet.invoke(o, j));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Normalizzazione date non riuscita: " + e.getMessage(), e);
            }
        }
    }

    public static void registerMorpher(Class<?> oClass, MorpherRegistry morpherRegistry, List<String> classRegistered, List<String> morpherPackage) throws UtilsException {
        block9: {
            try {
                if (oClass == null) break block9;
                Method[] methods = oClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    String nomeMetodo = methods[i].getName();
                    if (nomeMetodo.length() <= 3 || !nomeMetodo.startsWith("get") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() == null) continue;
                    String voidS = "void";
                    String returnType = methods[i].getReturnType().getName();
                    boolean isVoid = returnType.equals(voidS);
                    if (isVoid) continue;
                    Class<List> tipoReturn = methods[i].getReturnType();
                    if (Utilities.isMorpherPackage(tipoReturn, morpherPackage)) {
                        if (tipoReturn.isEnum()) {
                            if (classRegistered.contains(tipoReturn.getName())) continue;
                            classRegistered.add(tipoReturn.getName());
                            morpherRegistry.registerMorpher((Morpher)new EnumMorpher(tipoReturn));
                            continue;
                        }
                        if (!classRegistered.contains(tipoReturn.getName())) {
                            classRegistered.add(tipoReturn.getName());
                            morpherRegistry.registerMorpher((Morpher)new BeanMorpher(tipoReturn, morpherRegistry));
                        }
                        Utilities.registerMorpher(tipoReturn, morpherRegistry, classRegistered, morpherPackage);
                        continue;
                    }
                    if (!tipoReturn.isAssignableFrom(List.class)) continue;
                    Class<?> classGenericType = null;
                    try {
                        String genericType = methods[i].getGenericReturnType().toString().substring("java.util.List<".length(), methods[i].getGenericReturnType().toString().length() - 1);
                        classGenericType = Class.forName(genericType);
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), e);
                    }
                    if (classGenericType == null || !Utilities.isMorpherPackage(classGenericType, morpherPackage)) continue;
                    if (!classRegistered.contains(classGenericType.getName())) {
                        classRegistered.add(classGenericType.getName());
                        morpherRegistry.registerMorpher((Morpher)new BeanMorpher(classGenericType, morpherRegistry));
                    }
                    Utilities.registerMorpher(classGenericType, morpherRegistry, classRegistered, morpherPackage);
                }
            }
            catch (Exception e) {
                throw new UtilsException("registerMorpher failed: " + e.getMessage(), e);
            }
        }
    }

    public static void morpher(Object o, MorpherRegistry morpherRegistry, List<String> morpherPackage, boolean throwExceptionMorpherFailed) throws UtilsException {
        block17: {
            try {
                if (o == null) break block17;
                Method[] methods = o.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    List l;
                    Object oInternal;
                    String nomeMetodo = methods[i].getName();
                    if (nomeMetodo.length() <= 3 || !nomeMetodo.startsWith("get") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() == null) continue;
                    String voidS = "void";
                    String returnType = methods[i].getReturnType().getName();
                    boolean isVoid = returnType.equals(voidS);
                    if (isVoid) continue;
                    Class<List> tipoReturn = methods[i].getReturnType();
                    if (Utilities.isMorpherPackage(tipoReturn, morpherPackage)) {
                        Object oInternal2 = methods[i].invoke(o, new Object[0]);
                        if (oInternal2 == null) continue;
                        if (oInternal2 instanceof MorphDynaBean) {
                            Object oDeserialized;
                            block18: {
                                oDeserialized = null;
                                try {
                                    MorphDynaBean mdb = (MorphDynaBean)oInternal2;
                                    Utilities.normalizeByteArray(tipoReturn, mdb);
                                    oDeserialized = morpherRegistry.morph(tipoReturn, (Object)mdb);
                                }
                                catch (Exception e) {
                                    if (!throwExceptionMorpherFailed) break block18;
                                    throw e;
                                }
                            }
                            if (oDeserialized == null) continue;
                            Method setMethodRef = null;
                            for (int k = 0; k < methods.length; ++k) {
                                String setMethod = "set" + nomeMetodo.substring("get".length(), nomeMetodo.length());
                                if (!methods[k].getName().equals(setMethod) || methods[k].getParameterTypes() == null || methods[k].getParameterTypes().length != 1) continue;
                                setMethodRef = methods[k];
                                break;
                            }
                            if (setMethodRef != null) {
                                setMethodRef.invoke(o, oDeserialized);
                            }
                            Utilities.morpher(oDeserialized, morpherRegistry, morpherPackage, throwExceptionMorpherFailed);
                            continue;
                        }
                        Utilities.morpher(oInternal2, morpherRegistry, morpherPackage, throwExceptionMorpherFailed);
                        continue;
                    }
                    if (!tipoReturn.isAssignableFrom(List.class)) continue;
                    Class<?> classGenericType = null;
                    try {
                        String m = methods[i].getGenericReturnType().toString();
                        if (m.startsWith("java.util.List<")) {
                            String genericType = m.substring("java.util.List<".length(), methods[i].getGenericReturnType().toString().length() - 1);
                            classGenericType = Class.forName(genericType);
                        }
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), e);
                    }
                    if (classGenericType == null || !Utilities.isMorpherPackage(classGenericType, morpherPackage) || (oInternal = methods[i].invoke(o, new Object[0])) == null || !(oInternal instanceof List) || (l = (List)oInternal).size() <= 0) continue;
                    Method setMethodList = null;
                    for (int k = 0; k < methods.length; ++k) {
                        String setMethod = "set" + nomeMetodo.substring("get".length(), nomeMetodo.length());
                        if (!methods[k].getName().equals(setMethod) || methods[k].getParameterTypes() == null || methods[k].getParameterTypes().length != 1) continue;
                        setMethodList = methods[k];
                        break;
                    }
                    if (setMethodList == null) continue;
                    ArrayList<Object> newList = new ArrayList<Object>();
                    for (Object oInternalList : l) {
                        if (oInternalList == null) continue;
                        if (oInternalList instanceof MorphDynaBean) {
                            Object oDeserialized;
                            block19: {
                                oDeserialized = null;
                                try {
                                    MorphDynaBean mdb = (MorphDynaBean)oInternalList;
                                    Utilities.normalizeByteArray(classGenericType, mdb);
                                    oDeserialized = morpherRegistry.morph(classGenericType, (Object)mdb);
                                }
                                catch (Exception e) {
                                    if (!throwExceptionMorpherFailed) break block19;
                                    throw e;
                                }
                            }
                            if (oDeserialized == null) continue;
                            newList.add(oDeserialized);
                            Utilities.morpher(oDeserialized, morpherRegistry, morpherPackage, throwExceptionMorpherFailed);
                            continue;
                        }
                        Utilities.morpher(oInternalList, morpherRegistry, morpherPackage, throwExceptionMorpherFailed);
                        newList.add(oInternalList);
                    }
                    setMethodList.invoke(o, newList);
                }
            }
            catch (Exception e) {
                throw new UtilsException("morpher failed: " + e.getMessage(), e);
            }
        }
    }

    private static boolean isMorpherPackage(Class<?> c, List<String> morpherPackage) {
        if (morpherPackage != null && morpherPackage.size() > 0 && c.getPackage() != null) {
            for (int i = 0; i < morpherPackage.size(); ++i) {
                String p = morpherPackage.get(i);
                if (!c.getPackage().getName().equals(p) && !c.getPackage().getName().startsWith(p + ".")) continue;
                return true;
            }
        }
        return false;
    }

    private static void normalizeByteArray(Class<?> classGenericType, MorphDynaBean mdb) {
        Method[] methodsMDB = classGenericType.getMethods();
        for (int j = 0; j < methodsMDB.length; ++j) {
            String nomeMetodoMDB = methodsMDB[j].getName();
            if (nomeMetodoMDB.length() <= 3 || !nomeMetodoMDB.startsWith("get") || methodsMDB[j].getParameterTypes() == null || methodsMDB[j].getParameterTypes().length != 0 || methodsMDB[j].getReturnType() == null) continue;
            String voidS = "void";
            String returnType = methodsMDB[j].getReturnType().getName();
            boolean isVoid = returnType.equals(voidS);
            if (isVoid) continue;
            Class<byte[]> tipoReturnMDB = methodsMDB[j].getReturnType();
            String variableName = ("" + nomeMetodoMDB.charAt(3)).toLowerCase() + nomeMetodoMDB.substring(4);
            if (!tipoReturnMDB.isAssignableFrom(byte[].class)) continue;
            try {
                Object oF = mdb.get(variableName);
                if (oF == null || !oF.getClass().isAssignableFrom(ArrayList.class)) continue;
                List lf = (List)oF;
                mdb.set(variableName, (Object)lf.toArray());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

