/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import org.openspcoop2.utils.serialization.IDeserializer;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.JSonDeserializer;
import org.openspcoop2.utils.serialization.JSonSerializer;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.openspcoop2.utils.serialization.JavaSerializer;
import org.openspcoop2.utils.serialization.JsonJacksonDeserializer;
import org.openspcoop2.utils.serialization.JsonJacksonSerializer;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.openspcoop2.utils.serialization.XMLDeserializer;
import org.openspcoop2.utils.serialization.XMLSerializer;

public class SerializationFactory {
    public static ISerializer getSerializer(SERIALIZATION_TYPE type, SerializationConfig config) throws IOException {
        switch (type) {
            case JAVA: {
                return new JavaSerializer();
            }
            case JSON_JACKSON: {
                return new JsonJacksonSerializer(config);
            }
            case JSON_LIB: {
                return new JSonSerializer(config);
            }
            case XML_JSON_LIB: {
                return new XMLSerializer(config);
            }
        }
        throw new IOException("SERIALIZATION_TYPE [" + type + "] errato");
    }

    public static IDeserializer getDeserializer(SERIALIZATION_TYPE type, SerializationConfig config) throws IOException {
        switch (type) {
            case JAVA: {
                return new JavaDeserializer();
            }
            case JSON_JACKSON: {
                return new JsonJacksonDeserializer(config);
            }
            case JSON_LIB: {
                return new JSonDeserializer(config);
            }
            case XML_JSON_LIB: {
                return new XMLDeserializer(config);
            }
        }
        throw new IOException("SERIALIZATION_TYPE [" + type + "] errato");
    }

    public static enum SERIALIZATION_TYPE {
        JAVA,
        JSON_LIB,
        JSON_JACKSON,
        XML_JSON_LIB;

    }
}

