/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.logging.log4j.Level;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.CRLCertstore;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.certificate.ocsp.OCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPValidatorImpl;
import org.openspcoop2.utils.certificate.ocsp.test.OCSPTest;
import org.openspcoop2.utils.certificate.ocsp.test.OpenSSLThread;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.security.AbstractXmlCipher;
import org.openspcoop2.utils.security.Decrypt;
import org.openspcoop2.utils.security.Encrypt;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWEOptions;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonDecrypt;
import org.openspcoop2.utils.security.JsonEncrypt;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.security.SymmetricKeyWrappedMode;
import org.openspcoop2.utils.security.XmlDecrypt;
import org.openspcoop2.utils.security.XmlEncrypt;
import org.openspcoop2.utils.security.test.SignatureTest;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop2.utils.xml.XMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class EncryptTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String tmp;
        String tmp2;
        boolean runPKCS11SecretTest = false;
        TipoTest tipoTest = null;
        if (args != null && args.length > 0) {
            tipoTest = TipoTest.valueOf(args[0]);
        }
        boolean useP11asTrustStore = false;
        if (args != null && args.length > 1) {
            useP11asTrustStore = Boolean.valueOf(args[1]);
        }
        String com = null;
        if (args != null && args.length > 2 && (tmp2 = args[2]) != null && StringUtils.isNotEmpty((String)tmp2)) {
            com = tmp2;
        }
        String waitStartupServer = null;
        if (args != null && args.length > 3 && (tmp = args[3]) != null && StringUtils.isNotEmpty((String)tmp)) {
            waitStartupServer = tmp;
        }
        InputStream isKeystoreJKS = null;
        File fKeystoreJKS = null;
        InputStream isKeystoreP12 = null;
        File fKeystoreP12 = null;
        InputStream isTruststore = null;
        File fTruststore = null;
        File fKeystoreP11 = null;
        File fTruststoreP11 = null;
        InputStream isKeystoreJCEKS = null;
        File fKeystoreJCEKS = null;
        File fCertX509 = null;
        File fCertX509_P11 = null;
        InputStream jwks_isKeystore = null;
        File jwks_fKeystore = null;
        InputStream jwks_isTruststore = null;
        File jwks_fTruststore = null;
        InputStream jwk_isKeystore = null;
        File jwk_fKeystore = null;
        InputStream jwk_isTruststore = null;
        File jwk_fTruststore = null;
        InputStream jwks_symmetric_isKeystore = null;
        File jwks_symmetric_fKeystore = null;
        InputStream jwk_symmetric_isKeystore = null;
        File jwk_symmetric_fKeystore = null;
        InputStream isKeystore_crl_valid = null;
        File fKeystore_crl_valid = null;
        InputStream isKeystore_crl_expired = null;
        File fKeystore_crl_expired = null;
        InputStream isKeystore_crl_revoked = null;
        File fKeystore_crl_revoked = null;
        InputStream isTruststore_crl = null;
        File fTruststore_crl = null;
        InputStream is_crl = null;
        File f_crl = null;
        File fCertX509_crl_valid = null;
        File fCertX509_crl_expired = null;
        File fCertX509_crl_revoked = null;
        InputStream isKeystore_ocsp_valid = null;
        File fKeystore_ocsp_valid = null;
        InputStream isKeystore_ocsp_revoked = null;
        File fKeystore_ocsp_revoked = null;
        InputStream isTruststore_ocsp = null;
        File fTruststore_ocsp = null;
        File fCertX509_ocsp_valid = null;
        File fCertX509_ocsp_revoked = null;
        try {
            String aliasOcsp;
            String aliasCrl;
            OpenSSLThread sslThread;
            org.openspcoop2.utils.certificate.KeyStore keystoreJCEKS;
            System.out.println("env SOFTHSM2_CONF: " + System.getenv("SOFTHSM2_CONF"));
            LoggerWrapperFactory.setDefaultConsoleLogConfiguration(Level.ALL);
            Logger log = LoggerWrapperFactory.getLogger(EncryptTest.class);
            isKeystoreJKS = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/keystore_example.jks");
            fKeystoreJKS = File.createTempFile("keystore", KeystoreType.JKS.getNome());
            FileSystemUtilities.writeFile(fKeystoreJKS, Utilities.getAsByteArray(isKeystoreJKS));
            isKeystoreP12 = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/keystore_example.p12");
            fKeystoreP12 = File.createTempFile("keystore", "p12");
            FileSystemUtilities.writeFile(fKeystoreP12, Utilities.getAsByteArray(isKeystoreP12));
            isTruststore = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/truststore_example.jks");
            fTruststore = File.createTempFile("truststore", KeystoreType.JKS.getNome());
            FileSystemUtilities.writeFile(fTruststore, Utilities.getAsByteArray(isTruststore));
            fKeystoreP11 = File.createTempFile("keystore_hsm", ".properties");
            FileSystemUtilities.writeFile(fKeystoreP11, Utilities.getAsByteArray(EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/govway_test_hsm.properties")));
            fTruststoreP11 = File.createTempFile("truststore_hsm", ".jks");
            isKeystoreJCEKS = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/example.jceks");
            fKeystoreJCEKS = File.createTempFile("keystore", "jceks");
            FileSystemUtilities.writeFile(fKeystoreJCEKS, Utilities.getAsByteArray(isKeystoreJCEKS));
            jwks_isKeystore = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/keystore_example.jwks");
            jwks_fKeystore = File.createTempFile("keystore", ".jwk");
            FileSystemUtilities.writeFile(jwks_fKeystore, Utilities.getAsByteArray(jwks_isKeystore));
            jwks_isTruststore = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/truststore_example.jwks");
            jwks_fTruststore = File.createTempFile("truststore", ".jwk");
            FileSystemUtilities.writeFile(jwks_fTruststore, Utilities.getAsByteArray(jwks_isTruststore));
            jwk_isKeystore = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/keystore_example.jwk");
            jwk_fKeystore = File.createTempFile("keystore", ".jwk");
            FileSystemUtilities.writeFile(jwk_fKeystore, Utilities.getAsByteArray(jwk_isKeystore));
            jwk_isTruststore = EncryptTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/truststore_example.jwk");
            jwk_fTruststore = File.createTempFile("truststore", ".jwk");
            FileSystemUtilities.writeFile(jwk_fTruststore, Utilities.getAsByteArray(jwk_isTruststore));
            jwks_symmetric_isKeystore = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/keystore_symmetricKey_example.jwks");
            jwks_symmetric_fKeystore = File.createTempFile("keystore", ".jwks");
            FileSystemUtilities.writeFile(jwks_symmetric_fKeystore, Utilities.getAsByteArray(jwks_symmetric_isKeystore));
            jwk_symmetric_isKeystore = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/security/test/keystore_symmetricKey_example.jwk");
            jwk_symmetric_fKeystore = File.createTempFile("keystore", ".jwk");
            FileSystemUtilities.writeFile(jwk_symmetric_fKeystore, Utilities.getAsByteArray(jwk_symmetric_isKeystore));
            isKeystore_crl_valid = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClient1.p12");
            fKeystore_crl_valid = File.createTempFile("keystore", ".p12");
            FileSystemUtilities.writeFile(fKeystore_crl_valid, Utilities.getAsByteArray(isKeystore_crl_valid));
            isKeystore_crl_expired = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClientScaduto.p12");
            fKeystore_crl_expired = File.createTempFile("keystore", ".p12");
            FileSystemUtilities.writeFile(fKeystore_crl_expired, Utilities.getAsByteArray(isKeystore_crl_expired));
            isKeystore_crl_revoked = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleClientRevocato.p12");
            fKeystore_crl_revoked = File.createTempFile("keystore", ".p12");
            FileSystemUtilities.writeFile(fKeystore_crl_revoked, Utilities.getAsByteArray(isKeystore_crl_revoked));
            isTruststore_crl = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/trustStore_ca_certificati.jks");
            fTruststore_crl = File.createTempFile("truststore", ".jks");
            FileSystemUtilities.writeFile(fTruststore_crl, Utilities.getAsByteArray(isTruststore_crl));
            is_crl = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/crl/ExampleCA.crl");
            f_crl = File.createTempFile("lista", ".crl");
            FileSystemUtilities.writeFile(f_crl, Utilities.getAsByteArray(is_crl));
            isKeystore_ocsp_valid = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/testClient.p12");
            fKeystore_ocsp_valid = File.createTempFile("keystore", ".p12");
            FileSystemUtilities.writeFile(fKeystore_ocsp_valid, Utilities.getAsByteArray(isKeystore_ocsp_valid));
            isKeystore_ocsp_revoked = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/test.p12");
            fKeystore_ocsp_revoked = File.createTempFile("keystore", ".p12");
            FileSystemUtilities.writeFile(fKeystore_ocsp_revoked, Utilities.getAsByteArray(isKeystore_ocsp_revoked));
            isTruststore_ocsp = SignatureTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp/ca_certificati_TEST.jks");
            fTruststore_ocsp = File.createTempFile("truststore", ".jks");
            FileSystemUtilities.writeFile(fTruststore_ocsp, Utilities.getAsByteArray(isTruststore_ocsp));
            String passwordChiavePrivata = "key123456";
            String passwordStore = "123456";
            String alias = "openspcoop";
            HashMap<String, String> keystore_mapAliasPassword = new HashMap<String, String>();
            keystore_mapAliasPassword.put(alias, passwordChiavePrivata);
            org.openspcoop2.utils.certificate.KeyStore keystoreJKS = new org.openspcoop2.utils.certificate.KeyStore(fKeystoreJKS.getAbsolutePath(), KeystoreType.JKS.getNome(), passwordStore);
            if (!KeystoreType.JKS.getNome().equalsIgnoreCase(keystoreJKS.getKeystoreType())) {
                throw new Exception("Atteso tipo JKS, trovato '" + keystoreJKS.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore keystoreP12 = new org.openspcoop2.utils.certificate.KeyStore(fKeystoreP12.getAbsolutePath(), KeystoreType.PKCS12.getNome(), passwordStore);
            if (!KeystoreType.PKCS12.getNome().equalsIgnoreCase(keystoreP12.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS12, trovato '" + keystoreP12.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore truststore = new org.openspcoop2.utils.certificate.KeyStore(fTruststore.getAbsolutePath(), passwordStore);
            if (!KeystoreType.JKS.getNome().equalsIgnoreCase(truststore.getKeystoreType())) {
                throw new Exception("Atteso tipo JKS, trovato '" + truststore.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore keystoreP12_crl_valid = new org.openspcoop2.utils.certificate.KeyStore(fKeystore_crl_valid.getAbsolutePath(), KeystoreType.PKCS12.getNome(), passwordStore);
            if (!KeystoreType.PKCS12.getNome().equalsIgnoreCase(keystoreP12_crl_valid.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS12, trovato '" + keystoreP12_crl_valid.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore keystoreP12_crl_expired = new org.openspcoop2.utils.certificate.KeyStore(fKeystore_crl_expired.getAbsolutePath(), KeystoreType.PKCS12.getNome(), passwordStore);
            if (!KeystoreType.PKCS12.getNome().equalsIgnoreCase(keystoreP12_crl_expired.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS12, trovato '" + keystoreP12_crl_expired.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore keystoreP12_crl_revoked = new org.openspcoop2.utils.certificate.KeyStore(fKeystore_crl_revoked.getAbsolutePath(), KeystoreType.PKCS12.getNome(), passwordStore);
            if (!KeystoreType.PKCS12.getNome().equalsIgnoreCase(keystoreP12_crl_revoked.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS12, trovato '" + keystoreP12_crl_revoked.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore truststoreCRL = new org.openspcoop2.utils.certificate.KeyStore(fTruststore_crl.getAbsolutePath(), passwordStore);
            if (!KeystoreType.JKS.getNome().equalsIgnoreCase(truststoreCRL.getKeystoreType())) {
                throw new Exception("Atteso tipo JKS, trovato '" + truststoreCRL.getKeystoreType() + "'");
            }
            CRLCertstore crl = new CRLCertstore(f_crl.getAbsolutePath());
            fCertX509_crl_valid = File.createTempFile("certValid", ".cer");
            FileSystemUtilities.writeFile(fCertX509_crl_valid, truststoreCRL.getCertificate("ExampleClient1").getEncoded());
            fCertX509_crl_expired = File.createTempFile("certExpired", ".cer");
            FileSystemUtilities.writeFile(fCertX509_crl_expired, truststoreCRL.getCertificate("ExampleClientScaduto").getEncoded());
            fCertX509_crl_revoked = File.createTempFile("certRevoked", ".cer");
            FileSystemUtilities.writeFile(fCertX509_crl_revoked, truststoreCRL.getCertificate("ExampleClientRevocato").getEncoded());
            org.openspcoop2.utils.certificate.KeyStore keystoreP12_ocsp_valid = new org.openspcoop2.utils.certificate.KeyStore(fKeystore_ocsp_valid.getAbsolutePath(), KeystoreType.PKCS12.getNome(), passwordStore);
            if (!KeystoreType.PKCS12.getNome().equalsIgnoreCase(keystoreP12_ocsp_valid.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS12, trovato '" + keystoreP12_ocsp_valid.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore keystoreP12_ocsp_revoked = new org.openspcoop2.utils.certificate.KeyStore(fKeystore_ocsp_revoked.getAbsolutePath(), KeystoreType.PKCS12.getNome(), passwordStore);
            if (!KeystoreType.PKCS12.getNome().equalsIgnoreCase(keystoreP12_ocsp_revoked.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS12, trovato '" + keystoreP12_ocsp_revoked.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore truststoreOCSP = new org.openspcoop2.utils.certificate.KeyStore(fTruststore_ocsp.getAbsolutePath(), passwordStore);
            if (!KeystoreType.JKS.getNome().equalsIgnoreCase(truststoreOCSP.getKeystoreType())) {
                throw new Exception("Atteso tipo JKS, trovato '" + truststoreOCSP.getKeystoreType() + "'");
            }
            OCSPResourceReader ocspResourceReader = new OCSPResourceReader();
            LoggerBuffer lb = new LoggerBuffer();
            lb.setLogError(log);
            lb.setLogDebug(log);
            File f = null;
            try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/ocsp_test.properties");){
                byte[] content = Utilities.getAsByteArray(is);
                f = File.createTempFile("test", ".properties");
                FileSystemUtilities.writeFile(f, content);
                OCSPManager.init(f.getAbsoluteFile(), true, false, log);
            }
            finally {
                if (f != null) {
                    f.delete();
                }
            }
            OCSPValidatorImpl ocspValidator = new OCSPValidatorImpl(lb, truststoreOCSP, null, "signedByResponderCertificate_case2", ocspResourceReader);
            fCertX509_ocsp_valid = File.createTempFile("certValid", ".cer");
            FileSystemUtilities.writeFile(fCertX509_ocsp_valid, truststoreOCSP.getCertificate("testclient").getEncoded());
            fCertX509_ocsp_revoked = File.createTempFile("certRevoked", ".cer");
            FileSystemUtilities.writeFile(fCertX509_ocsp_revoked, truststoreOCSP.getCertificate("test").getEncoded());
            String aliasP11 = "server2_hsm";
            HashMap<String, String> keystoreP11_mapAliasPassword = new HashMap<String, String>();
            keystoreP11_mapAliasPassword.put(aliasP11, passwordChiavePrivata);
            boolean uniqueProviderInstance = true;
            HSMManager.init(fKeystoreP11, true, log, true);
            HSMManager hsmManager = HSMManager.getInstance();
            hsmManager.providerInit(log, uniqueProviderInstance);
            System.out.println("PKCS11 Keystore registered: " + hsmManager.getKeystoreTypes());
            org.openspcoop2.utils.certificate.KeyStore keystoreP11 = hsmManager.getKeystore("pkcs11-server");
            if (!KeystoreType.PKCS11.getNome().equalsIgnoreCase(keystoreP11.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS11, trovato '" + keystoreP12.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore truststoreP11 = null;
            if (useP11asTrustStore) {
                truststoreP11 = hsmManager.getKeystore("pkcs11-server");
                if (!KeystoreType.PKCS11.getNome().equalsIgnoreCase(truststoreP11.getKeystoreType())) {
                    throw new Exception("Atteso tipo PKCS11, trovato '" + truststoreP11.getKeystoreType() + "'");
                }
            } else {
                KeyStore tP11 = KeyStore.getInstance(KeystoreType.JKS.getNome());
                tP11.load(null);
                tP11.setCertificateEntry("client1_hsm", hsmManager.getKeystore("pkcs11-client1").getCertificate("client1_hsm"));
                tP11.setCertificateEntry("client2_hsm", hsmManager.getKeystore("pkcs11-client2").getCertificate("client2_hsm"));
                tP11.setCertificateEntry("server_hsm", hsmManager.getKeystore("pkcs11-server").getCertificate("server_hsm"));
                tP11.setCertificateEntry("server2_hsm", hsmManager.getKeystore("pkcs11-server").getCertificate("server2_hsm"));
                truststoreP11 = new org.openspcoop2.utils.certificate.KeyStore(tP11);
                try (FileOutputStream fout = new FileOutputStream(fTruststoreP11);){
                    tP11.store(fout, passwordStore.toCharArray());
                    fout.flush();
                }
                if (!KeystoreType.JKS.getNome().equalsIgnoreCase(truststoreP11.getKeystoreType())) {
                    throw new Exception("Atteso tipo JKS, trovato '" + truststoreP11.getKeystoreType() + "'");
                }
            }
            if (!"JCEKS".equalsIgnoreCase((keystoreJCEKS = new org.openspcoop2.utils.certificate.KeyStore(fKeystoreJCEKS.getAbsolutePath(), "JCEKS", passwordStore)).getKeystoreType())) {
                throw new Exception("Atteso tipo JCEKS, trovato '" + keystoreJCEKS.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore keystoreSecretP11 = hsmManager.getKeystore("pkcs11-client1");
            if (!KeystoreType.PKCS11.getNome().equalsIgnoreCase(keystoreSecretP11.getKeystoreType())) {
                throw new Exception("Atteso tipo PKCS11, trovato '" + keystoreSecretP11.getKeystoreType() + "'");
            }
            org.openspcoop2.utils.certificate.KeyStore truststoreSecretP11 = null;
            if (useP11asTrustStore) {
                truststoreSecretP11 = hsmManager.getKeystore("pkcs11-client1");
                if (!KeystoreType.PKCS11.getNome().equalsIgnoreCase(truststoreSecretP11.getKeystoreType())) {
                    throw new Exception("Atteso tipo PKCS11, trovato '" + truststoreSecretP11.getKeystoreType() + "'");
                }
            }
            String aliasSecretP11 = "client_symmetric_hsm";
            HashMap<String, String> keystoreSecretP11_mapAliasPassword = new HashMap<String, String>();
            keystoreSecretP11_mapAliasPassword.put(aliasSecretP11, passwordChiavePrivata);
            fCertX509 = File.createTempFile("cert", ".cer");
            FileSystemUtilities.writeFile(fCertX509, truststore.getCertificate(alias).getEncoded());
            fCertX509_P11 = File.createTempFile("certP11", ".cer");
            FileSystemUtilities.writeFile(fCertX509_P11, truststoreP11.getCertificate(aliasP11).getEncoded());
            JsonWebKey jwk_keystore = new JWK(FileSystemUtilities.readFile(jwk_fKeystore)).getJsonWebKey();
            JsonWebKey jwk_truststore = new JWK(FileSystemUtilities.readFile(jwk_fTruststore)).getJsonWebKey();
            JsonWebKeys jwks_keystore = new JWKSet(FileSystemUtilities.readFile(jwks_fKeystore)).getJsonWebKeys();
            JsonWebKeys jwks_truststore = new JWKSet(FileSystemUtilities.readFile(jwks_fTruststore)).getJsonWebKeys();
            JsonWebKeys jwks_symmetric_keystore = new JWKSet(FileSystemUtilities.readFile(jwks_symmetric_fKeystore)).getJsonWebKeys();
            JsonWebKey jwk_symmetric_keystore = new JWK(FileSystemUtilities.readFile(jwk_symmetric_fKeystore)).getJsonWebKey();
            JwtHeaders jwtHeader = new JwtHeaders();
            jwtHeader.setContentType("application/json");
            jwtHeader.setType("application/json[0]");
            jwtHeader.addCriticalHeader("a1");
            jwtHeader.addCriticalHeader("a2");
            jwtHeader.addExtension("a1", "v1");
            jwtHeader.addExtension("a2", "v2");
            jwtHeader.addExtension("a3", "v3");
            if (tipoTest == null || TipoTest.JAVA_ENCRYPT_JKS.equals((Object)tipoTest)) {
                EncryptTest.testJava(TipoTest.JAVA_ENCRYPT_JKS, useP11asTrustStore, keystoreJKS, truststore, alias, passwordChiavePrivata);
            }
            if (tipoTest == null || TipoTest.JAVA_ENCRYPT_PKCS12.equals((Object)tipoTest)) {
                EncryptTest.testJava(TipoTest.JAVA_ENCRYPT_PKCS12, useP11asTrustStore, keystoreP12, truststore, alias, passwordChiavePrivata);
            }
            if (tipoTest == null || TipoTest.JAVA_ENCRYPT_PKCS11.equals((Object)tipoTest)) {
                EncryptTest.testJava(TipoTest.JAVA_ENCRYPT_PKCS11, useP11asTrustStore, keystoreP11, truststoreP11, aliasP11, passwordChiavePrivata);
            }
            if (tipoTest == null || TipoTest.XML_ENCRYPT_JKS.equals((Object)tipoTest)) {
                EncryptTest.testXmlEncrypt(TipoTest.XML_ENCRYPT_JKS, useP11asTrustStore, keystoreJKS, alias, truststore, keystoreJCEKS, alias, passwordChiavePrivata);
            }
            if (tipoTest == null || TipoTest.XML_ENCRYPT_PKCS12.equals((Object)tipoTest)) {
                EncryptTest.testXmlEncrypt(TipoTest.XML_ENCRYPT_PKCS12, useP11asTrustStore, keystoreP12, alias, truststore, keystoreJCEKS, alias, passwordChiavePrivata);
            }
            if (tipoTest == null || TipoTest.XML_ENCRYPT_PKCS11.equals((Object)tipoTest)) {
                EncryptTest.testXmlEncrypt(TipoTest.XML_ENCRYPT_PKCS11, useP11asTrustStore, keystoreP11, aliasP11, truststoreP11, keystoreJCEKS, alias, passwordChiavePrivata);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JKS.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JKS, useP11asTrustStore, fKeystoreJKS, null, null, fTruststore, null, truststore, keystoreJKS, keystore_mapAliasPassword, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM, useP11asTrustStore, fKeystoreJKS, null, null, fTruststore, jwtHeader, truststore, keystoreJKS, keystore_mapAliasPassword, null);
                jwtHeader.setX509Url(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM_KID_ONLY.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM_KID_ONLY, useP11asTrustStore, fKeystoreJKS, null, null, fTruststore, jwtHeader, truststore, keystoreJKS, keystore_mapAliasPassword, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12, useP11asTrustStore, fKeystoreP12, null, null, fTruststore, null, truststore, keystoreP12, keystore_mapAliasPassword, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM, useP11asTrustStore, fKeystoreP12, null, null, fTruststore, jwtHeader, truststore, keystoreP12, keystore_mapAliasPassword, null);
                jwtHeader.setX509Url(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM_KID_ONLY.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM_KID_ONLY, useP11asTrustStore, fKeystoreP12, null, null, fTruststore, jwtHeader, truststore, keystoreP12, keystore_mapAliasPassword, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11, useP11asTrustStore, null, keystoreP11, aliasP11, fTruststoreP11, null, truststoreP11, keystoreP11, keystoreP11_mapAliasPassword, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setX509Url(new URI("file://" + fCertX509_P11.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM, useP11asTrustStore, null, keystoreP11, aliasP11, fTruststoreP11, jwtHeader, truststoreP11, keystoreP11, keystoreP11_mapAliasPassword, null);
                jwtHeader.setX509Url(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM_KID_ONLY.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM_KID_ONLY, useP11asTrustStore, null, keystoreP11, aliasP11, fTruststoreP11, jwtHeader, truststoreP11, keystoreP11, keystoreP11_mapAliasPassword, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS, useP11asTrustStore, fKeystoreJCEKS, null, null, fKeystoreJCEKS, null, null, null, null, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM, useP11asTrustStore, fKeystoreJCEKS, null, null, fKeystoreJCEKS, jwtHeader, null, null, null, null);
                jwtHeader.setX509Url(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET.equals((Object)tipoTest)) {
                if (runPKCS11SecretTest) {
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET, useP11asTrustStore, null, keystoreSecretP11, aliasSecretP11, fTruststoreP11, null, truststoreSecretP11, keystoreSecretP11, keystoreSecretP11_mapAliasPassword, null);
                } else {
                    System.out.println("Test [" + TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET + "] disabilitato");
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM.equals((Object)tipoTest)) {
                if (runPKCS11SecretTest) {
                    jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM, useP11asTrustStore, null, keystoreSecretP11, aliasSecretP11, fTruststoreP11, jwtHeader, truststoreSecretP11, keystoreSecretP11, keystoreSecretP11_mapAliasPassword, null);
                    jwtHeader.setX509Url(null);
                } else {
                    System.out.println("Test [" + TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM + "] disabilitato");
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL.equals((Object)tipoTest)) {
                keystore_mapAliasPassword.put("exampleclient1", "123456");
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL, false, fKeystore_crl_valid, null, "ExampleClient1", fTruststore_crl, null, truststoreCRL, keystoreP12_crl_valid, keystore_mapAliasPassword, null, crl, null);
                keystore_mapAliasPassword.put("exampleclientscaduto", "123456");
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL, false, fKeystore_crl_expired, null, "ExampleClientScaduto", fTruststore_crl, null, truststoreCRL, keystoreP12_crl_expired, keystore_mapAliasPassword, null, crl, null);
                keystore_mapAliasPassword.put("exampleclientrevocato", "123456");
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL, false, fKeystore_crl_revoked, null, "ExampleClientRevocato", fTruststore_crl, null, truststoreCRL, keystoreP12_crl_revoked, keystore_mapAliasPassword, null, crl, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipoTest)) {
                keystore_mapAliasPassword.put("exampleclient1", "123456");
                jwtHeader.setX509Url(new URI("file://" + fCertX509_crl_valid.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM, false, fKeystore_crl_valid, null, "ExampleClient1", fTruststore_crl, jwtHeader, truststoreCRL, keystoreP12_crl_valid, keystore_mapAliasPassword, null, crl, null);
                jwtHeader.setX509Url(null);
                keystore_mapAliasPassword.put("exampleclientscaduto", "123456");
                jwtHeader.setX509Url(new URI("file://" + fCertX509_crl_expired.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM, false, fKeystore_crl_expired, null, "ExampleClientScaduto", fTruststore_crl, jwtHeader, truststoreCRL, keystoreP12_crl_expired, keystore_mapAliasPassword, null, crl, null);
                jwtHeader.setX509Url(null);
                keystore_mapAliasPassword.put("exampleclientrevocato", "123456");
                jwtHeader.setX509Url(new URI("file://" + fCertX509_crl_revoked.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM, false, fKeystore_crl_revoked, null, "ExampleClientRevocato", fTruststore_crl, jwtHeader, truststoreCRL, keystoreP12_crl_revoked, keystore_mapAliasPassword, null, crl, null);
                jwtHeader.setX509Url(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipoTest)) {
                keystore_mapAliasPassword.put("exampleclient1", "123456");
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY, false, fKeystore_crl_valid, null, "ExampleClient1", fTruststore_crl, jwtHeader, truststoreCRL, keystoreP12_crl_valid, keystore_mapAliasPassword, null, crl, null);
                keystore_mapAliasPassword.put("exampleclientscaduto", "123456");
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY, false, fKeystore_crl_expired, null, "ExampleClientScaduto", fTruststore_crl, jwtHeader, truststoreCRL, keystoreP12_crl_expired, keystore_mapAliasPassword, null, crl, null);
                keystore_mapAliasPassword.put("exampleclientrevocato", "123456");
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY, false, fKeystore_crl_revoked, null, "ExampleClientRevocato", fTruststore_crl, jwtHeader, truststoreCRL, keystoreP12_crl_revoked, keystore_mapAliasPassword, null, crl, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP.equals((Object)tipoTest)) {
                sslThread = SignatureTest.newOpenSSLThread(com, waitStartupServer);
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                try {
                    keystore_mapAliasPassword.put("testclient", "123456");
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP, false, fKeystore_ocsp_valid, null, "testclient", fTruststore_ocsp, null, truststoreOCSP, keystoreP12_ocsp_valid, keystore_mapAliasPassword, null, null, ocspValidator);
                    keystore_mapAliasPassword.put("test", "123456");
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP, false, fKeystore_ocsp_revoked, null, "test", fTruststore_ocsp, null, truststoreOCSP, keystoreP12_ocsp_revoked, keystore_mapAliasPassword, null, null, ocspValidator);
                }
                finally {
                    Security.removeProvider("BC");
                    SignatureTest.stopOpenSSLThread(sslThread, waitStartupServer);
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipoTest)) {
                sslThread = SignatureTest.newOpenSSLThread(com, waitStartupServer);
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                try {
                    keystore_mapAliasPassword.put("testclient", "123456");
                    jwtHeader.setX509Url(new URI("file://" + fCertX509_ocsp_valid.getAbsolutePath()));
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM, false, fKeystore_ocsp_valid, null, "testclient", fTruststore_ocsp, jwtHeader, truststoreOCSP, keystoreP12_ocsp_valid, keystore_mapAliasPassword, null, null, ocspValidator);
                    jwtHeader.setX509Url(null);
                    keystore_mapAliasPassword.put("test", "123456");
                    jwtHeader.setX509Url(new URI("file://" + fCertX509_ocsp_revoked.getAbsolutePath()));
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM, false, fKeystore_ocsp_revoked, null, "test", fTruststore_ocsp, jwtHeader, truststoreOCSP, keystoreP12_ocsp_revoked, keystore_mapAliasPassword, null, null, ocspValidator);
                    jwtHeader.setX509Url(null);
                }
                finally {
                    Security.removeProvider("BC");
                    SignatureTest.stopOpenSSLThread(sslThread, waitStartupServer);
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipoTest)) {
                sslThread = SignatureTest.newOpenSSLThread(com, waitStartupServer);
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                try {
                    keystore_mapAliasPassword.put("testclient", "123456");
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY, false, fKeystore_ocsp_valid, null, "testclient", fTruststore_ocsp, jwtHeader, truststoreOCSP, keystoreP12_ocsp_valid, keystore_mapAliasPassword, null, null, ocspValidator);
                    keystore_mapAliasPassword.put("test", "123456");
                    EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY, false, fKeystore_ocsp_revoked, null, "test", fTruststore_ocsp, jwtHeader, truststoreOCSP, keystoreP12_ocsp_revoked, keystore_mapAliasPassword, null, null, ocspValidator);
                }
                finally {
                    Security.removeProvider("BC");
                    SignatureTest.stopOpenSSLThread(sslThread, waitStartupServer);
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JWK, useP11asTrustStore, jwks_fKeystore, null, null, jwks_fTruststore, null, null, null, null, jwks_keystore);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setJwkUrl(new URI("file://" + jwks_fTruststore.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM, useP11asTrustStore, jwks_fKeystore, null, null, jwks_fTruststore, jwtHeader, null, null, null, jwks_keystore);
                jwtHeader.setJwkUrl(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM_KID_ONLY.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM_KID_ONLY, useP11asTrustStore, jwks_fKeystore, null, null, jwks_fTruststore, jwtHeader, null, null, null, jwks_keystore);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipoTest)) {
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC, useP11asTrustStore, jwks_symmetric_fKeystore, null, null, jwks_symmetric_fKeystore, null, null, null, null, null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setJwkUrl(new URI("file://" + jwks_symmetric_fKeystore.getAbsolutePath()));
                EncryptTest.testJsonProperties(TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM, useP11asTrustStore, jwks_symmetric_fKeystore, null, null, jwks_symmetric_fKeystore, jwtHeader, null, null, null, null);
                jwtHeader.setJwkUrl(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JKS_KEYSTORE.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreJKS.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_JKS_KEYSTORE, useP11asTrustStore, keystoreJKS, truststore, alias, passwordChiavePrivata, jwtHeader, keystore_mapAliasPassword);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JKS_KEYSTORE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreJKS.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_JKS_KEYSTORE_HEADER_CUSTOM, useP11asTrustStore, keystoreJKS, truststore, alias, passwordChiavePrivata, jwtHeader, keystore_mapAliasPassword);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP12.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE, useP11asTrustStore, keystoreP12, truststore, alias, passwordChiavePrivata, jwtHeader, keystore_mapAliasPassword);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP12.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE_HEADER_CUSTOM, useP11asTrustStore, keystoreP12, truststore, alias, passwordChiavePrivata, jwtHeader, keystore_mapAliasPassword);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP11.getCertificate(aliasP11));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(aliasP11);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE, useP11asTrustStore, keystoreP11, truststoreP11, aliasP11, passwordChiavePrivata, jwtHeader, keystoreP11_mapAliasPassword);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP11.getCertificate(aliasP11));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509_P11.getAbsolutePath()));
                jwtHeader.setKid(aliasP11);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_HEADER_CUSTOM, useP11asTrustStore, keystoreP11, truststoreP11, aliasP11, passwordChiavePrivata, jwtHeader, keystoreP11_mapAliasPassword);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_CRL_KEYSTORE.equals((Object)tipoTest)) {
                aliasCrl = "ExampleClient1";
                keystore_mapAliasPassword.put("exampleclient1", "123456");
                jwtHeader.addX509cert((X509Certificate)keystoreP12_crl_valid.getCertificate(aliasCrl));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(aliasCrl);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_CRL_KEYSTORE, false, keystoreP12_crl_valid, truststoreCRL, aliasCrl, passwordStore, jwtHeader, keystore_mapAliasPassword, crl, null);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
                aliasCrl = "ExampleClientScaduto";
                keystore_mapAliasPassword.put("exampleclientscaduto", "123456");
                jwtHeader.addX509cert((X509Certificate)keystoreP12_crl_expired.getCertificate(aliasCrl));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(aliasCrl);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_CRL_KEYSTORE, false, keystoreP12_crl_expired, truststoreCRL, aliasCrl, passwordStore, jwtHeader, keystore_mapAliasPassword, crl, null);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
                aliasCrl = "ExampleClientRevocato";
                keystore_mapAliasPassword.put("exampleclientrevocato", "123456");
                jwtHeader.addX509cert((X509Certificate)keystoreP12_crl_revoked.getCertificate(aliasCrl));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(aliasCrl);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_CRL_KEYSTORE, false, keystoreP12_crl_revoked, truststoreCRL, aliasCrl, passwordStore, jwtHeader, keystore_mapAliasPassword, crl, null);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                aliasCrl = "ExampleClient1";
                keystore_mapAliasPassword.put("exampleclient1", "123456");
                jwtHeader.addX509cert((X509Certificate)keystoreP12_crl_valid.getCertificate(aliasCrl));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509_crl_valid.getAbsolutePath()));
                jwtHeader.setKid(aliasCrl);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM, false, keystoreP12_crl_valid, truststoreCRL, aliasCrl, passwordStore, jwtHeader, keystore_mapAliasPassword, crl, null);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
                aliasCrl = "ExampleClientScaduto";
                keystore_mapAliasPassword.put("exampleclientscaduto", "123456");
                jwtHeader.addX509cert((X509Certificate)keystoreP12_crl_expired.getCertificate(aliasCrl));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509_crl_expired.getAbsolutePath()));
                jwtHeader.setKid(aliasCrl);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM, false, keystoreP12_crl_expired, truststoreCRL, aliasCrl, passwordStore, jwtHeader, keystore_mapAliasPassword, crl, null);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
                aliasCrl = "ExampleClientRevocato";
                keystore_mapAliasPassword.put("exampleclientrevocato", "123456");
                jwtHeader.addX509cert((X509Certificate)keystoreP12_crl_revoked.getCertificate(aliasCrl));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509_crl_revoked.getAbsolutePath()));
                jwtHeader.setKid(aliasCrl);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM, false, keystoreP12_crl_revoked, truststoreCRL, aliasCrl, passwordStore, jwtHeader, keystore_mapAliasPassword, crl, null);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE.equals((Object)tipoTest)) {
                sslThread = SignatureTest.newOpenSSLThread(com, waitStartupServer);
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                try {
                    aliasOcsp = "testclient";
                    keystore_mapAliasPassword.put("testclient", "123456");
                    jwtHeader.addX509cert((X509Certificate)keystoreP12_ocsp_valid.getCertificate(aliasOcsp));
                    jwtHeader.setX509IncludeCertSha1(true);
                    jwtHeader.setX509IncludeCertSha256(false);
                    jwtHeader.setKid(aliasOcsp);
                    EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE, false, keystoreP12_ocsp_valid, truststoreOCSP, aliasOcsp, passwordStore, jwtHeader, keystore_mapAliasPassword, null, ocspValidator);
                    jwtHeader.getX509c().clear();
                    jwtHeader.setX509IncludeCertSha1(false);
                    jwtHeader.setX509IncludeCertSha256(false);
                    jwtHeader.setKid(null);
                    aliasOcsp = "test";
                    keystore_mapAliasPassword.put("test", "123456");
                    jwtHeader.addX509cert((X509Certificate)keystoreP12_ocsp_revoked.getCertificate(aliasOcsp));
                    jwtHeader.setX509IncludeCertSha1(true);
                    jwtHeader.setX509IncludeCertSha256(false);
                    jwtHeader.setKid(aliasOcsp);
                    EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE, false, keystoreP12_ocsp_revoked, truststoreOCSP, aliasOcsp, passwordStore, jwtHeader, keystore_mapAliasPassword, null, ocspValidator);
                    jwtHeader.getX509c().clear();
                    jwtHeader.setX509IncludeCertSha1(false);
                    jwtHeader.setX509IncludeCertSha256(false);
                    jwtHeader.setKid(null);
                }
                finally {
                    Security.removeProvider("BC");
                    SignatureTest.stopOpenSSLThread(sslThread, waitStartupServer);
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                sslThread = SignatureTest.newOpenSSLThread(com, waitStartupServer);
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                try {
                    aliasOcsp = "testclient";
                    keystore_mapAliasPassword.put("testclient", "123456");
                    jwtHeader.addX509cert((X509Certificate)keystoreP12_ocsp_valid.getCertificate(aliasOcsp));
                    jwtHeader.setX509IncludeCertSha1(false);
                    jwtHeader.setX509IncludeCertSha256(true);
                    jwtHeader.setX509Url(new URI("file://" + fCertX509_ocsp_valid.getAbsolutePath()));
                    jwtHeader.setKid(aliasOcsp);
                    EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM, false, keystoreP12_ocsp_valid, truststoreOCSP, aliasOcsp, passwordStore, jwtHeader, keystore_mapAliasPassword, null, ocspValidator);
                    jwtHeader.getX509c().clear();
                    jwtHeader.setX509IncludeCertSha1(false);
                    jwtHeader.setX509IncludeCertSha256(false);
                    jwtHeader.setX509Url(null);
                    jwtHeader.setKid(null);
                    aliasOcsp = "test";
                    keystore_mapAliasPassword.put("test", "123456");
                    jwtHeader.addX509cert((X509Certificate)keystoreP12_ocsp_revoked.getCertificate(aliasOcsp));
                    jwtHeader.setX509IncludeCertSha1(false);
                    jwtHeader.setX509IncludeCertSha256(true);
                    jwtHeader.setX509Url(new URI("file://" + fCertX509_ocsp_revoked.getAbsolutePath()));
                    jwtHeader.setKid(aliasOcsp);
                    EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM, false, keystoreP12_ocsp_revoked, truststoreOCSP, aliasOcsp, passwordStore, jwtHeader, keystore_mapAliasPassword, null, ocspValidator);
                    jwtHeader.getX509c().clear();
                    jwtHeader.setX509IncludeCertSha1(false);
                    jwtHeader.setX509IncludeCertSha256(false);
                    jwtHeader.setX509Url(null);
                    jwtHeader.setKid(null);
                }
                finally {
                    Security.removeProvider("BC");
                    SignatureTest.stopOpenSSLThread(sslThread, waitStartupServer);
                }
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JKS_KEYSTORE_JCE.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreJKS.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_JKS_KEYSTORE_JCE, useP11asTrustStore, keystoreJCEKS, alias, passwordChiavePrivata, jwtHeader);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JKS_KEYSTORE_JCE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreJKS.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_JKS_KEYSTORE_JCE_HEADER_CUSTOM, useP11asTrustStore, keystoreJCEKS, alias, passwordChiavePrivata, jwtHeader);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE_JCE.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP12.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE_JCE, useP11asTrustStore, keystoreJCEKS, alias, passwordChiavePrivata, jwtHeader);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE_JCE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP12.getCertificate(alias));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509.getAbsolutePath()));
                jwtHeader.setKid(alias);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS12_KEYSTORE_JCE_HEADER_CUSTOM, useP11asTrustStore, keystoreJCEKS, alias, passwordChiavePrivata, jwtHeader);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_JCE.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP11.getCertificate(aliasP11));
                jwtHeader.setX509IncludeCertSha1(true);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(aliasP11);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_JCE, useP11asTrustStore, keystoreJCEKS, alias, passwordChiavePrivata, jwtHeader);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_JCE_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.addX509cert((X509Certificate)keystoreP11.getCertificate(aliasP11));
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(true);
                jwtHeader.setX509Url(new URI("file://" + fCertX509_P11.getAbsolutePath()));
                jwtHeader.setKid(aliasP11);
                EncryptTest.testJsonKeystore(TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_JCE_HEADER_CUSTOM, useP11asTrustStore, keystoreJCEKS, alias, passwordChiavePrivata, jwtHeader);
                jwtHeader.getX509c().clear();
                jwtHeader.setX509IncludeCertSha1(false);
                jwtHeader.setX509IncludeCertSha256(false);
                jwtHeader.setX509Url(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_KEYS.equals((Object)tipoTest)) {
                jwtHeader.setJwKey(jwks_keystore, alias);
                jwtHeader.setKid(alias);
                EncryptTest.testJsonJwkKeys(TipoTest.JSON_ENCRYPT_JWK_KEYS, useP11asTrustStore, jwks_keystore, jwks_truststore, alias, jwtHeader);
                jwtHeader.setJwKey(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_KEYS_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setJwkUrl(new URI("file://" + jwks_fTruststore.getAbsolutePath()));
                EncryptTest.testJsonJwkKeys(TipoTest.JSON_ENCRYPT_JWK_KEYS_HEADER_CUSTOM, useP11asTrustStore, jwks_keystore, jwks_truststore, alias, jwtHeader);
                jwtHeader.setJwkUrl(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_KEY.equals((Object)tipoTest)) {
                jwtHeader.setJwKey(jwk_keystore);
                jwtHeader.setKid(alias);
                EncryptTest.testJsonJwkKey(TipoTest.JSON_ENCRYPT_JWK_KEY, useP11asTrustStore, jwk_keystore, jwk_truststore, jwtHeader, jwks_keystore);
                jwtHeader.setJwKey(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_KEY_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setJwkUrl(new URI("file://" + jwks_fTruststore.getAbsolutePath()));
                EncryptTest.testJsonJwkKey(TipoTest.JSON_ENCRYPT_JWK_KEY_HEADER_CUSTOM, useP11asTrustStore, jwk_keystore, jwk_truststore, jwtHeader, jwks_keystore);
                jwtHeader.setJwkUrl(null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEYS.equals((Object)tipoTest)) {
                jwtHeader.setKid(alias);
                EncryptTest.testJsonJwkKeys(TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEYS, useP11asTrustStore, jwks_symmetric_keystore, jwks_symmetric_keystore, alias, jwtHeader);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEYS_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setJwkUrl(new URI("file://" + jwks_symmetric_fKeystore.getAbsolutePath()));
                EncryptTest.testJsonJwkKeys(TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEYS_HEADER_CUSTOM, useP11asTrustStore, jwks_symmetric_keystore, jwks_symmetric_keystore, alias, jwtHeader);
                jwtHeader.setJwkUrl(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEY.equals((Object)tipoTest)) {
                jwtHeader.setKid(alias);
                EncryptTest.testJsonJwkKey(TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEY, useP11asTrustStore, jwk_symmetric_keystore, jwk_symmetric_keystore, jwtHeader, null);
                jwtHeader.setKid(null);
            }
            if (tipoTest == null || TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEY_HEADER_CUSTOM.equals((Object)tipoTest)) {
                jwtHeader.setJwkUrl(new URI("file://" + jwk_symmetric_fKeystore.getAbsolutePath()));
                EncryptTest.testJsonJwkKey(TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEY_HEADER_CUSTOM, useP11asTrustStore, jwk_symmetric_keystore, jwk_symmetric_keystore, jwtHeader, null);
                jwtHeader.setJwkUrl(null);
            }
            System.out.println("Testsuite terminata");
        }
        finally {
            try {
                if (isKeystoreJKS != null) {
                    isKeystoreJKS.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystoreJKS != null) {
                    fKeystoreJKS.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystoreP12 != null) {
                    isKeystoreP12.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystoreP12 != null) {
                    fKeystoreP12.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isTruststore != null) {
                    isTruststore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTruststore != null) {
                    fTruststore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystoreP11 != null) {
                    fKeystoreP11.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTruststoreP11 != null) {
                    fTruststoreP11.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystoreJCEKS != null) {
                    isKeystoreJCEKS.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystoreJCEKS != null) {
                    fKeystoreJCEKS.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509 != null) {
                    fCertX509.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509_P11 != null) {
                    fCertX509_P11.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwk_isKeystore != null) {
                    jwk_isKeystore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwk_fKeystore != null) {
                    jwk_fKeystore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwk_isTruststore != null) {
                    jwk_isTruststore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwk_fTruststore != null) {
                    jwk_fTruststore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwks_isKeystore != null) {
                    jwks_isKeystore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwks_fKeystore != null) {
                    jwks_fKeystore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwks_isTruststore != null) {
                    jwks_isTruststore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwks_fTruststore != null) {
                    jwks_fTruststore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwks_symmetric_isKeystore != null) {
                    jwks_symmetric_isKeystore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwks_symmetric_fKeystore != null) {
                    jwks_symmetric_fKeystore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwk_symmetric_isKeystore != null) {
                    jwk_symmetric_isKeystore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (jwk_symmetric_fKeystore != null) {
                    jwk_symmetric_fKeystore.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystore_crl_valid != null) {
                    isKeystore_crl_valid.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore_crl_valid != null) {
                    fKeystore_crl_valid.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystore_crl_expired != null) {
                    isKeystore_crl_expired.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore_crl_expired != null) {
                    fKeystore_crl_expired.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystore_crl_revoked != null) {
                    isKeystore_crl_revoked.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore_crl_revoked != null) {
                    fKeystore_crl_revoked.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isTruststore_crl != null) {
                    isTruststore_crl.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTruststore_crl != null) {
                    fTruststore_crl.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (is_crl != null) {
                    is_crl.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (f_crl != null) {
                    f_crl.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509_crl_valid != null) {
                    fCertX509_crl_valid.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509_crl_expired != null) {
                    fCertX509_crl_expired.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509_crl_revoked != null) {
                    fCertX509_crl_revoked.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystore_ocsp_valid != null) {
                    isKeystore_ocsp_valid.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore_ocsp_valid != null) {
                    fKeystore_ocsp_valid.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isKeystore_ocsp_revoked != null) {
                    isKeystore_ocsp_revoked.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fKeystore_ocsp_revoked != null) {
                    fKeystore_ocsp_revoked.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (isTruststore_ocsp != null) {
                    isTruststore_ocsp.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTruststore_ocsp != null) {
                    fTruststore_ocsp.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509_ocsp_valid != null) {
                    fCertX509_ocsp_valid.delete();
                }
            }
            catch (Exception exception) {}
            try {
                if (fCertX509_ocsp_revoked != null) {
                    fCertX509_ocsp_revoked.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String getLabelTest(TipoTest tipo, boolean useP11asTrustStore) {
        Object tipoL = tipo.toString();
        if (((String)tipoL).toLowerCase().contains(KeystoreType.PKCS11.getNome())) {
            tipoL = (String)tipoL + " - useP11asTrustStore:" + useP11asTrustStore;
        }
        return tipoL;
    }

    private static void testJava(TipoTest tipo, boolean useP11asTrustStore, org.openspcoop2.utils.certificate.KeyStore keystore, org.openspcoop2.utils.certificate.KeyStore truststore, String alias, String passwordChiavePrivata) throws Exception {
        System.out.println("\n\n ============== " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ==================");
        System.out.println("[" + tipo + "]. Example JavaEncrypt \n");
        String contenutoDaCifrare = "MarioRossi:23:05:1980";
        String encryptAlgorithm = "RSA";
        Encrypt encrypt = new Encrypt(keystore, alias, passwordChiavePrivata);
        byte[] encryptedBytes = encrypt.encrypt(contenutoDaCifrare.getBytes(), encryptAlgorithm);
        System.out.println("[" + tipo + "]-a. JavaEncrypt Encrypted (Private): " + new String(encryptedBytes));
        Decrypt decrypt = new Decrypt(truststore, alias);
        System.out.println("[" + tipo + "]-a. JavaEncrypt Decrypted (Public): " + new String(decrypt.decrypt(encryptedBytes, encryptAlgorithm)));
        encrypt = new Encrypt(truststore, alias);
        encryptedBytes = encrypt.encrypt(contenutoDaCifrare.getBytes(), encryptAlgorithm);
        System.out.println("[" + tipo + "]-b. JavaEncrypt Encrypted (Public): " + new String(encryptedBytes));
        decrypt = new Decrypt(keystore, alias, passwordChiavePrivata);
        System.out.println("[" + tipo + "]-b. JavaEncrypt Decrypted (Private): " + new String(decrypt.decrypt(encryptedBytes, encryptAlgorithm)));
    }

    private static void testXmlEncrypt(TipoTest tipo, boolean useP11asTrustStore, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, org.openspcoop2.utils.certificate.KeyStore truststore, org.openspcoop2.utils.certificate.KeyStore keystoreJCEKS, String aliasSecretKey, String passwordChiavePrivata) throws Exception {
        System.out.println("\n\n ============== " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ==================");
        System.out.println("[" + tipo + "]-. Example XmlEncrypt \n");
        String xmlInput = "<prova><test>VALORE</test></prova>";
        Element node = XMLUtils.getInstance().newElement(xmlInput.getBytes());
        String keyAlgorithm = "AES";
        String canonicalizationAlgorithm = null;
        String digestAlgorithm = "SHA-256";
        SecretKey secretKeyGenerata_symmetric = AbstractXmlCipher.generateSecretKey(keyAlgorithm);
        SecretKey secretKeyLetta = keystoreJCEKS.getSecretKey(aliasSecretKey, passwordChiavePrivata);
        String encryptAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        XmlEncrypt xmlEncrypt = new XmlEncrypt(SymmetricKeyWrappedMode.SYM_ENC_KEY_NO_WRAPPED, secretKeyGenerata_symmetric);
        xmlEncrypt.encryptSymmetric(node, encryptAlgorithm, canonicalizationAlgorithm, digestAlgorithm);
        System.out.println("[" + tipo + "]- (1a) Xml Encrypt (SymmetricKey-Generata): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        XmlDecrypt xmlDecrypt = new XmlDecrypt(SymmetricKeyWrappedMode.SYM_ENC_KEY_NO_WRAPPED, secretKeyGenerata_symmetric);
        xmlDecrypt.decrypt(node);
        System.out.println("[" + tipo + "]- (1a) Xml Decrypt (SymmetricKey-Generata): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        boolean symmetricKey = true;
        encryptAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        xmlEncrypt = new XmlEncrypt(keystoreJCEKS, symmetricKey, SymmetricKeyWrappedMode.SYM_ENC_KEY_NO_WRAPPED, aliasSecretKey, passwordChiavePrivata);
        xmlEncrypt.encryptSymmetric(node, encryptAlgorithm);
        System.out.println("[" + tipo + "]- (1b) Xml Encrypt (SymmetricKey-Letta): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        xmlDecrypt = new XmlDecrypt(keystoreJCEKS, symmetricKey, SymmetricKeyWrappedMode.SYM_ENC_KEY_NO_WRAPPED, aliasSecretKey, passwordChiavePrivata);
        xmlDecrypt.decrypt(node);
        System.out.println("[" + tipo + "]- (1b) Xml Decrypt (SymmetricKey-Letta): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        String wrappedKeyAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        if (!TipoTest.XML_ENCRYPT_PKCS11.equals((Object)tipo)) {
            keyAlgorithm = "AES";
            encryptAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            xmlEncrypt = new XmlEncrypt(SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, keystore, alias, passwordChiavePrivata);
            xmlEncrypt.encrypt(node, encryptAlgorithm, canonicalizationAlgorithm, digestAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
            System.out.println("[" + tipo + "]- (a1). Xml Encrypt (Private Wrapped): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
            xmlDecrypt = new XmlDecrypt(truststore, alias);
            xmlDecrypt.decrypt(node);
            System.out.println("[" + tipo + "]- (a1) Xml Decrypt (Public Wrapped): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        }
        xmlEncrypt = new XmlEncrypt(truststore, alias);
        xmlEncrypt.encrypt(node, encryptAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
        System.out.println("[" + tipo + "]- (b1) Xml Encrypt (Public Wrapped): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        xmlDecrypt = new XmlDecrypt(SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, keystore, alias, passwordChiavePrivata);
        xmlDecrypt.decrypt(node);
        System.out.println("[" + tipo + "]- (b2) Xml Decrypt (Private Wrapped): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        keyAlgorithm = "AES";
        encryptAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        wrappedKeyAlgorithm = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        xmlEncrypt = new XmlEncrypt(SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY, keystoreJCEKS, aliasSecretKey, passwordChiavePrivata);
        xmlEncrypt.encrypt(node, encryptAlgorithm, canonicalizationAlgorithm, digestAlgorithm, keyAlgorithm, wrappedKeyAlgorithm);
        System.out.println("[" + tipo + "]- (a1). Xml Encrypt (Symmetric Wrapped): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
        xmlDecrypt = new XmlDecrypt(keystoreJCEKS, true, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY, aliasSecretKey, passwordChiavePrivata);
        xmlDecrypt.decrypt(node);
        System.out.println("[" + tipo + "]- (a1) Xml Decrypt (Symmetric Wrapped): " + PrettyPrintXMLUtils.prettyPrintWithTrAX(node));
    }

    private static void testJsonProperties(TipoTest tipo, boolean useP11asTrustStore, File fKeystore, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, File fTruststore, JwtHeaders headers, org.openspcoop2.utils.certificate.KeyStore truststoreJKS, org.openspcoop2.utils.certificate.KeyStore keystoreJKS, HashMap<String, String> keystore_mapAliasPassword, JsonWebKeys jsonWebKeys) throws Exception {
        EncryptTest.testJsonProperties(tipo, useP11asTrustStore, fKeystore, keystore, alias, fTruststore, headers, truststoreJKS, keystoreJKS, keystore_mapAliasPassword, jsonWebKeys, null, null);
    }

    private static void testJsonProperties(TipoTest tipo, boolean useP11asTrustStore, File fKeystore, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, File fTruststore, JwtHeaders headers, org.openspcoop2.utils.certificate.KeyStore truststoreJKS, org.openspcoop2.utils.certificate.KeyStore keystoreJKS, HashMap<String, String> keystore_mapAliasPassword, JsonWebKeys jsonWebKeys, CRLCertstore crl, IOCSPValidator ocspValidator) throws Exception {
        block171: {
            String atteso;
            String headerName;
            String suffix;
            JsonDecrypt jsonDecrypt;
            JWTOptions optionsDecrypt;
            String attachEncrypt;
            JWEOptions options;
            String jsonInput;
            block170: {
                String atteso2;
                int lengthDeflated;
                int lengthNotDeflated;
                JsonEncrypt jsonEncrypt;
                Properties decryptProps;
                Properties encryptProps;
                block169: {
                    block168: {
                        block167: {
                            block166: {
                                block165: {
                                    block164: {
                                        block163: {
                                            block162: {
                                                block161: {
                                                    block160: {
                                                        System.out.println("\n\n ============= " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ===================");
                                                        System.out.println("[" + tipo + "]. Example JsonEncrypt \n");
                                                        jsonInput = "\n{\n\t\"name\":\"value1\", \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n}";
                                                        encryptProps = new Properties();
                                                        InputStream encryptPropsis = EncryptTest.class.getResourceAsStream("jws.encrypt.properties");
                                                        encryptProps.load(encryptPropsis);
                                                        encryptProps.put("rs.security.keystore.file", fTruststore.getPath());
                                                        if (useP11asTrustStore && truststoreJKS != null) {
                                                            encryptProps.remove("rs.security.keystore.file");
                                                            encryptProps.put("rs.security.keystore", truststoreJKS.getKeystore());
                                                        }
                                                        if (TipoTest.JSON_ENCRYPT_PROPERTIES_JKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            encryptProps.put("rs.security.keystore.type", KeystoreType.JKS.getNome());
                                                            if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                if (useP11asTrustStore) {
                                                                    encryptProps.put("rs.security.keystore.type", KeystoreType.PKCS11.getNome());
                                                                }
                                                                encryptProps.remove("rs.security.keystore.alias");
                                                                encryptProps.put("rs.security.keystore.alias", alias);
                                                                encryptProps.remove("rs.security.encryption.key.algorithm");
                                                                encryptProps.put("rs.security.encryption.key.algorithm", "RSA1_5");
                                                            }
                                                            if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                                encryptProps.remove("rs.security.keystore.alias");
                                                                encryptProps.put("rs.security.keystore.alias", alias);
                                                            }
                                                            if (headers != null) {
                                                                encryptProps.put("rs.security.encryption.include.cert.sha1", "true");
                                                                encryptProps.put("rs.security.encryption.include.cert.sha256", "false");
                                                            }
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM.equals((Object)tipo)) {
                                                            encryptProps.put("rs.security.keystore.type", "jceks");
                                                            encryptProps.put("rs.security.encryption.content.algorithm", "A256GCM");
                                                            encryptProps.put("rs.security.encryption.key.algorithm", "DIRECT");
                                                            encryptProps.put("rs.security.key.password", "key123456");
                                                            encryptProps.put("rs.security.encryption.include.key.id", "false");
                                                            encryptProps.put("rs.security.encryption.include.cert", "false");
                                                            encryptProps.remove("rs.security.encryption.include.cert.sha1");
                                                            encryptProps.remove("rs.security.encryption.include.cert.sha256");
                                                            if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                encryptProps.put("rs.security.keystore.type", KeystoreType.PKCS11.getNome());
                                                                encryptProps.remove("rs.security.keystore.alias");
                                                                encryptProps.put("rs.security.keystore.alias", alias);
                                                            }
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_JWK.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            encryptProps.put("rs.security.keystore.type", KeystoreType.JWK_SET.getNome());
                                                            encryptProps.remove("rs.security.encryption.include.cert.sha1");
                                                            encryptProps.remove("rs.security.encryption.include.cert.sha256");
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo)) {
                                                            encryptProps.put("rs.security.keystore.type", KeystoreType.JWK_SET.getNome());
                                                            encryptProps.put("rs.security.encryption.content.algorithm", "A256GCM");
                                                            encryptProps.put("rs.security.encryption.key.algorithm", "DIRECT");
                                                            encryptProps.put("rs.security.encryption.include.key.id", "false");
                                                            encryptProps.put("rs.security.encryption.include.public.key", "false");
                                                            encryptProps.remove("rs.security.encryption.include.cert.sha1");
                                                            encryptProps.remove("rs.security.encryption.include.cert.sha256");
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            encryptProps.remove("rs.security.keystore.alias");
                                                            encryptProps.put("rs.security.keystore.alias", alias);
                                                            encryptProps.remove("rs.security.encryption.key.algorithm");
                                                            encryptProps.put("rs.security.encryption.key.algorithm", "RSA1_5");
                                                        }
                                                        if (headers != null) {
                                                            encryptProps.remove("rs.security.encryption.include.cert");
                                                            encryptProps.remove("rs.security.encryption.include.public.key");
                                                        }
                                                        decryptProps = new Properties();
                                                        InputStream decryptPropsis = EncryptTest.class.getResourceAsStream("jws.decrypt.properties");
                                                        decryptProps.load(decryptPropsis);
                                                        if (fKeystore != null) {
                                                            decryptProps.put("rs.security.keystore.file", fKeystore.getPath());
                                                        } else if (keystore != null) {
                                                            decryptProps.put("rs.security.keystore", keystore.getKeystore());
                                                        }
                                                        decryptProps.remove("rs.security.keystore.type");
                                                        if (TipoTest.JSON_ENCRYPT_PROPERTIES_JKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            if (TipoTest.JSON_ENCRYPT_PROPERTIES_JKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                decryptProps.put("rs.security.keystore.type", KeystoreType.JKS.getNome());
                                                            } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                decryptProps.put("rs.security.keystore.type", KeystoreType.PKCS12.getNome());
                                                            } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                decryptProps.put("rs.security.keystore.type", KeystoreType.PKCS11.getNome());
                                                                decryptProps.remove("rs.security.keystore.alias");
                                                                decryptProps.put("rs.security.keystore.alias", alias);
                                                                decryptProps.remove("rs.security.encryption.key.algorithm");
                                                                decryptProps.put("rs.security.encryption.key.algorithm", "RSA1_5");
                                                            } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                                decryptProps.put("rs.security.keystore.type", KeystoreType.PKCS12.getNome());
                                                                decryptProps.remove("rs.security.keystore.alias");
                                                                decryptProps.put("rs.security.keystore.alias", alias);
                                                                decryptProps.remove("rs.security.key.password");
                                                                decryptProps.put("rs.security.key.password", "123456");
                                                            }
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM.equals((Object)tipo)) {
                                                            decryptProps.put("rs.security.keystore.type", "jceks");
                                                            decryptProps.put("rs.security.encryption.content.algorithm", "A256GCM");
                                                            decryptProps.put("rs.security.encryption.key.algorithm", "DIRECT");
                                                            if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                decryptProps.put("rs.security.keystore.type", KeystoreType.PKCS11.getNome());
                                                                decryptProps.remove("rs.security.keystore.alias");
                                                                decryptProps.put("rs.security.keystore.alias", alias);
                                                            }
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_JWK.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            decryptProps.put("rs.security.keystore.type", KeystoreType.JWK_SET.getNome());
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo)) {
                                                            decryptProps.put("rs.security.keystore.type", KeystoreType.JWK_SET.getNome());
                                                            decryptProps.put("rs.security.encryption.content.algorithm", "A256GCM");
                                                            decryptProps.put("rs.security.encryption.key.algorithm", "DIRECT");
                                                            decryptProps.put("rs.security.encryption.include.key.id", "false");
                                                            decryptProps.put("rs.security.encryption.include.public.key", "false");
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            decryptProps.put("rs.security.keystore.type", KeystoreType.PKCS11.getNome());
                                                            decryptProps.remove("rs.security.keystore.alias");
                                                            decryptProps.put("rs.security.keystore.alias", alias);
                                                            decryptProps.remove("rs.security.encryption.key.algorithm");
                                                            decryptProps.put("rs.security.encryption.key.algorithm", "RSA1_5");
                                                        }
                                                        System.out.println("\n\n");
                                                        options = new JWEOptions(JOSESerialization.JSON);
                                                        jsonEncrypt = null;
                                                        jsonEncrypt = headers == null ? new JsonEncrypt(encryptProps, options) : new JsonEncrypt(encryptProps, headers, options);
                                                        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                                                        lengthNotDeflated = attachEncrypt.length();
                                                        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, encryptProps, headers);
                                                        optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
                                                        jsonDecrypt = new JsonDecrypt(decryptProps, optionsDecrypt);
                                                        if (crl != null) {
                                                            jsonDecrypt.setCrlX509(crl.getCertStore());
                                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                        }
                                                        if (ocspValidator != null) {
                                                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                        }
                                                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                                            try {
                                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                                            }
                                                            catch (Exception e) {
                                                                String atteso3;
                                                                String string = atteso3 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                                                if ("test".equals(alias)) {
                                                                    atteso3 = "Certificato di firma non valido: Certificate revoked in date";
                                                                }
                                                                if (e.getMessage().contains(atteso3)) {
                                                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                                                    break block160;
                                                                }
                                                                throw e;
                                                            }
                                                        }
                                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                    }
                                                    if (!(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo))) {
                                                        String suffix2 = "";
                                                        if (jsonWebKeys != null) {
                                                            jsonDecrypt = new JsonDecrypt(jsonWebKeys, optionsDecrypt);
                                                            suffix2 = "-jsonWebKeysHDR";
                                                        } else {
                                                            jsonDecrypt = new JsonDecrypt(truststoreJKS, keystoreJKS, keystore_mapAliasPassword, optionsDecrypt);
                                                            suffix2 = "-jksHDR";
                                                        }
                                                        if (crl != null) {
                                                            jsonDecrypt.setCrlX509(crl.getCertStore());
                                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                        }
                                                        if (ocspValidator != null) {
                                                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                        }
                                                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                                            try {
                                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix2, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                                            }
                                                            catch (Exception e) {
                                                                String atteso4;
                                                                String headerName2 = "x5c";
                                                                if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo)) {
                                                                    headerName2 = "x5u";
                                                                } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                                    headerName2 = "kid";
                                                                }
                                                                String string = atteso4 = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName2 + "' error: Certificato presente nell'header '" + headerName2 + "' scaduto: NotAfter: " : "Process '" + headerName2 + "' error: Certificato presente nell'header '" + headerName2 + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                                                if ("test".equals(alias)) {
                                                                    atteso4 = "Process '" + headerName2 + "' error: Certificato presente nell'header '" + headerName2 + "' non valido: Certificate revoked in date";
                                                                }
                                                                if (e.getMessage().contains(atteso4)) {
                                                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                                                    break block161;
                                                                }
                                                                throw e;
                                                            }
                                                        }
                                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix2, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                    }
                                                }
                                                System.out.println("\n\n");
                                                encryptProps.put("rs.security.encryption.zip.algorithm", "DEF");
                                                options = new JWEOptions(JOSESerialization.JSON);
                                                jsonEncrypt = headers == null ? new JsonEncrypt(encryptProps, options) : new JsonEncrypt(encryptProps, headers, options);
                                                attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                                                lengthDeflated = attachEncrypt.length();
                                                EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflateProperties", attachEncrypt, jsonInput, options, encryptProps, headers);
                                                if (lengthDeflated >= lengthNotDeflated) {
                                                    throw new Exception("Attesa dimensione minore con utilizzo di deflate");
                                                }
                                                optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
                                                jsonDecrypt = new JsonDecrypt(decryptProps, optionsDecrypt);
                                                if (crl != null) {
                                                    jsonDecrypt.setCrlX509(crl.getCertStore());
                                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                }
                                                if (ocspValidator != null) {
                                                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                }
                                                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                                    try {
                                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflateProperties", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                                    }
                                                    catch (Exception e) {
                                                        String string = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                                        if ("test".equals(alias)) {
                                                            atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                                                        }
                                                        if (e.getMessage().contains(atteso2)) {
                                                            System.out.println("Eccezione attesa: " + e.getMessage());
                                                            break block162;
                                                        }
                                                        throw e;
                                                    }
                                                }
                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflateProperties", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                            }
                                            if (!(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo))) {
                                                suffix = "";
                                                if (jsonWebKeys != null) {
                                                    jsonDecrypt = new JsonDecrypt(jsonWebKeys, optionsDecrypt);
                                                    suffix = "-jsonWebKeysHDR";
                                                } else {
                                                    jsonDecrypt = new JsonDecrypt(truststoreJKS, keystoreJKS, keystore_mapAliasPassword, optionsDecrypt);
                                                    suffix = "-jksHDR";
                                                }
                                                if (crl != null) {
                                                    jsonDecrypt.setCrlX509(crl.getCertStore());
                                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                }
                                                if (ocspValidator != null) {
                                                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                                }
                                                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                                    try {
                                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflateProperties" + suffix, false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                                    }
                                                    catch (Exception e) {
                                                        headerName = "x5c";
                                                        if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo)) {
                                                            headerName = "x5u";
                                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                            headerName = "kid";
                                                        }
                                                        String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                                        if ("test".equals(alias)) {
                                                            atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                                                        }
                                                        if (e.getMessage().contains(atteso)) {
                                                            System.out.println("Eccezione attesa: " + e.getMessage());
                                                            break block163;
                                                        }
                                                        throw e;
                                                    }
                                                }
                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflateProperties" + suffix, false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                            }
                                        }
                                        encryptProps.remove("rs.security.encryption.zip.algorithm");
                                        System.out.println("\n\n");
                                        options = new JWEOptions(JOSESerialization.JSON);
                                        options.setDeflate(true);
                                        jsonEncrypt = headers == null ? new JsonEncrypt(encryptProps, options) : new JsonEncrypt(encryptProps, headers, options);
                                        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                                        lengthDeflated = attachEncrypt.length();
                                        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, encryptProps, headers);
                                        if (lengthDeflated >= lengthNotDeflated) {
                                            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
                                        }
                                        optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
                                        jsonDecrypt = new JsonDecrypt(decryptProps, optionsDecrypt);
                                        if (crl != null) {
                                            jsonDecrypt.setCrlX509(crl.getCertStore());
                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                        }
                                        if (ocspValidator != null) {
                                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                        }
                                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                            try {
                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                            }
                                            catch (Exception e) {
                                                String string = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                                if ("test".equals(alias)) {
                                                    atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                                                }
                                                if (e.getMessage().contains(atteso2)) {
                                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                                    break block164;
                                                }
                                                throw e;
                                            }
                                        }
                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                    }
                                    if (!(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo))) {
                                        suffix = "";
                                        if (jsonWebKeys != null) {
                                            jsonDecrypt = new JsonDecrypt(jsonWebKeys, optionsDecrypt);
                                            suffix = "-jsonWebKeysHDR";
                                        } else {
                                            jsonDecrypt = new JsonDecrypt(truststoreJKS, keystoreJKS, keystore_mapAliasPassword, optionsDecrypt);
                                            suffix = "-jksHDR";
                                        }
                                        if (crl != null) {
                                            jsonDecrypt.setCrlX509(crl.getCertStore());
                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                        }
                                        if (ocspValidator != null) {
                                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                        }
                                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                            try {
                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                            }
                                            catch (Exception e) {
                                                headerName = "x5c";
                                                if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo)) {
                                                    headerName = "x5u";
                                                } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                                    headerName = "kid";
                                                }
                                                String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                                if ("test".equals(alias)) {
                                                    atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                                                }
                                                if (e.getMessage().contains(atteso)) {
                                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                                    break block165;
                                                }
                                                throw e;
                                            }
                                        }
                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                    }
                                }
                                System.out.println("\n\n");
                                options = new JWEOptions(JOSESerialization.COMPACT);
                                jsonEncrypt = headers == null ? new JsonEncrypt(encryptProps, options) : new JsonEncrypt(encryptProps, headers, options);
                                attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                                lengthNotDeflated = attachEncrypt.length();
                                EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, encryptProps, headers);
                                optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
                                jsonDecrypt = new JsonDecrypt(decryptProps, optionsDecrypt);
                                if (crl != null) {
                                    jsonDecrypt.setCrlX509(crl.getCertStore());
                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                }
                                if (ocspValidator != null) {
                                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                }
                                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                    try {
                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                    }
                                    catch (Exception e) {
                                        String string = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                        if ("test".equals(alias)) {
                                            atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                                        }
                                        if (e.getMessage().contains(atteso2)) {
                                            System.out.println("Eccezione attesa: " + e.getMessage());
                                            break block166;
                                        }
                                        throw e;
                                    }
                                }
                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                            }
                            if (!(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo))) {
                                suffix = "";
                                if (jsonWebKeys != null) {
                                    jsonDecrypt = new JsonDecrypt(jsonWebKeys, optionsDecrypt);
                                    suffix = "-jsonWebKeysHDR";
                                } else {
                                    jsonDecrypt = new JsonDecrypt(truststoreJKS, keystoreJKS, keystore_mapAliasPassword, optionsDecrypt);
                                    suffix = "-jksHDR";
                                }
                                if (crl != null) {
                                    jsonDecrypt.setCrlX509(crl.getCertStore());
                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                }
                                if (ocspValidator != null) {
                                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                                }
                                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                    try {
                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                    }
                                    catch (Exception e) {
                                        headerName = "x5c";
                                        if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo)) {
                                            headerName = "x5u";
                                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                            headerName = "kid";
                                        }
                                        String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                        if ("test".equals(alias)) {
                                            atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                                        }
                                        if (e.getMessage().contains(atteso)) {
                                            System.out.println("Eccezione attesa: " + e.getMessage());
                                            break block167;
                                        }
                                        throw e;
                                    }
                                }
                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                            }
                        }
                        System.out.println("\n\n");
                        encryptProps.put("rs.security.encryption.zip.algorithm", "DEF");
                        options = new JWEOptions(JOSESerialization.COMPACT);
                        jsonEncrypt = headers == null ? new JsonEncrypt(encryptProps, options) : new JsonEncrypt(encryptProps, headers, options);
                        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                        lengthDeflated = attachEncrypt.length();
                        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, encryptProps, headers);
                        if (lengthDeflated >= lengthNotDeflated) {
                            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
                        }
                        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
                        jsonDecrypt = new JsonDecrypt(decryptProps, optionsDecrypt);
                        if (crl != null) {
                            jsonDecrypt.setCrlX509(crl.getCertStore());
                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                        }
                        if (ocspValidator != null) {
                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                        }
                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                            try {
                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                            }
                            catch (Exception e) {
                                String string = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                if ("test".equals(alias)) {
                                    atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                                }
                                if (e.getMessage().contains(atteso2)) {
                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                    break block168;
                                }
                                throw e;
                            }
                        }
                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                    }
                    if (!(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo))) {
                        suffix = "";
                        if (jsonWebKeys != null) {
                            jsonDecrypt = new JsonDecrypt(jsonWebKeys, optionsDecrypt);
                            suffix = "-jsonWebKeysHDR";
                        } else {
                            jsonDecrypt = new JsonDecrypt(truststoreJKS, keystoreJKS, keystore_mapAliasPassword, optionsDecrypt);
                            suffix = "-jksHDR";
                        }
                        if (crl != null) {
                            jsonDecrypt.setCrlX509(crl.getCertStore());
                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                        }
                        if (ocspValidator != null) {
                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                        }
                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                            try {
                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                            }
                            catch (Exception e) {
                                headerName = "x5c";
                                if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo)) {
                                    headerName = "x5u";
                                } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                                    headerName = "kid";
                                }
                                String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                if ("test".equals(alias)) {
                                    atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                                }
                                if (e.getMessage().contains(atteso)) {
                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                    break block169;
                                }
                                throw e;
                            }
                        }
                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                    }
                }
                encryptProps.remove("rs.security.encryption.zip.algorithm");
                System.out.println("\n\n");
                options = new JWEOptions(JOSESerialization.COMPACT);
                options.setDeflate(true);
                jsonEncrypt = headers == null ? new JsonEncrypt(encryptProps, options) : new JsonEncrypt(encryptProps, headers, options);
                attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                lengthDeflated = attachEncrypt.length();
                EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, encryptProps, headers);
                if (lengthDeflated >= lengthNotDeflated) {
                    throw new Exception("Attesa dimensione minore con utilizzo di deflate");
                }
                optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
                jsonDecrypt = new JsonDecrypt(decryptProps, optionsDecrypt);
                if (crl != null) {
                    jsonDecrypt.setCrlX509(crl.getCertStore());
                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                }
                if (ocspValidator != null) {
                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                }
                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                    try {
                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                    }
                    catch (Exception e) {
                        String string = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                        if ("test".equals(alias)) {
                            atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                        }
                        if (e.getMessage().contains(atteso2)) {
                            System.out.println("Eccezione attesa: " + e.getMessage());
                            break block170;
                        }
                        throw e;
                    }
                }
                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
            }
            if (!(TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM.equals((Object)tipo))) {
                suffix = "";
                if (jsonWebKeys != null) {
                    jsonDecrypt = new JsonDecrypt(jsonWebKeys, optionsDecrypt);
                    suffix = "-jsonWebKeysHDR";
                } else {
                    jsonDecrypt = new JsonDecrypt(truststoreJKS, keystoreJKS, keystore_mapAliasPassword, optionsDecrypt);
                    suffix = "-jksHDR";
                }
                if (crl != null) {
                    jsonDecrypt.setCrlX509(crl.getCertStore());
                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                }
                if (ocspValidator != null) {
                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststoreJKS);
                }
                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                    try {
                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                    }
                    catch (Exception e) {
                        headerName = "x5c";
                        if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM.equals((Object)tipo)) {
                            headerName = "x5u";
                        } else if (TipoTest.JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY.equals((Object)tipo)) {
                            headerName = "kid";
                        }
                        String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                        if ("test".equals(alias)) {
                            atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                        }
                        if (e.getMessage().contains(atteso)) {
                            System.out.println("Eccezione attesa: " + e.getMessage());
                            break block171;
                        }
                        throw e;
                    }
                }
                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
            }
        }
        System.out.println("\n\n");
    }

    private static void testJsonKeystore(TipoTest tipo, boolean useP11asTrustStore, org.openspcoop2.utils.certificate.KeyStore keystore, org.openspcoop2.utils.certificate.KeyStore truststore, String alias, String passwordChiavePrivata, JwtHeaders headers, HashMap<String, String> keystore_mapAliasPassword) throws Exception {
        EncryptTest.testJsonKeystore(tipo, useP11asTrustStore, keystore, truststore, alias, passwordChiavePrivata, headers, keystore_mapAliasPassword, null, null);
    }

    private static void testJsonKeystore(TipoTest tipo, boolean useP11asTrustStore, org.openspcoop2.utils.certificate.KeyStore keystore, org.openspcoop2.utils.certificate.KeyStore truststore, String alias, String passwordChiavePrivata, JwtHeaders headers, HashMap<String, String> keystore_mapAliasPassword, CRLCertstore crl, IOCSPValidator ocspValidator) throws Exception {
        block70: {
            String atteso;
            String headerName;
            String suffix;
            JsonDecrypt jsonDecrypt;
            JWTOptions optionsDecrypt;
            String attachEncrypt;
            JWEOptions options;
            String jsonInput;
            block69: {
                int lengthDeflated;
                Object atteso2;
                int lengthNotDeflated;
                JsonEncrypt jsonEncrypt;
                String contentAlgorithm;
                String keyAlgorithm;
                block68: {
                    block67: {
                        block66: {
                            block65: {
                                block64: {
                                    block63: {
                                        System.out.println("\n\n ============= " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ===================");
                                        System.out.println("[" + tipo + "]. Example JsonEncrypt \n");
                                        jsonInput = "\n{\n\t\"name\":\"value1\", \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n}";
                                        keyAlgorithm = "RSA-OAEP-256";
                                        contentAlgorithm = "A256GCM";
                                        if (TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_PKCS11_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo)) {
                                            keyAlgorithm = "RSA1_5";
                                        }
                                        System.out.println("\n\n");
                                        options = new JWEOptions(JOSESerialization.JSON);
                                        jsonEncrypt = null;
                                        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, headers, options);
                                        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                                        lengthNotDeflated = attachEncrypt.length();
                                        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
                                        optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
                                        jsonDecrypt = new JsonDecrypt(keystore, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
                                        if (crl != null) {
                                            jsonDecrypt.setCrlX509(crl.getCertStore());
                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                                        }
                                        if (ocspValidator != null) {
                                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                                        }
                                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                            try {
                                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                            }
                                            catch (Exception e) {
                                                String atteso3;
                                                String string = atteso3 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                                if ("test".equals(alias)) {
                                                    atteso3 = "Certificato di firma non valido: Certificate revoked in date";
                                                }
                                                if (e.getMessage().contains(atteso3)) {
                                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                                    break block63;
                                                }
                                                throw e;
                                            }
                                        }
                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                    }
                                    suffix = "";
                                    jsonDecrypt = new JsonDecrypt(truststore, keystore, keystore_mapAliasPassword, optionsDecrypt);
                                    if (crl != null) {
                                        jsonDecrypt.setCrlX509(crl.getCertStore());
                                        jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                                    }
                                    if (ocspValidator != null) {
                                        jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                        jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                                    }
                                    suffix = "-jksHDR";
                                    if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                        try {
                                            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                            throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                        }
                                        catch (Exception e) {
                                            String headerName2 = "kid";
                                            if (TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo)) {
                                                headerName2 = "x5u";
                                            }
                                            Object object = atteso2 = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName2 + "' error: Certificato presente nell'header '" + headerName2 + "' scaduto: NotAfter: " : "Process '" + headerName2 + "' error: Certificato presente nell'header '" + headerName2 + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                            if ("test".equals(alias)) {
                                                atteso2 = "Process '" + headerName2 + "' error: Certificato presente nell'header '" + headerName2 + "' non valido: Certificate revoked in date";
                                            }
                                            if (e.getMessage().contains((CharSequence)atteso2)) {
                                                System.out.println("Eccezione attesa: " + e.getMessage());
                                                break block64;
                                            }
                                            throw e;
                                        }
                                    }
                                    EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                }
                                System.out.println("\n\n");
                                options = new JWEOptions(JOSESerialization.JSON);
                                options.setDeflate(true);
                                jsonEncrypt = headers == null ? new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, headers, options);
                                attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                                lengthDeflated = attachEncrypt.length();
                                EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
                                if (lengthDeflated >= lengthNotDeflated) {
                                    throw new Exception("Attesa dimensione minore con utilizzo di deflate");
                                }
                                optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
                                jsonDecrypt = new JsonDecrypt(keystore, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
                                if (crl != null) {
                                    jsonDecrypt.setCrlX509(crl.getCertStore());
                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                                }
                                if (ocspValidator != null) {
                                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                                }
                                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                    try {
                                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                    }
                                    catch (Exception e) {
                                        Object object = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                        if ("test".equals(alias)) {
                                            atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                                        }
                                        if (e.getMessage().contains((CharSequence)atteso2)) {
                                            System.out.println("Eccezione attesa: " + e.getMessage());
                                            break block65;
                                        }
                                        throw e;
                                    }
                                }
                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                            }
                            jsonDecrypt = new JsonDecrypt(truststore, keystore, keystore_mapAliasPassword, optionsDecrypt);
                            if (crl != null) {
                                jsonDecrypt.setCrlX509(crl.getCertStore());
                                jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                            }
                            if (ocspValidator != null) {
                                jsonDecrypt.setOcspValidatorX509(ocspValidator);
                                jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                            }
                            suffix = "-jksHDR";
                            if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                                try {
                                    EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", true, jsonDecrypt, attachEncrypt, jsonInput, options);
                                    throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                                }
                                catch (Exception e) {
                                    headerName = "kid";
                                    if (TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo)) {
                                        headerName = "x5u";
                                    }
                                    String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                                    if ("test".equals(alias)) {
                                        atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                                    }
                                    if (e.getMessage().contains(atteso)) {
                                        System.out.println("Eccezione attesa: " + e.getMessage());
                                        break block66;
                                    }
                                    throw e;
                                }
                            }
                            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", true, jsonDecrypt, attachEncrypt, jsonInput, options);
                        }
                        System.out.println("\n\n");
                        options = new JWEOptions(JOSESerialization.COMPACT);
                        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, headers, options);
                        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                        lengthNotDeflated = attachEncrypt.length();
                        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
                        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
                        jsonDecrypt = new JsonDecrypt(keystore, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
                        if (crl != null) {
                            jsonDecrypt.setCrlX509(crl.getCertStore());
                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                        }
                        if (ocspValidator != null) {
                            jsonDecrypt.setOcspValidatorX509(ocspValidator);
                            jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                        }
                        if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                            try {
                                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                                throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                            }
                            catch (Exception e) {
                                Object object = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                                if ("test".equals(alias)) {
                                    atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                                }
                                if (e.getMessage().contains((CharSequence)atteso2)) {
                                    System.out.println("Eccezione attesa: " + e.getMessage());
                                    break block67;
                                }
                                throw e;
                            }
                        }
                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                    }
                    jsonDecrypt = new JsonDecrypt(truststore, keystore, keystore_mapAliasPassword, optionsDecrypt);
                    if (crl != null) {
                        jsonDecrypt.setCrlX509(crl.getCertStore());
                        jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                    }
                    if (ocspValidator != null) {
                        jsonDecrypt.setOcspValidatorX509(ocspValidator);
                        jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                    }
                    suffix = "-jksHDR";
                    if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                        try {
                            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", true, jsonDecrypt, attachEncrypt, jsonInput, options);
                            throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                        }
                        catch (Exception e) {
                            headerName = "kid";
                            if (TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo)) {
                                headerName = "x5u";
                            }
                            String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                            if ("test".equals(alias)) {
                                atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                            }
                            if (e.getMessage().contains(atteso)) {
                                System.out.println("Eccezione attesa: " + e.getMessage());
                                break block68;
                            }
                            throw e;
                        }
                    }
                    EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", true, jsonDecrypt, attachEncrypt, jsonInput, options);
                }
                System.out.println("\n\n");
                options = new JWEOptions(JOSESerialization.COMPACT);
                options.setDeflate(true);
                jsonEncrypt = headers == null ? new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, alias, keyAlgorithm, contentAlgorithm, headers, options);
                attachEncrypt = jsonEncrypt.encrypt(jsonInput);
                lengthDeflated = attachEncrypt.length();
                EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
                if (lengthDeflated >= lengthNotDeflated) {
                    throw new Exception("Attesa dimensione minore con utilizzo di deflate");
                }
                optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
                jsonDecrypt = new JsonDecrypt(keystore, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
                if (crl != null) {
                    jsonDecrypt.setCrlX509(crl.getCertStore());
                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                }
                if (ocspValidator != null) {
                    jsonDecrypt.setOcspValidatorX509(ocspValidator);
                    jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
                }
                if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                    try {
                        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
                        throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                    }
                    catch (Exception e) {
                        Object object = atteso2 = "ExampleClientScaduto".equals(alias) ? "Certificato di firma scaduto: NotAfter:" : "Certificato di firma non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date:";
                        if ("test".equals(alias)) {
                            atteso2 = "Certificato di firma non valido: Certificate revoked in date";
                        }
                        if (e.getMessage().contains((CharSequence)atteso2)) {
                            System.out.println("Eccezione attesa: " + e.getMessage());
                            break block69;
                        }
                        throw e;
                    }
                }
                EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
            }
            jsonDecrypt = new JsonDecrypt(truststore, keystore, keystore_mapAliasPassword, optionsDecrypt);
            if (crl != null) {
                jsonDecrypt.setCrlX509(crl.getCertStore());
                jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
            }
            if (ocspValidator != null) {
                jsonDecrypt.setOcspValidatorX509(ocspValidator);
                jsonDecrypt.setTrustStoreVerificaCertificatiX509(truststore);
            }
            suffix = "-jksHDR";
            if ("ExampleClientScaduto".equals(alias) || "ExampleClientRevocato".equals(alias) || "test".equals(alias)) {
                try {
                    EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", true, jsonDecrypt, attachEncrypt, jsonInput, options);
                    throw new Exception("Attesa eccezione certificato non valido (alias: " + alias + ")");
                }
                catch (Exception e) {
                    headerName = "kid";
                    if (TipoTest.JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM.equals((Object)tipo)) {
                        headerName = "x5u";
                    }
                    String string = atteso = "ExampleClientScaduto".equals(alias) ? "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' scaduto: NotAfter: " : "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate has been revoked, reason: KEY_COMPROMISE, revocation date";
                    if ("test".equals(alias)) {
                        atteso = "Process '" + headerName + "' error: Certificato presente nell'header '" + headerName + "' non valido: Certificate revoked in date";
                    }
                    if (e.getMessage().contains(atteso)) {
                        System.out.println("Eccezione attesa: " + e.getMessage());
                        break block70;
                    }
                    throw e;
                }
            }
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
    }

    private static void testJsonKeystore(TipoTest tipo, boolean useP11asTrustStore, org.openspcoop2.utils.certificate.KeyStore keystoreJCEKS, String alias, String passwordChiavePrivata, JwtHeaders headers) throws Exception {
        System.out.println("\n\n ============= " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ===================");
        System.out.println("[" + tipo + "]. Example JsonEncrypt (Symmetric) \n");
        String jsonInput = "\n{\n\t\"name\":\"value1\", \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n}";
        String keyAlgorithm = "A256KW";
        String contentAlgorithm = "A256GCM";
        boolean symmetric = true;
        System.out.println("\n");
        JWEOptions options = new JWEOptions(JOSESerialization.JSON);
        JsonEncrypt jsonEncrypt = null;
        jsonEncrypt = headers == null ? new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, headers, options);
        String attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        int lengthNotDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
        JWTOptions optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
        JsonDecrypt jsonDecrypt = new JsonDecrypt(keystoreJCEKS, symmetric, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.JSON);
        options.setDeflate(true);
        jsonEncrypt = headers == null ? new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        int lengthDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
        if (lengthDeflated >= lengthNotDeflated) {
            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
        }
        optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
        jsonDecrypt = new JsonDecrypt(keystoreJCEKS, symmetric, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.COMPACT);
        jsonEncrypt = headers == null ? new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        lengthNotDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
        jsonDecrypt = new JsonDecrypt(keystoreJCEKS, symmetric, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.COMPACT);
        options.setDeflate(true);
        jsonEncrypt = headers == null ? new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(keystoreJCEKS, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        lengthDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
        if (lengthDeflated >= lengthNotDeflated) {
            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
        }
        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
        jsonDecrypt = new JsonDecrypt(keystoreJCEKS, symmetric, alias, passwordChiavePrivata, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        System.out.println("\n\n");
    }

    private static void testJsonJwkKeys(TipoTest tipo, boolean useP11asTrustStore, JsonWebKeys keystore, JsonWebKeys truststore, String alias, JwtHeaders headers) throws Exception {
        String suffix;
        System.out.println("\n\n ============= " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ===================");
        System.out.println("[" + tipo + "]. Example JsonEncrypt \n");
        String jsonInput = "\n{\n\t\"name\":\"value1\", \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n}";
        String keyAlgorithm = "RSA-OAEP-256";
        String contentAlgorithm = "A256GCM";
        System.out.println("\n\n");
        boolean symmetric = false;
        if (TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEYS.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEYS_HEADER_CUSTOM.equals((Object)tipo)) {
            symmetric = true;
            keyAlgorithm = "DIRECT";
            contentAlgorithm = "A256GCM";
        }
        JWEOptions options = new JWEOptions(JOSESerialization.JSON);
        JsonEncrypt jsonEncrypt = null;
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, headers, options);
        String attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        int lengthNotDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
        JWTOptions optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
        JsonDecrypt jsonDecrypt = new JsonDecrypt(keystore, symmetric, alias, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            String suffix2 = "";
            jsonDecrypt = new JsonDecrypt(keystore, optionsDecrypt);
            suffix2 = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix2, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.JSON);
        options.setDeflate(true);
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        int lengthDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
        if (lengthDeflated >= lengthNotDeflated) {
            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
        }
        optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
        jsonDecrypt = new JsonDecrypt(keystore, symmetric, alias, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            suffix = "";
            jsonDecrypt = new JsonDecrypt(keystore, optionsDecrypt);
            suffix = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.COMPACT);
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        lengthNotDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
        jsonDecrypt = new JsonDecrypt(keystore, symmetric, alias, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            suffix = "";
            jsonDecrypt = new JsonDecrypt(keystore, optionsDecrypt);
            suffix = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.COMPACT);
        options.setDeflate(true);
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, alias, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        lengthDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
        if (lengthDeflated >= lengthNotDeflated) {
            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
        }
        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
        jsonDecrypt = new JsonDecrypt(keystore, symmetric, alias, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            suffix = "";
            jsonDecrypt = new JsonDecrypt(keystore, optionsDecrypt);
            suffix = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
    }

    private static void testJsonJwkKey(TipoTest tipo, boolean useP11asTrustStore, JsonWebKey keystore, JsonWebKey truststore, JwtHeaders headers, JsonWebKeys keystoreVerificaHeaders) throws Exception {
        String suffix;
        System.out.println("\n\n ============= " + EncryptTest.getLabelTest(tipo, useP11asTrustStore) + " ===================");
        System.out.println("[" + tipo + "]. Example JsonEncrypt \n");
        String jsonInput = "\n{\n\t\"name\":\"value1\", \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n, \n\t\"name2\":\"value2\"\n}";
        String keyAlgorithm = "RSA-OAEP-256";
        String contentAlgorithm = "A256GCM";
        boolean symmetric = false;
        if (TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEY.equals((Object)tipo) || TipoTest.JSON_ENCRYPT_JWK_SYMMETRIC_KEY_HEADER_CUSTOM.equals((Object)tipo)) {
            symmetric = true;
            keyAlgorithm = "DIRECT";
            contentAlgorithm = "A256GCM";
        }
        JWEOptions options = new JWEOptions(JOSESerialization.JSON);
        JsonEncrypt jsonEncrypt = null;
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, headers, options);
        String attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        int lengthNotDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
        JWTOptions optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
        JsonDecrypt jsonDecrypt = new JsonDecrypt(keystore, symmetric, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            String suffix2 = "";
            jsonDecrypt = new JsonDecrypt(keystoreVerificaHeaders, optionsDecrypt);
            suffix2 = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix2, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.JSON);
        options.setDeflate(true);
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        int lengthDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
        if (lengthDeflated >= lengthNotDeflated) {
            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
        }
        optionsDecrypt = new JWTOptions(JOSESerialization.JSON);
        jsonDecrypt = new JsonDecrypt(keystore, symmetric, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            suffix = "";
            jsonDecrypt = new JsonDecrypt(keystoreVerificaHeaders, optionsDecrypt);
            suffix = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.COMPACT);
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        lengthNotDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate", attachEncrypt, jsonInput, options, null, headers);
        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
        jsonDecrypt = new JsonDecrypt(keystore, symmetric, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            suffix = "";
            jsonDecrypt = new JsonDecrypt(keystoreVerificaHeaders, optionsDecrypt);
            suffix = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
        options = new JWEOptions(JOSESerialization.COMPACT);
        options.setDeflate(true);
        jsonEncrypt = headers == null ? new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, options) : new JsonEncrypt(truststore, symmetric, keyAlgorithm, contentAlgorithm, headers, options);
        attachEncrypt = jsonEncrypt.encrypt(jsonInput);
        lengthDeflated = attachEncrypt.length();
        EncryptTest.verifyEncryptBuild(tipo, "encPublic-decryptPrivate-deflate", attachEncrypt, jsonInput, options, null, headers);
        if (lengthDeflated >= lengthNotDeflated) {
            throw new Exception("Attesa dimensione minore con utilizzo di deflate");
        }
        optionsDecrypt = new JWTOptions(JOSESerialization.COMPACT);
        jsonDecrypt = new JsonDecrypt(keystore, symmetric, keyAlgorithm, contentAlgorithm, optionsDecrypt);
        EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate", false, jsonDecrypt, attachEncrypt, jsonInput, options);
        if (!symmetric) {
            suffix = "";
            jsonDecrypt = new JsonDecrypt(keystoreVerificaHeaders, optionsDecrypt);
            suffix = "-jsonWebKeysHDR";
            EncryptTest.decrypt(tipo, "encPublic-decryptPrivate-deflate" + suffix, true, jsonDecrypt, attachEncrypt, jsonInput, options);
        }
        System.out.println("\n\n");
    }

    private static void verifyEncryptBuild(TipoTest tipo, String extTipo, String encryption, String jsonInput, JWEOptions options, Properties signatureProps, JwtHeaders headers) throws Exception {
        block12: {
            List<String> checkHeaders;
            block11: {
                checkHeaders = EncryptTest.getHeaders(signatureProps, headers);
                System.out.println("[" + tipo + " - " + extTipo + "] " + options.getSerialization().name() + " Encrypt (deflate:" + options.isDeflate() + ") Encrypted.length=" + encryption.length() + " Encrypted: \n" + encryption);
                if (!JOSESerialization.JSON.equals((Object)options.getSerialization())) break block11;
                if (!encryption.contains("\"ciphertext\":")) {
                    throw new Exception("Not Found payload");
                }
                if (encryption.contains(jsonInput)) {
                    throw new Exception("Payload not encoded");
                }
                int indexOf = encryption.indexOf("\"protected\":\"");
                String protectedHeaders = encryption.substring(indexOf + "\"protected\":\"".length());
                protectedHeaders = protectedHeaders.substring(0, protectedHeaders.indexOf("\""));
                String hdrDecoded = new String(Base64Utilities.decode(protectedHeaders));
                System.out.println("[" + tipo + " - " + extTipo + "] " + options.getSerialization().name() + " Encrypt (deflate:" + options.isDeflate() + ") protected base64 decoded: " + hdrDecoded);
                if (checkHeaders == null || checkHeaders.isEmpty()) break block12;
                for (String hdr : checkHeaders) {
                    System.out.println("[" + tipo + " - " + extTipo + "] " + options.getSerialization().name() + " Verifico presenza '" + hdr + "'");
                    String hdrName = "\"" + hdr + "\":";
                    if (hdrDecoded.contains(hdrName)) continue;
                    throw new Exception("'" + hdr + "' not found in headers");
                }
                break block12;
            }
            if (!encryption.contains(".")) {
                throw new Exception("Expected format with '.' separator");
            }
            String[] tmp = encryption.split("\\.");
            if (tmp == null) {
                throw new Exception("Expected format with '.' separator");
            }
            int length = 5;
            if (tmp.length != length) {
                throw new Exception("Expected format with 5 base64 info ('.' separator");
            }
            for (int i = 0; i < tmp.length; ++i) {
                String part = tmp[i];
                try {
                    Base64Utilities.decode(part);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Position '" + i + "' uncorrect base64 encoded:" + e.getMessage(), e);
                }
            }
            String hdrDecoded = new String(Base64Utilities.decode(encryption.split("\\.")[0]));
            System.out.println("[" + tipo + " - " + extTipo + "] " + options.getSerialization().name() + " Encrypt (deflate:" + options.isDeflate() + ") HDR base64 decoded: " + hdrDecoded);
            if (checkHeaders != null && !checkHeaders.isEmpty()) {
                for (String hdr : checkHeaders) {
                    System.out.println("[" + tipo + " - " + extTipo + "] " + options.getSerialization().name() + " Verifico presenza '" + hdr + "'");
                    String hdrName = "\"" + hdr + "\":";
                    if (hdrDecoded.contains(hdrName)) continue;
                    throw new Exception("'" + hdr + "' not found in headers");
                }
            }
        }
    }

    private static void decrypt(TipoTest tipo, String extTipo, boolean useHdrsForValidation, JsonDecrypt decrypt, String encryption, String jsonInput, JWEOptions options) throws Exception {
        decrypt.decrypt(encryption);
        System.out.println("[" + tipo + " - " + extTipo + "] " + options.getSerialization().name() + " Decrypt (use-hdrs: " + useHdrsForValidation + " deflate:" + options.isDeflate() + ") payload: " + decrypt.getDecodedPayload());
        if (!decrypt.getDecodedPayload().equals(jsonInput)) {
            throw new Exception("Found different payload");
        }
        String encryptionCorrottaParteBody = null;
        encryptionCorrottaParteBody = JOSESerialization.JSON.equals((Object)options.getSerialization()) ? encryption.replace("ciphertext\":\"", "ciphertext\":\"CORROTTO") : encryption.replaceFirst("\\.", ".CORROTTO");
        try {
            decrypt.decrypt(encryptionCorrottaParteBody);
            throw new Exception("Expected validation error (bodyCorrupted: " + encryptionCorrottaParteBody + ")");
        }
        catch (Exception e) {
            System.out.println("[ok] Expected error: " + e.getMessage());
            return;
        }
    }

    private static List<String> getHeaders(Properties signatureProps, JwtHeaders headers) {
        List<String> listHDR;
        ArrayList<String> list = new ArrayList<String>();
        if (signatureProps != null) {
            String kid = signatureProps.getProperty("rs.security.encryption.include.key.id");
            if ("true".equals(kid)) {
                list.add("kid");
            }
            String tipo = signatureProps.getProperty("rs.security.keystore.type");
            if (KeystoreType.JWK_SET.getNome().equals(tipo)) {
                String jwk = signatureProps.getProperty("rs.security.encryption.include.public.key");
                if ("true".equals(jwk)) {
                    list.add("jwk");
                }
            } else {
                String x5t_256;
                String x5t;
                String x5c = signatureProps.getProperty("rs.security.encryption.include.cert");
                if ("true".equals(x5c)) {
                    list.add("x5c");
                }
                if ("true".equals(x5t = signatureProps.getProperty("rs.security.encryption.include.cert.sha1"))) {
                    list.add("x5t");
                }
                if ("true".equals(x5t_256 = signatureProps.getProperty("rs.security.encryption.include.cert.sha256"))) {
                    list.add("x5t#S256");
                }
            }
        }
        if (headers != null && (listHDR = headers.headers()) != null && !listHDR.isEmpty()) {
            list.addAll(listHDR);
        }
        return list;
    }

    public static enum TipoTest {
        JAVA_ENCRYPT_JKS,
        JAVA_ENCRYPT_PKCS12,
        JAVA_ENCRYPT_PKCS11,
        XML_ENCRYPT_JKS,
        XML_ENCRYPT_PKCS12,
        XML_ENCRYPT_PKCS11,
        JSON_ENCRYPT_PROPERTIES_JKS,
        JSON_ENCRYPT_PROPERTIES_PKCS12,
        JSON_ENCRYPT_PROPERTIES_PKCS11,
        JSON_ENCRYPT_PROPERTIES_JCEKS,
        JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET,
        JSON_ENCRYPT_PROPERTIES_JWK,
        JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC,
        JSON_ENCRYPT_PROPERTIES_CRL,
        JSON_ENCRYPT_PROPERTIES_OCSP,
        JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_JCEKS_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_PKCS11_SECRET_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_JWK_SYMMETRIC_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM,
        JSON_ENCRYPT_PROPERTIES_JKS_HEADER_CUSTOM_KID_ONLY,
        JSON_ENCRYPT_PROPERTIES_PKCS12_HEADER_CUSTOM_KID_ONLY,
        JSON_ENCRYPT_PROPERTIES_PKCS11_HEADER_CUSTOM_KID_ONLY,
        JSON_ENCRYPT_PROPERTIES_JWK_HEADER_CUSTOM_KID_ONLY,
        JSON_ENCRYPT_PROPERTIES_CRL_HEADER_CUSTOM_KID_ONLY,
        JSON_ENCRYPT_PROPERTIES_OCSP_HEADER_CUSTOM_KID_ONLY,
        JSON_ENCRYPT_JKS_KEYSTORE,
        JSON_ENCRYPT_JKS_KEYSTORE_HEADER_CUSTOM,
        JSON_ENCRYPT_PKCS12_KEYSTORE,
        JSON_ENCRYPT_PKCS12_KEYSTORE_HEADER_CUSTOM,
        JSON_ENCRYPT_PKCS11_KEYSTORE,
        JSON_ENCRYPT_PKCS11_KEYSTORE_HEADER_CUSTOM,
        JSON_ENCRYPT_CRL_KEYSTORE,
        JSON_ENCRYPT_CRL_KEYSTORE_HEADER_CUSTOM,
        JSON_ENCRYPT_OCSP_KEYSTORE,
        JSON_ENCRYPT_OCSP_KEYSTORE_HEADER_CUSTOM,
        JSON_ENCRYPT_JKS_KEYSTORE_JCE,
        JSON_ENCRYPT_JKS_KEYSTORE_JCE_HEADER_CUSTOM,
        JSON_ENCRYPT_PKCS12_KEYSTORE_JCE,
        JSON_ENCRYPT_PKCS12_KEYSTORE_JCE_HEADER_CUSTOM,
        JSON_ENCRYPT_PKCS11_KEYSTORE_JCE,
        JSON_ENCRYPT_PKCS11_KEYSTORE_JCE_HEADER_CUSTOM,
        JSON_ENCRYPT_JWK_KEYS,
        JSON_ENCRYPT_JWK_KEYS_HEADER_CUSTOM,
        JSON_ENCRYPT_JWK_KEY,
        JSON_ENCRYPT_JWK_KEY_HEADER_CUSTOM,
        JSON_ENCRYPT_JWK_SYMMETRIC_KEYS,
        JSON_ENCRYPT_JWK_SYMMETRIC_KEYS_HEADER_CUSTOM,
        JSON_ENCRYPT_JWK_SYMMETRIC_KEY,
        JSON_ENCRYPT_JWK_SYMMETRIC_KEY_HEADER_CUSTOM;

    }
}

