/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;

public class PKCS7Signature {
    public static final String DEFAULT_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private PrivateKey privateKey;
    private Certificate certificate;
    private Provider provider;

    public PKCS7Signature(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        boolean useKeystoreProvider = false;
        if (keystore != null && KeystoreType.PKCS11.getNome().equalsIgnoreCase(keystore.getKeystoreType())) {
            useKeystoreProvider = true;
        }
        this.init(keystore, alias, passwordPrivateKey, useKeystoreProvider);
    }

    public PKCS7Signature(KeyStore keystore, String alias, String passwordPrivateKey, boolean useKeystoreProvider) throws UtilsException {
        this.init(keystore, alias, passwordPrivateKey, useKeystoreProvider);
    }

    public PKCS7Signature(KeyStore keystore, String alias, String passwordPrivateKey, boolean useBouncyCastle, boolean addBouncyCastleProvider) throws UtilsException {
        this(keystore, alias, passwordPrivateKey);
        if (useBouncyCastle) {
            if (addBouncyCastleProvider) {
                this.provider = Security.getProvider("BC");
                if (this.provider == null) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                    this.provider = Security.getProvider("BC");
                }
            } else {
                this.provider = Security.getProvider("BC");
            }
        }
    }

    private void init(KeyStore keystore, String alias, String passwordPrivateKey, boolean useKeystoreProvider) throws UtilsException {
        if (keystore == null) {
            throw new UtilsException("Keystore undefined");
        }
        this.privateKey = keystore.getPrivateKey(alias, passwordPrivateKey);
        this.certificate = keystore.getCertificate(alias);
        if (useKeystoreProvider) {
            this.provider = keystore.getKeystoreProvider();
        }
    }

    public byte[] sign(String data, String charsetName, String algorithm) throws UtilsException {
        try {
            return this.sign(data.getBytes(charsetName), algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] sign(byte[] data, String algorithm) throws UtilsException {
        try {
            if (algorithm == null) {
                algorithm = DEFAULT_SIGNATURE_METHOD;
            }
            ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
            X509CertificateHolder cert = new X509CertificateHolder(this.certificate.getEncoded());
            certList.add(cert);
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            JcaContentSignerBuilder cs = new JcaContentSignerBuilder(algorithm);
            if (this.provider != null) {
                cs.setProvider(this.provider);
            }
            ContentSigner sha1Signer = cs.build(this.privateKey);
            JcaDigestCalculatorProviderBuilder builder = new JcaDigestCalculatorProviderBuilder();
            if (this.provider != null) {
                builder.setProvider(this.provider);
            }
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(builder.build()).build(sha1Signer, cert));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, true);
            return sigData.getEncoded();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

