/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.random;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.random.SecureRandomAlgorithm;

public class RandomGenerator {
    private boolean useSecureRandom = false;
    private String algorithmSecureRandom = null;
    private static Map<String, SecureRandom> mapAlgoSecureRandom = new HashMap<String, SecureRandom>();
    private static SecureRandom secureRandomDefault = null;

    public boolean isUseSecureRandom() {
        return this.useSecureRandom;
    }

    public void setUseSecureRandom(boolean useSecureRandom) {
        this.useSecureRandom = useSecureRandom;
    }

    public String getAlgorithmSecureRandom() {
        return this.algorithmSecureRandom;
    }

    public void setAlgorithmSecureRandom(String algorithmSecureRandom) {
        this.algorithmSecureRandom = algorithmSecureRandom;
    }

    public static RandomGenerator getDefaultInstance() {
        return new RandomGenerator(true);
    }

    public RandomGenerator() {
        this.initEngine(false, null);
    }

    public RandomGenerator(boolean useSecureRandom) {
        this.initEngine(useSecureRandom, null);
    }

    public RandomGenerator(boolean useSecureRandom, SecureRandomAlgorithm algo) {
        this.initEngine(useSecureRandom, algo.getValue());
    }

    public RandomGenerator(boolean useSecureRandom, String algorithm) {
        this.initEngine(useSecureRandom, algorithm);
    }

    private void initEngine(boolean useSecureRandom, String algorithm) {
        this.useSecureRandom = useSecureRandom;
        this.algorithmSecureRandom = algorithm;
    }

    public String nextRandom(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt(this.nextInt("./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".length())));
        }
        return sb.toString();
    }

    public String nextRandomInt(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(this.nextInt(10));
        }
        return sb.toString();
    }

    public byte[] nextRandomBytes(int length) {
        byte[] arrByte = new byte[length];
        this.nextRandomBytes(arrByte);
        return arrByte;
    }

    public void nextRandomBytes(byte[] arrByte) {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            sr.nextBytes(arrByte);
        } else {
            Random rd = (Random)this.getRandomEngine();
            rd.nextBytes(arrByte);
        }
    }

    public boolean nextBoolean() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextBoolean();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextBoolean();
    }

    public int nextInt() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextInt();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextInt();
    }

    public int nextInt(int bound) {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextInt(bound);
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextInt(bound);
    }

    public long nextLong() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextLong();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextLong();
    }

    public double nextDouble() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextDouble();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextDouble();
    }

    public float nextFloat() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextFloat();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextFloat();
    }

    public double nextGaussian() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.nextGaussian();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.nextGaussian();
    }

    public String getAlgorithm() {
        if (this.useSecureRandom) {
            SecureRandom sr = (SecureRandom)this.getRandomEngine();
            return sr.getAlgorithm();
        }
        Random rd = (Random)this.getRandomEngine();
        return rd.getClass().getName();
    }

    public Object getRandomEngine() {
        if (this.useSecureRandom) {
            SecureRandom sr = null;
            sr = this.algorithmSecureRandom != null ? RandomGenerator.getSecureRandom(this.algorithmSecureRandom) : RandomGenerator.getSecureRandomDefault();
            return sr;
        }
        return RandomGenerator.getSecureRandomDefault();
    }

    private static synchronized void initSecureRandom(String algorithmSecureRandom) {
        if (!mapAlgoSecureRandom.containsKey(algorithmSecureRandom)) {
            try {
                SecureRandom sr = SecureRandom.getInstance(algorithmSecureRandom);
                mapAlgoSecureRandom.put(algorithmSecureRandom, sr);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), e);
            }
        }
    }

    private static SecureRandom getSecureRandom(String algorithmSecureRandom) {
        if (!mapAlgoSecureRandom.containsKey(algorithmSecureRandom)) {
            RandomGenerator.initSecureRandom(algorithmSecureRandom);
        }
        return mapAlgoSecureRandom.get(algorithmSecureRandom);
    }

    private static synchronized void initSecureRandomDefault() {
        if (secureRandomDefault == null) {
            secureRandomDefault = new SecureRandom();
        }
    }

    private static SecureRandom getSecureRandomDefault() {
        if (secureRandomDefault == null) {
            RandomGenerator.initSecureRandomDefault();
        }
        return secureRandomDefault;
    }
}

