/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.slf4j.Logger;

public class PropertiesUtilities {
    private static String EMPTY_COMMENT_VALUE = " ";
    private static String KEY_COMMENT_UNIQUE = "#C_ID#_";

    public static CollectionProperties searchLocalImplementation(String OPENSPCOOP2_LOCAL_HOME, Logger log, String variabile, String path, String confDirectory) {
        return PropertiesUtilities.searchLocalImplementation(OPENSPCOOP2_LOCAL_HOME, log, variabile, path, confDirectory, true);
    }

    public static CollectionProperties searchLocalImplementation(String OPENSPCOOP2_LOCAL_HOME, Logger log, String variabile, String path, String confDirectory, boolean readCallsNotSynchronized) {
        Properties p6;
        Properties p5;
        Properties p4;
        Properties p3;
        Properties p2;
        CollectionProperties cp = new CollectionProperties();
        String envP = System.getenv("GOVWAY_FORCE_CONFIG_FILE");
        if (envP != null && "true".equalsIgnoreCase(envP)) {
            cp.setForceConfigDir(true);
        } else {
            String javaP = System.getProperty("GOVWAY_FORCE_CONFIG_FILE");
            if (javaP != null && "true".equalsIgnoreCase(javaP)) {
                cp.setForceConfigDir(true);
            }
        }
        Properties p1 = PropertiesUtilities.examineStep1(log, variabile);
        if (p1 != null) {
            cp.setSystemVariable(new PropertiesReader(p1, readCallsNotSynchronized));
        }
        if ((p2 = PropertiesUtilities.examineStep2(log, variabile)) != null) {
            cp.setJavaVariable(new PropertiesReader(p2, readCallsNotSynchronized));
        }
        if ((p3 = PropertiesUtilities.examineStep3(OPENSPCOOP2_LOCAL_HOME, log, path)) != null) {
            cp.setSystemOpenSPCoopHome(new PropertiesReader(p3, readCallsNotSynchronized));
        }
        if ((p4 = PropertiesUtilities.examineStep4(OPENSPCOOP2_LOCAL_HOME, log, path)) != null) {
            cp.setJavaOpenSPCoopHome(new PropertiesReader(p4, readCallsNotSynchronized));
        }
        if ((p5 = PropertiesUtilities.examineStep5(log, path)) != null) {
            cp.setClasspath(new PropertiesReader(p5, readCallsNotSynchronized));
        }
        File fConfDirectory = null;
        if (confDirectory != null) {
            fConfDirectory = new File(confDirectory);
        }
        if (fConfDirectory != null && fConfDirectory.exists() && fConfDirectory.isDirectory() && (p6 = PropertiesUtilities.examineStep6(log, path, fConfDirectory)) != null) {
            cp.setConfigDir(new PropertiesReader(p6, readCallsNotSynchronized));
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties examineStep1(Logger log, String variabile) {
        String file = System.getenv(variabile);
        String subject = "Variabile di sistema " + variabile;
        if (file != null) {
            File ffile = new File(file);
            if (!ffile.exists()) {
                log.error("[" + subject + "] File non esistente: " + ffile.getAbsolutePath());
                return null;
            }
            if (!ffile.canRead()) {
                log.error("[" + subject + "] File non accessibile: " + ffile.getAbsolutePath());
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(ffile);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties examineStep2(Logger log, String variabile) {
        String file = System.getProperty(variabile);
        String subject = "Proprieta' di sistema " + variabile;
        if (file != null) {
            File ffile = new File(file);
            if (!ffile.exists()) {
                log.error("[" + subject + "] File non esistente: " + ffile.getAbsolutePath());
                return null;
            }
            if (!ffile.canRead()) {
                log.error("[" + subject + "] File non accessibile: " + ffile.getAbsolutePath());
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(ffile);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static Properties examineStep3(String OPENSPCOOP2_LOCAL_HOME, Logger log, String path) {
        String dir = System.getenv(OPENSPCOOP2_LOCAL_HOME);
        String subject = "Variabile di sistema " + OPENSPCOOP2_LOCAL_HOME;
        if (dir != null) {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                log.error("[" + subject + "] Directory non esistente: " + fDir.getAbsolutePath());
                return null;
            }
            if (!fDir.canRead()) {
                log.error("[" + subject + "] Directory non accessibile: " + fDir.getAbsolutePath());
                return null;
            }
            return PropertiesUtilities.getPropertiesReader(log, fDir.getAbsolutePath() + File.separatorChar + path, subject);
        }
        return null;
    }

    private static Properties examineStep4(String OPENSPCOOP2_LOCAL_HOME, Logger log, String path) {
        String dir = System.getProperty(OPENSPCOOP2_LOCAL_HOME);
        String subject = "Proprieta' di sistema " + OPENSPCOOP2_LOCAL_HOME;
        if (dir != null) {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                log.error("[" + subject + "] Directory non esistente: " + fDir.getAbsolutePath());
                return null;
            }
            if (!fDir.canRead()) {
                log.error("[" + subject + "] Directory non accessibile: " + fDir.getAbsolutePath());
                return null;
            }
            return PropertiesUtilities.getPropertiesReader(log, fDir.getAbsolutePath() + File.separatorChar + path, subject);
        }
        return null;
    }

    private static Properties examineStep5(Logger log, String path) {
        return PropertiesUtilities.getPropertiesReader(log, PropertiesUtilities.class.getResourceAsStream("/" + path), "CLASSPATH: " + path);
    }

    private static Properties examineStep6(Logger log, String path, File fConfDirectory) {
        File f = new File(fConfDirectory, path);
        if (f.exists()) {
            return PropertiesUtilities.getPropertiesReader(log, f.getAbsolutePath(), "CONFIG_DIR_OPENSPCOOP/" + path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesReader(Logger log, String path, String subject) {
        if (path != null) {
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            if (!f.canRead()) {
                log.error("[" + subject + "] file di properties non accessibile: " + f.getAbsolutePath());
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesReader(Logger log, InputStream is, String subject) {
        if (is != null) {
            Properties propertiesReader = null;
            try {
                propertiesReader = new Properties();
                propertiesReader.load(is);
            }
            catch (IOException e) {
                propertiesReader = null;
                log.error("[" + subject + "] file di properties non utilizzabile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
            if (propertiesReader != null) {
                return propertiesReader;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties convertTextToProperties(String text) {
        Properties properties = new Properties();
        try (Scanner scanner = new Scanner(text);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.trim().equals("") || (line = line.trim()) != null && line.startsWith("#") || line == null || !line.contains("=") || line.startsWith("=")) continue;
                String key = line.split("=")[0];
                key = key.trim();
                int valueIndex = line.indexOf("=");
                String value = "";
                if (valueIndex < line.length()) {
                    value = line.substring(valueIndex + 1);
                    value = value.trim();
                }
                properties.put(key, value);
            }
        }
        return properties;
    }

    private static String getKeyComment(int index) {
        return KEY_COMMENT_UNIQUE.replace("ID", "" + index);
    }

    private static String removeKeyComment(String keyComment, int index) {
        String prefix = KEY_COMMENT_UNIQUE.replace("ID", "" + index);
        return keyComment.replace(prefix, "");
    }

    public static SortedMap<String> convertTextToSortedMap(String text) throws UtilsException {
        return PropertiesUtilities.convertTextToSortedMap(text, false);
    }

    public static SortedMap<String> convertTextToSortedMap(String text, boolean addCommentAsEntry) throws UtilsException {
        return PropertiesUtilities._convertTextToSortedMap(text, addCommentAsEntry, false);
    }

    public static SortedMap<List<String>> convertTextToSortedListMap(String text) throws UtilsException {
        return PropertiesUtilities.convertTextToSortedListMap(text, false);
    }

    public static SortedMap<List<String>> convertTextToSortedListMap(String text, boolean addCommentAsEntry) throws UtilsException {
        return PropertiesUtilities._convertTextToSortedMap(text, addCommentAsEntry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SortedMap<?> _convertTextToSortedMap(String text, boolean addCommentAsEntry, boolean listEnabled) throws UtilsException {
        Scanner scanner = new Scanner(text);
        SortedMap<String> propertiesString = null;
        SortedMap propertiesList = null;
        if (listEnabled) {
            propertiesList = new SortedMap();
        } else {
            propertiesString = new SortedMap<String>();
        }
        try {
            int index = 0;
            while (scanner.hasNextLine()) {
                Object key;
                String line = scanner.nextLine();
                if (line == null || line.trim().equals("")) continue;
                if ((line = line.trim()).startsWith("#")) {
                    if (!addCommentAsEntry) continue;
                    key = PropertiesUtilities.getKeyComment(index) + line;
                    if (listEnabled) {
                        ArrayList<String> l = new ArrayList<String>();
                        l.add(EMPTY_COMMENT_VALUE);
                        propertiesList.add((String)key, l);
                    } else {
                        propertiesString.add((String)key, EMPTY_COMMENT_VALUE);
                    }
                    ++index;
                    continue;
                }
                if (!line.contains("=")) continue;
                key = line.split("=")[0];
                key = ((String)key).trim();
                int valueIndex = line.indexOf("=");
                String value = "";
                if (valueIndex < line.length()) {
                    value = line.substring(valueIndex + 1);
                    value = value.trim();
                }
                if (listEnabled) {
                    ArrayList<String> l = (ArrayList<String>)propertiesList.get((String)key);
                    if (l == null) {
                        l = new ArrayList<String>();
                        propertiesList.add((String)key, l);
                    }
                    l.add(value);
                    continue;
                }
                propertiesString.add((String)key, value);
            }
        }
        finally {
            scanner.close();
        }
        return listEnabled ? propertiesList : propertiesString;
    }

    public static String convertSortedMapToText(SortedMap<String> map) throws UtilsException {
        return PropertiesUtilities.convertSortedMapToText(map, false);
    }

    public static String convertSortedMapToText(SortedMap<String> map, boolean commentAsEntry) throws UtilsException {
        return PropertiesUtilities._convertSortedMapToText(map, commentAsEntry, false);
    }

    public static String convertSorteListdMapToText(SortedMap<List<String>> map) throws UtilsException {
        return PropertiesUtilities.convertSortedListMapToText(map, false);
    }

    public static String convertSortedListMapToText(SortedMap<List<String>> map, boolean commentAsEntry) throws UtilsException {
        return PropertiesUtilities._convertSortedMapToText(map, commentAsEntry, true);
    }

    private static String _convertSortedMapToText(SortedMap<?> map, boolean commentAsEntry, boolean listEnabled) throws UtilsException {
        StringBuilder sb = new StringBuilder();
        if (map != null && !map.isEmpty()) {
            int index = 0;
            for (String key : map.keys()) {
                if (key == null) continue;
                if (key.startsWith("#") && commentAsEntry) {
                    String keyComment;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (key.startsWith(keyComment = PropertiesUtilities.getKeyComment(index))) {
                        String line = PropertiesUtilities.removeKeyComment(key, index);
                        sb.append(line);
                        ++index;
                        continue;
                    }
                    sb.append(key);
                    continue;
                }
                if (listEnabled) {
                    List values = (List)map.get(key);
                    if (values == null || values.isEmpty()) continue;
                    for (String value : values) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(key).append("=").append(value);
                    }
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                String value = (String)map.get(key);
                sb.append(key).append("=").append(value);
            }
        }
        return sb.toString();
    }
}

