/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator.test;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.JsonValidatorAPI;
import org.openspcoop2.utils.openapi.validator.OpenAPILibrary;
import org.openspcoop2.utils.openapi.validator.OpenapiApiValidatorConfig;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.entity.HttpBaseEntity;
import org.openspcoop2.utils.rest.entity.TextHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.TextHttpResponseEntity;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class CoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testValidation(URI uri, String baseUrl, String testName, ApiFormats format, OpenAPILibrary openAPILibrary, boolean mergeSpec, ApiSchema ... apiSchemas) throws Exception {
        try {
            boolean logSystemOutError = true;
            logSystemOutError = !OpenAPILibrary.json_schema.equals(openAPILibrary);
            boolean testAdditionalProperties = !ApiFormats.SWAGGER_2.equals(format);
            boolean addParameterTipizzati = !ApiFormats.SWAGGER_2.equals(format);
            boolean bodyInDelete = ApiFormats.SWAGGER_2.equals(format);
            IApiReader apiReader = ApiFactory.newApiReader(format);
            apiReader.init(LoggerWrapperFactory.getLogger(CoreTest.class), new File(uri), new ApiReaderConfig(), apiSchemas);
            Api api = apiReader.read();
            IApiValidator apiValidator = ApiFactory.newApiValidator(format);
            OpenapiApiValidatorConfig config = new OpenapiApiValidatorConfig();
            config.setJsonValidatorAPI(JsonValidatorAPI.ApiName.NETWORK_NT);
            config.setEmitLogError(logSystemOutError);
            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                config.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
                config.getOpenApiValidatorConfig().setOpenApiLibrary(openAPILibrary);
                config.getOpenApiValidatorConfig().setMergeAPISpec(mergeSpec);
            }
            apiValidator.init(LoggerWrapperFactory.getLogger(CoreTest.class), api, config);
            try {
                System.out.println("[" + testName + "] Test #1 (Richiesta GET con parametro path)");
                String testUrl1 = baseUrl + "/pets/2";
                TextHttpRequestEntity httpEntity = new TextHttpRequestEntity();
                httpEntity.setMethod(HttpRequestMethod.GET);
                httpEntity.setUrl(testUrl1);
                HashMap<String, List<String>> parametersTrasporto = new HashMap<String, List<String>>();
                ArrayList<String> headersValues = new ArrayList<String>();
                headersValues.add("aaa");
                parametersTrasporto.put("api_key", headersValues);
                httpEntity.setHeaders(parametersTrasporto);
                apiValidator.validate(httpEntity);
                System.out.println("[" + testName + "] Test #1 completato\n\n");
                System.out.println("[" + testName + "] Test #2 (Richiesta GET senza parametri query ove richiesti)");
                String testUrl2 = baseUrl + "/pets/findByStatus";
                TextHttpRequestEntity httpEntity2 = new TextHttpRequestEntity();
                httpEntity2.setMethod(HttpRequestMethod.GET);
                httpEntity2.setUrl(testUrl2);
                try {
                    apiValidator.validate(httpEntity2);
                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                }
                catch (ValidatorException e) {
                    System.out.println("[" + testName + "] Errore trovato: " + e.getMessage());
                    System.out.println("[" + testName + "] Test #2 completato\n\n");
                    System.out.println("[" + testName + "] Test #3 (Richiesta GET con parametri query)");
                    HashMap<String, List<String>> parametersQuery = new HashMap<String, List<String>>();
                    TextHttpRequestEntity httpEntity3 = new TextHttpRequestEntity();
                    TransportUtils.setParameter(parametersQuery, "status", "available");
                    if (addParameterTipizzati) {
                        TransportUtils.setParameter(parametersQuery, "profiloRefInLineByStatus", "APIGateway");
                        TransportUtils.setParameter(parametersQuery, "soggettoRefInLineByStatus", "PROVA");
                        TransportUtils.setParameter(parametersQuery, "numeroLimitatoRefInLineByStatus", "130");
                        TransportUtils.setParameter(parametersQuery, "profiloInLineByStatus", "SPCoop");
                        TransportUtils.setParameter(parametersQuery, "soggettoInLineByStatus", "PROVA2");
                        TransportUtils.setParameter(parametersQuery, "numeroLimitatoInLineByStatus", "150");
                        TransportUtils.setParameter(parametersQuery, "profiloRef", "FatturaPA");
                        TransportUtils.setParameter(parametersQuery, "soggettoRef", "PROVA3");
                        TransportUtils.setParameter(parametersQuery, "esempioNumericoRef", "200");
                        TransportUtils.setParameter(parametersQuery, "profilo", "eDelivery");
                        TransportUtils.setParameter(parametersQuery, "soggetto", "PROVA4");
                        TransportUtils.setParameter(parametersQuery, "esempioNumerico", "500");
                    }
                    httpEntity3.setParameters(parametersQuery);
                    httpEntity3.setMethod(HttpRequestMethod.GET);
                    httpEntity3.setUrl(testUrl2);
                    apiValidator.validate(httpEntity3);
                    System.out.println("[" + testName + "] Test #3 completato\n\n");
                    if (addParameterTipizzati) {
                        System.out.println("[" + testName + "] Test #3-a (Richiesta GET con parametri query errati)");
                        httpEntity3.getParameters().remove("profiloRefInLineByStatus");
                        TransportUtils.setParameter(parametersQuery, "profiloRefInLineByStatus", "APIGatewayERRATO");
                        try {
                            apiValidator.validate(httpEntity3);
                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                        }
                        catch (ValidatorException e2) {
                            String msgErroreAtteso;
                            System.out.println("[" + testName + "] Errore trovato: " + e2.getMessage());
                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                String string = msgErroreAtteso = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "profiloRefInLineByStatus: Value 'APIGatewayERRATO' is not defined in the schema. (code: 1006)" : "Validation failed.\n[ERROR][REQUEST][GET /pets/findByStatus @query.profiloRefInLineByStatus] Instance value (\"APIGatewayERRATO\") not found in enum (possible values: [\"APIGateway\",\"SPCoop\",\"FatturaPA\",\"eDelivery\"])";
                                if (!e2.getMessage().contains(msgErroreAtteso)) {
                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "', trovato: " + e2.getMessage());
                                }
                            } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                msgErroreAtteso = "Invalid value 'APIGatewayERRATO' in query parameter 'profiloRefInLineByStatus' (expected type 'string'): Uncorrect enum value 'APIGatewayERRATO', expected: 'APIGateway,SPCoop,FatturaPA,eDelivery'";
                                if (!e2.getMessage().contains(msgErroreAtteso)) {
                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "', trovato: " + e2.getMessage());
                                }
                            }
                            System.out.println("[" + testName + "] Test #3-a (Richiesta GET con parametri query errati) completato\n\n");
                            httpEntity3.getParameters().remove("profiloRefInLineByStatus");
                            TransportUtils.setParameter(httpEntity3.getParameters(), "profiloRefInLineByStatus", "APIGateway");
                            System.out.println("[" + testName + "] Test #3-b (Richiesta GET con parametri query errati)");
                            httpEntity3.getParameters().remove("soggettoInLineByStatus");
                            TransportUtils.setParameter(parametersQuery, "soggettoInLineByStatus", "PROVA_PROVA");
                            try {
                                apiValidator.validate(httpEntity3);
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            catch (ValidatorException e3) {
                                System.out.println("[" + testName + "] Errore trovato: " + e3.getMessage());
                                if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                    String string = msgErroreAtteso = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "soggettoInLineByStatus: 'PROVA_PROVA' does not respect pattern '^[0-9A-Za-z]+$'. (code: 1025)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.soggettoInLineByStatus] ECMA 262 regex \"^[0-9A-Za-z]+$\" does not match input string \"PROVA_PROVA\"";
                                    if (!e3.getMessage().contains(msgErroreAtteso)) {
                                        throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "': " + e3.getMessage());
                                    }
                                } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                    msgErroreAtteso = "Invalid value 'PROVA_PROVA' in query parameter 'soggettoInLineByStatus' (expected type 'string'): Pattern match failed ('^[0-9A-Za-z]+$')";
                                    if (!e3.getMessage().contains(msgErroreAtteso)) {
                                        throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "': " + e3.getMessage());
                                    }
                                }
                                System.out.println("[" + testName + "] Test #3-b (Richiesta GET con parametri query errati) completato\n\n");
                                httpEntity3.getParameters().remove("soggettoInLineByStatus");
                                TransportUtils.setParameter(httpEntity3.getParameters(), "soggettoInLineByStatus", "PROVA");
                                System.out.println("[" + testName + "] Test #3-c (Richiesta GET con parametri query errati)");
                                httpEntity3.getParameters().remove("soggettoInLineByStatus");
                                TransportUtils.setParameter(parametersQuery, "soggettoInLineByStatus", "P");
                                try {
                                    apiValidator.validate(httpEntity3);
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                catch (ValidatorException e4) {
                                    System.out.println("[" + testName + "] Errore trovato: " + e4.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String string = msgErroreAtteso = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "soggettoInLineByStatus: Min length is '2', found '1'. (code: 1017)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.soggettoInLineByStatus] String \"P\" is too short (length: 1, required minimum: 2)";
                                        if (!e4.getMessage().contains(msgErroreAtteso)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "':" + e4.getMessage());
                                        }
                                    } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                        msgErroreAtteso = "Invalid value 'P' in query parameter 'soggettoInLineByStatus' (expected type 'string'): Too short, expected min length '2'";
                                        if (!e4.getMessage().contains(msgErroreAtteso)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "':" + e4.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #3-c (Richiesta GET con parametri query errati) completato\n\n");
                                    httpEntity3.getParameters().remove("soggettoInLineByStatus");
                                    TransportUtils.setParameter(httpEntity3.getParameters(), "soggettoInLineByStatus", "PROVA");
                                    System.out.println("[" + testName + "] Test #3-d (Richiesta GET con parametri query errati)");
                                    httpEntity3.getParameters().remove("soggettoRef");
                                    String pLongValue = "P12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
                                    TransportUtils.setParameter(parametersQuery, "soggettoRef", pLongValue);
                                    try {
                                        apiValidator.validate(httpEntity3);
                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                    }
                                    catch (ValidatorException e5) {
                                        Object msgErroreAtteso2;
                                        System.out.println("[" + testName + "] Errore trovato: " + e5.getMessage());
                                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                            Object object = msgErroreAtteso2 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "soggettoRef: Max length is '255', found '291'. (code: 1012)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.soggettoRef] String \"P12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\" is too long (length: 291, maximum allowed: 255)";
                                            if (!e5.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e5.getMessage());
                                            }
                                        } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                            msgErroreAtteso2 = "Invalid value '" + pLongValue + "' in query parameter 'soggettoRef' (expected type 'string'): Too big, expected max length '255'";
                                            if (!e5.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e5.getMessage());
                                            }
                                        }
                                        System.out.println("[" + testName + "] Test #3-d (Richiesta GET con parametri query errati) completato\n\n");
                                        httpEntity3.getParameters().remove("soggettoRef");
                                        TransportUtils.setParameter(httpEntity3.getParameters(), "soggettoRef", "PROVA");
                                        System.out.println("[" + testName + "] Test #3-e (Richiesta GET con parametri query errati)");
                                        httpEntity3.getParameters().remove("esempioNumerico");
                                        TransportUtils.setParameter(parametersQuery, "esempioNumerico", "23");
                                        try {
                                            apiValidator.validate(httpEntity3);
                                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                        }
                                        catch (ValidatorException e6) {
                                            System.out.println("[" + testName + "] Errore trovato: " + e6.getMessage());
                                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                Object object = msgErroreAtteso2 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "Minimum is '100', found '23'. (code: 1015)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.esempioNumerico] Numeric instance is lower than the required minimum (minimum: 100, found: 23)";
                                                if (!e6.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                    throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e6.getMessage());
                                                }
                                            } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                msgErroreAtteso2 = "Invalid value '23' in query parameter 'esempioNumerico' (expected type 'int32'): Value lowest than the minimum '100'";
                                                if (!e6.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                    throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e6.getMessage());
                                                }
                                            }
                                            System.out.println("[" + testName + "] Test #3-e (Richiesta GET con parametri query errati) completato\n\n");
                                            httpEntity3.getParameters().remove("esempioNumerico");
                                            TransportUtils.setParameter(httpEntity3.getParameters(), "esempioNumerico", "500");
                                            System.out.println("[" + testName + "] Test #3-f (Richiesta GET con parametri query errati)");
                                            httpEntity3.getParameters().remove("esempioNumerico");
                                            TransportUtils.setParameter(parametersQuery, "esempioNumerico", "600");
                                            try {
                                                apiValidator.validate(httpEntity3);
                                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                            }
                                            catch (ValidatorException e7) {
                                                System.out.println("[" + testName + "] Errore trovato: " + e7.getMessage());
                                                if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                    Object object = msgErroreAtteso2 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "esempioNumerico: Excluded maximum is '600', found '600'. (code: 1009)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.esempioNumerico] Numeric instance is not strictly lower than the required maximum 600";
                                                    if (!e7.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                        throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e7.getMessage());
                                                    }
                                                } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                    msgErroreAtteso2 = "Invalid value '600' in query parameter 'esempioNumerico' (expected type 'int32'): Value equals to the maximum '600' and exclusive maximum is enabled";
                                                    if (!e7.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                        throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e7.getMessage());
                                                    }
                                                }
                                                System.out.println("[" + testName + "] Test #3-f (Richiesta GET con parametri query errati) completato\n\n");
                                                httpEntity3.getParameters().remove("esempioNumerico");
                                                TransportUtils.setParameter(httpEntity3.getParameters(), "esempioNumerico", "500");
                                                System.out.println("[" + testName + "] Test #3-g (Richiesta GET con parametri query errati)");
                                                httpEntity3.getParameters().remove("esempioNumerico");
                                                TransportUtils.setParameter(parametersQuery, "esempioNumerico", "800");
                                                try {
                                                    apiValidator.validate(httpEntity3);
                                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                }
                                                catch (ValidatorException e8) {
                                                    System.out.println("[" + testName + "] Errore trovato: " + e8.getMessage());
                                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                        Object object = msgErroreAtteso2 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "esempioNumerico: Maximum is '600', found '800'. (code: 1010)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.esempioNumerico] Numeric instance is greater than the required maximum (maximum: 600, found: 800)";
                                                        if (!e8.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                            throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e8.getMessage());
                                                        }
                                                    } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                        msgErroreAtteso2 = "Invalid value '800' in query parameter 'esempioNumerico' (expected type 'int32'): Value higher than the maximum '600'";
                                                        if (!e8.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                            throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e8.getMessage());
                                                        }
                                                    }
                                                    System.out.println("[" + testName + "] Test #3-g (Richiesta GET con parametri query errati) completato\n\n");
                                                    httpEntity3.getParameters().remove("esempioNumerico");
                                                    TransportUtils.setParameter(httpEntity3.getParameters(), "esempioNumerico", "500");
                                                    System.out.println("[" + testName + "] Test #3-h (Richiesta GET con parametri query errati)");
                                                    httpEntity3.getParameters().remove("esempioNumerico");
                                                    TransportUtils.setParameter(parametersQuery, "esempioNumerico", "55GG33");
                                                    try {
                                                        apiValidator.validate(httpEntity3);
                                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                    }
                                                    catch (ValidatorException e9) {
                                                        System.out.println("[" + testName + "] Errore trovato: " + e9.getMessage());
                                                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                            Object object = msgErroreAtteso2 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "esempioNumerico: Value '55GG33' does not match format 'int32'. (code: 1007)" : "[ERROR][REQUEST][GET /pets/findByStatus @query.esempioNumerico] Instance type (string) does not match any allowed primitive type (allowed: [\"integer\"])";
                                                            if (!e9.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                                throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e9.getMessage());
                                                            }
                                                        } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                            msgErroreAtteso2 = "Invalid value '55GG33' in query parameter 'esempioNumerico' (expected type 'int32'): For input string: \"55GG33\"";
                                                            if (!e9.getMessage().contains((CharSequence)msgErroreAtteso2)) {
                                                                throw new Exception("Errore: atteso messaggio di errore '" + (String)msgErroreAtteso2 + "':" + e9.getMessage());
                                                            }
                                                        }
                                                        System.out.println("[" + testName + "] Test #3-h (Richiesta GET con parametri query errati) completato\n\n");
                                                        httpEntity3.getParameters().remove("esempioNumerico");
                                                        TransportUtils.setParameter(httpEntity3.getParameters(), "esempioNumerico", "500");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    System.out.println("[" + testName + "] Test #4 (Richiesta POST con body json corretto)");
                    TextHttpRequestEntity httpEntity4 = new TextHttpRequestEntity();
                    httpEntity4.setMethod(HttpRequestMethod.POST);
                    httpEntity4.setUrl("/pets");
                    httpEntity4.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"]}");
                    CoreTest.setContentType("application/json", httpEntity4);
                    apiValidator.validate(httpEntity4);
                    System.out.println("[" + testName + "] Test #4 completato\n\n");
                    System.out.println("[" + testName + "] Test #4-empty (Richiesta POST senza body json)");
                    TextHttpRequestEntity httpEntity4_empty = new TextHttpRequestEntity();
                    httpEntity4_empty.setMethod(HttpRequestMethod.POST);
                    httpEntity4_empty.setUrl("/pets");
                    CoreTest.setContentType("application/json", httpEntity4_empty);
                    try {
                        apiValidator.validate(httpEntity4_empty);
                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                    }
                    catch (ValidatorException e10) {
                        String msgErroreAtteso;
                        System.out.println("[" + testName + "] Errore trovato: " + e10.getMessage());
                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                            String string = msgErroreAtteso = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "Body is required but none provided. (code: 200)" : "[ERROR][REQUEST][POST /pets @body] A request body is required but none found.";
                            if (!e10.getMessage().contains(msgErroreAtteso)) {
                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "':" + e10.getMessage());
                            }
                        } else {
                            msgErroreAtteso = "Required body undefined";
                            if (!e10.getMessage().equals(msgErroreAtteso)) {
                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso + "':" + e10.getMessage());
                            }
                        }
                        System.out.println("[" + testName + "] Test #4-empty completato\n\n");
                        System.out.println("[" + testName + "] Test #4-contentTypeSconosciuto (Richiesta POST con contentType sconosciuto)");
                        TextHttpRequestEntity httpEntity4_contentTypeSconosciuto = new TextHttpRequestEntity();
                        httpEntity4_contentTypeSconosciuto.setMethod(HttpRequestMethod.POST);
                        httpEntity4_contentTypeSconosciuto.setUrl("/pets");
                        httpEntity4_contentTypeSconosciuto.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"]}");
                        CoreTest.setContentType("application/ERRORE", httpEntity4_contentTypeSconosciuto);
                        try {
                            apiValidator.validate(httpEntity4_contentTypeSconosciuto);
                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                        }
                        catch (ValidatorException e11) {
                            String msgErroreAtteso3;
                            String msgErroreAtteso4;
                            System.out.println("[" + testName + "] Errore trovato: " + e11.getMessage());
                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                String string = msgErroreAtteso4 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "Content type 'application/ERRORE' is not allowed for body content" : "[ERROR][REQUEST][POST /pets] Request Content-Type header '[application/ERRORE]' does not match any allowed types. Must be one of: [application/json";
                                if (!e11.getMessage().contains(msgErroreAtteso4)) {
                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso4 + "':" + e11.getMessage());
                                }
                            } else {
                                msgErroreAtteso4 = "Content-Type 'application/ERRORE' unsupported";
                                if (!e11.getMessage().equals(msgErroreAtteso4)) {
                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso4 + "':" + e11.getMessage());
                                }
                            }
                            System.out.println("[" + testName + "] Test #4-contentTypeSconosciuto completato\n\n");
                            if (testAdditionalProperties) {
                                System.out.println("[" + testName + "] Test #5-additionalProperties (Richiesta POST con body json errato )");
                                TextHttpRequestEntity httpEntity5_additionalProperties = new TextHttpRequestEntity();
                                httpEntity5_additionalProperties.setMethod(HttpRequestMethod.POST);
                                httpEntity5_additionalProperties.setUrl("/pets");
                                httpEntity5_additionalProperties.setContent("{\"name\" : \"aaa\", \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"a\":\"b\"}");
                                CoreTest.setContentType("application/json", httpEntity5_additionalProperties);
                                try {
                                    apiValidator.validate(httpEntity5_additionalProperties);
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                catch (ValidatorException e12) {
                                    System.out.println("[" + testName + "] Errore trovato: " + e12.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String string = msgErroreAtteso3 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "[ERROR][REQUEST][POST /pets @body] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                        if (!e12.getMessage().contains(msgErroreAtteso3)) {
                                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso3 + "':" + e12.getMessage());
                                        }
                                    } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                        msgErroreAtteso3 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                        if (!e12.getMessage().contains(msgErroreAtteso3)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso3 + "':" + e12.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #5-additionalProperties completato\n\n");
                                }
                            }
                            System.out.println("[" + testName + "] Test #5-required (Richiesta POST con body json errato )");
                            TextHttpRequestEntity httpEntity5_required = new TextHttpRequestEntity();
                            httpEntity5_required.setMethod(HttpRequestMethod.POST);
                            httpEntity5_required.setUrl("/pets");
                            httpEntity5_required.setContent("{\"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"]}");
                            CoreTest.setContentType("application/json", httpEntity5_required);
                            try {
                                apiValidator.validate(httpEntity5_required);
                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                            }
                            catch (ValidatorException e13) {
                                String msgErroreAtteso5;
                                System.out.println("[" + testName + "] Errore trovato: " + e13.getMessage());
                                if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                    String string = msgErroreAtteso3 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'name' is required." : "[ERROR][REQUEST][POST /pets @body] Object has missing required properties ([\"name\"])";
                                    if (!e13.getMessage().contains(msgErroreAtteso3)) {
                                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso3 + "':" + e13.getMessage());
                                    }
                                } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                    msgErroreAtteso3 = "$.name: is missing but it is required";
                                    if (!e13.getMessage().contains(msgErroreAtteso3)) {
                                        throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso3 + "':" + e13.getMessage());
                                    }
                                }
                                System.out.println("[" + testName + "] Test #5-required completato\n\n");
                                System.out.println("[" + testName + "] Test #6 (Risposta POST con body json corretto)");
                                TextHttpResponseEntity httpEntity6 = new TextHttpResponseEntity();
                                httpEntity6.setMethod(HttpRequestMethod.POST);
                                httpEntity6.setUrl("/pets");
                                httpEntity6.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1 }");
                                CoreTest.setContentType("application/json", httpEntity6);
                                httpEntity6.setStatus(200);
                                apiValidator.validate(httpEntity6);
                                System.out.println("[" + testName + "] Test #6 completato\n\n");
                                System.out.println("[" + testName + "] Test #6-empty (Risposta POST senza body json)");
                                TextHttpResponseEntity httpEntity6_empty = new TextHttpResponseEntity();
                                httpEntity6_empty.setMethod(HttpRequestMethod.POST);
                                httpEntity6_empty.setUrl("/pets");
                                CoreTest.setContentType("application/json", httpEntity6_empty);
                                httpEntity6_empty.setStatus(200);
                                try {
                                    apiValidator.validate(httpEntity6_empty);
                                }
                                catch (ValidatorException e14) {
                                    String msgErroreAtteso6;
                                    System.out.println("[" + testName + "] Errore trovato: " + e14.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String string = msgErroreAtteso6 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Null value is not allowed. (code: 1021)" : "[ERROR][RESPONSE][] POST on path '/pets' defines a response schema but no response body found.";
                                        if (!e14.getMessage().contains(msgErroreAtteso6)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso6 + "':" + e14.getMessage());
                                        }
                                    } else {
                                        msgErroreAtteso6 = "Required body undefined";
                                        if (!e14.getMessage().equals(msgErroreAtteso6)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso6 + "':" + e14.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #6-empty completato\n\n");
                                }
                                System.out.println("[" + testName + "] Test #6-contentTypeSconosciuto (Risposta POST con body json corretto)");
                                TextHttpResponseEntity httpEntity6_contentTypeSconosciuto = new TextHttpResponseEntity();
                                httpEntity6_contentTypeSconosciuto.setMethod(HttpRequestMethod.POST);
                                httpEntity6_contentTypeSconosciuto.setUrl("/pets");
                                httpEntity6_contentTypeSconosciuto.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1 }");
                                CoreTest.setContentType("application/ERRORE", httpEntity6_contentTypeSconosciuto);
                                httpEntity6_contentTypeSconosciuto.setStatus(200);
                                try {
                                    apiValidator.validate(httpEntity6_contentTypeSconosciuto);
                                }
                                catch (ValidatorException e15) {
                                    String msgErroreAtteso7;
                                    System.out.println("[" + testName + "] Errore trovato: " + e15.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String string = msgErroreAtteso7 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "Content type 'application/ERRORE' is not allowed for body content." : "[ERROR][RESPONSE][] Response Content-Type header 'application/ERRORE' does not match any allowed types. Must be one of: [application";
                                        if (!e15.getMessage().contains(msgErroreAtteso7)) {
                                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso7 + "':" + e15.getMessage());
                                        }
                                    } else {
                                        msgErroreAtteso7 = "Content-Type 'application/ERRORE' (http response status '200') unsupported";
                                        if (!e15.getMessage().equals(msgErroreAtteso7)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso7 + "':" + e15.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #6-empty completato\n\n");
                                }
                                System.out.println("[" + testName + "] Test #6-contentTypeSconosciuto completato\n\n");
                                System.out.println("[" + testName + "] Test #6-contentTypeOkSenzaBody (Risposta POST senza body ma con content_type json corretto)");
                                TextHttpResponseEntity httpEntity6_empty_ok = new TextHttpResponseEntity();
                                httpEntity6_empty_ok.setMethod(HttpRequestMethod.POST);
                                httpEntity6_empty_ok.setUrl("/pets");
                                CoreTest.setContentType("application/json", httpEntity6_empty_ok);
                                httpEntity6_empty_ok.setStatus(405);
                                try {
                                    apiValidator.validate(httpEntity6_empty_ok);
                                }
                                catch (ValidatorException e16) {
                                    String msgErroreAtteso8;
                                    System.out.println("[" + testName + "] Errore trovato: " + e16.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String string = msgErroreAtteso8 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "Content type 'application/json' is not allowed for body content. (code: 203)" : "Content-Type 'application/json' (http response status '405') unsupported";
                                        if (!e16.getMessage().contains(msgErroreAtteso8)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso8 + "':" + e16.getMessage());
                                        }
                                    } else {
                                        msgErroreAtteso8 = "Content-Type 'application/json' (http response status '405') unsupported";
                                        if (!e16.getMessage().equals(msgErroreAtteso8)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso8 + "':" + e16.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #6-contentTypeOkSenzaBody completato\n\n");
                                }
                                System.out.println("[" + testName + "] Test #6 completato\n\n");
                                System.out.println("[" + testName + "] Test #6-error (Risposta POST senza body json corretto)");
                                TextHttpResponseEntity httpEntity6_error = new TextHttpResponseEntity();
                                httpEntity6_error.setMethod(HttpRequestMethod.POST);
                                httpEntity6_error.setUrl("/pets");
                                httpEntity6_error.setContent("{\"code\" : 345,  \"message\": \"esempio di errore\" }");
                                if (ApiFormats.OPEN_API_3.equals(format)) {
                                    CoreTest.setContentType("application/problem+json", httpEntity6_error);
                                } else {
                                    CoreTest.setContentType("application/json", httpEntity6_error);
                                }
                                httpEntity6_error.setStatus(500);
                                apiValidator.validate(httpEntity6_error);
                                System.out.println("[" + testName + "] Test #6-error completato\n\n");
                                System.out.println("[" + testName + "] Test #6-error-empty (Risposta POST senza body json)");
                                TextHttpResponseEntity httpEntity6_error_empty = new TextHttpResponseEntity();
                                httpEntity6_error_empty.setMethod(HttpRequestMethod.POST);
                                httpEntity6_error_empty.setUrl("/pets");
                                CoreTest.setContentType("application/json", httpEntity6_error_empty);
                                httpEntity6_error_empty.setStatus(500);
                                try {
                                    apiValidator.validate(httpEntity6_error_empty);
                                }
                                catch (ValidatorException e17) {
                                    String msgErroreAtteso9;
                                    System.out.println("[" + testName + "] Errore trovato: " + e17.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary)) {
                                        msgErroreAtteso9 = "Content type 'application/json' is not allowed for body content. (code: 203)";
                                        if (!e17.getMessage().contains(msgErroreAtteso9)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso9 + "':" + e17.getMessage());
                                        }
                                    } else if (OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String msgErroreAttesoSwaggerV2 = "[ERROR][RESPONSE][] POST on path '/pets' defines a response schema but no response body found";
                                        msgErroreAtteso5 = "[ERROR][RESPONSE][] Response Content-Type header 'application/json' does not match any allowed types. Must be one of: [application/problem+json].";
                                        if (!e17.getMessage().contains(msgErroreAtteso5) && !e17.getMessage().contains(msgErroreAttesoSwaggerV2)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso5 + "':" + e17.getMessage());
                                        }
                                    } else {
                                        msgErroreAtteso9 = "Required body undefined";
                                        if (!e17.getMessage().equals(msgErroreAtteso9)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso9 + "':" + e17.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #6-error-empty completato\n\n");
                                }
                                if (testAdditionalProperties) {
                                    System.out.println("[" + testName + "] Test #7-additionalProperties (Risposta POST con body json errato)");
                                    TextHttpResponseEntity httpEntity7_additionalProperties = new TextHttpResponseEntity();
                                    httpEntity7_additionalProperties.setMethod(HttpRequestMethod.POST);
                                    httpEntity7_additionalProperties.setUrl("/pets");
                                    httpEntity7_additionalProperties.setContent("{\"name\" : \"aaa\", \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"a\":\"b\", \"id\": 23}");
                                    CoreTest.setContentType("application/json", httpEntity7_additionalProperties);
                                    httpEntity7_additionalProperties.setStatus(200);
                                    try {
                                        apiValidator.validate(httpEntity7_additionalProperties);
                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                    }
                                    catch (ValidatorException e18) {
                                        System.out.println("[" + testName + "] Errore trovato: " + e18.getMessage());
                                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                            String string = msgErroreAtteso5 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "- [ERROR][] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                            if (!e18.getMessage().contains(msgErroreAtteso5)) {
                                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso5 + "':" + e18.getMessage());
                                            }
                                        } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                            msgErroreAtteso5 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                            if (!e18.getMessage().contains(msgErroreAtteso5)) {
                                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso5 + "':" + e18.getMessage());
                                            }
                                        }
                                        System.out.println("[" + testName + "] Test #7-additionalProperties completato\n\n");
                                    }
                                }
                                System.out.println("[" + testName + "] Test #7-required (Risposta POST con body json errato)");
                                TextHttpResponseEntity httpEntity7_required = new TextHttpResponseEntity();
                                httpEntity7_required.setMethod(HttpRequestMethod.POST);
                                httpEntity7_required.setUrl("/pets");
                                httpEntity7_required.setContent("{\"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\": 23}");
                                CoreTest.setContentType("application/json", httpEntity7_required);
                                httpEntity7_required.setStatus(200);
                                try {
                                    apiValidator.validate(httpEntity7_required);
                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                }
                                catch (ValidatorException e19) {
                                    String msgErroreAtteso10;
                                    System.out.println("[" + testName + "] Errore trovato: " + e19.getMessage());
                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                        String string = msgErroreAtteso5 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'name' is required." : "- [ERROR][] Object has missing required properties ([\"name\"])";
                                        if (!e19.getMessage().contains(msgErroreAtteso5)) {
                                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso5 + "':" + e19.getMessage());
                                        }
                                    } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                        msgErroreAtteso5 = "$.name: is missing but it is required";
                                        if (!e19.getMessage().contains(msgErroreAtteso5)) {
                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso5 + "':" + e19.getMessage());
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #7-required completato\n\n");
                                    if (testAdditionalProperties) {
                                        System.out.println("[" + testName + "] Test #7-error-additionalProperties (Risposta POST con body json errato)");
                                        TextHttpResponseEntity httpEntity7_error_additionalProperties = new TextHttpResponseEntity();
                                        httpEntity7_error_additionalProperties.setMethod(HttpRequestMethod.POST);
                                        httpEntity7_error_additionalProperties.setUrl("/pets");
                                        httpEntity7_error_additionalProperties.setContent("{\"code\" : 345, \"message\": \"Esempio di errore\", \"a\":\"b\"}");
                                        CoreTest.setContentType("application/json", httpEntity7_error_additionalProperties);
                                        httpEntity7_error_additionalProperties.setStatus(400);
                                        try {
                                            apiValidator.validate(httpEntity7_error_additionalProperties);
                                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                        }
                                        catch (ValidatorException e20) {
                                            System.out.println("[" + testName + "] Errore trovato: " + e20.getMessage());
                                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                String string = msgErroreAtteso10 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "[ERROR][RESPONSE][] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                if (!e20.getMessage().contains(msgErroreAtteso10)) {
                                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso10 + "':" + e20.getMessage());
                                                }
                                            } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                msgErroreAtteso10 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                                if (!e20.getMessage().contains(msgErroreAtteso10)) {
                                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso10 + "':" + e20.getMessage());
                                                }
                                            }
                                            System.out.println("[" + testName + "] Test #7-error-additionalProperties completato\n\n");
                                        }
                                    }
                                    System.out.println("[" + testName + "] Test #7-error-required (Risposta POST con body json errato)");
                                    TextHttpResponseEntity httpEntity7_error_required = new TextHttpResponseEntity();
                                    httpEntity7_error_required.setMethod(HttpRequestMethod.POST);
                                    httpEntity7_error_required.setUrl("/pets");
                                    httpEntity7_error_required.setContent("{\"message\": \"Esempio di errore\"}");
                                    CoreTest.setContentType("application/json", httpEntity7_error_required);
                                    httpEntity7_error_required.setStatus(400);
                                    try {
                                        apiValidator.validate(httpEntity7_error_required);
                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                    }
                                    catch (ValidatorException e21) {
                                        System.out.println("[" + testName + "] Errore trovato: " + e21.getMessage());
                                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                            String string = msgErroreAtteso10 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'code' is required." : "[ERROR][RESPONSE][] Object has missing required properties ([\"code\"])";
                                            if (!e21.getMessage().contains(msgErroreAtteso10)) {
                                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso10 + "':" + e21.getMessage());
                                            }
                                        } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                            msgErroreAtteso10 = "$.code: is missing but it is required";
                                            if (!e21.getMessage().contains(msgErroreAtteso10)) {
                                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso10 + "':" + e21.getMessage());
                                            }
                                        }
                                        System.out.println("[" + testName + "] Test #7-error-required completato\n\n");
                                        System.out.println("[" + testName + "] Test #9 (Richiesta PUT con body json corretto)");
                                        TextHttpRequestEntity httpEntity9 = new TextHttpRequestEntity();
                                        httpEntity9.setMethod(HttpRequestMethod.PUT);
                                        httpEntity9.setUrl("/pets");
                                        httpEntity9.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"]}");
                                        CoreTest.setContentType("application/json", httpEntity9);
                                        apiValidator.validate(httpEntity9);
                                        System.out.println("[" + testName + "] Test #9 completato\n\n");
                                        System.out.println("[" + testName + "] Test #10-additionalProperties (Richiesta PUT con body json errato)");
                                        TextHttpRequestEntity httpEntity10_additionalProperties = new TextHttpRequestEntity();
                                        httpEntity10_additionalProperties.setMethod(HttpRequestMethod.PUT);
                                        httpEntity10_additionalProperties.setUrl("/pets");
                                        httpEntity10_additionalProperties.setContent("{\"name\" : \"aaa\", \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"a\":\"b\"}");
                                        CoreTest.setContentType("application/json", httpEntity10_additionalProperties);
                                        try {
                                            apiValidator.validate(httpEntity10_additionalProperties);
                                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                        }
                                        catch (ValidatorException e22) {
                                            String msgErroreAtteso11;
                                            System.out.println("[" + testName + "] Errore trovato: " + e22.getMessage());
                                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                String string = msgErroreAtteso11 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "[ERROR][REQUEST][PUT /pets @body] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                if (!e22.getMessage().contains(msgErroreAtteso11)) {
                                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso11 + "':" + e22.getMessage());
                                                }
                                            } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                msgErroreAtteso11 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                                if (!e22.getMessage().contains(msgErroreAtteso11)) {
                                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso11 + "':" + e22.getMessage());
                                                }
                                            }
                                            System.out.println("[" + testName + "] Test #10-additionalProperties completato\n\n");
                                            System.out.println("[" + testName + "] Test #10-required (Richiesta PUT con body json errato)");
                                            TextHttpRequestEntity httpEntity10_required = new TextHttpRequestEntity();
                                            httpEntity10_required.setMethod(HttpRequestMethod.PUT);
                                            httpEntity10_required.setUrl("/pets");
                                            httpEntity10_required.setContent("{ \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"]}");
                                            CoreTest.setContentType("application/json", httpEntity10_required);
                                            try {
                                                apiValidator.validate(httpEntity10_required);
                                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                            }
                                            catch (ValidatorException e23) {
                                                String msgErroreAtteso12;
                                                System.out.println("[" + testName + "] Errore trovato: " + e23.getMessage());
                                                if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                    String string = msgErroreAtteso12 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'name' is required." : "[ERROR][REQUEST][PUT /pets @body] Object has missing required properties ([\"name\"])";
                                                    if (!e23.getMessage().contains(msgErroreAtteso12)) {
                                                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso12 + "':" + e23.getMessage());
                                                    }
                                                } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                    msgErroreAtteso12 = "$.name: is missing but it is required";
                                                    if (!e23.getMessage().contains(msgErroreAtteso12)) {
                                                        throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso12 + "':" + e23.getMessage());
                                                    }
                                                }
                                                System.out.println("[" + testName + "] Test #10-required completato\n\n");
                                                System.out.println("[" + testName + "] Test #11 (Risposta PUT con body json corretto)");
                                                TextHttpResponseEntity httpEntity11 = new TextHttpResponseEntity();
                                                httpEntity11.setMethod(HttpRequestMethod.PUT);
                                                httpEntity11.setUrl("/pets");
                                                httpEntity11.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1 }");
                                                CoreTest.setContentType("application/json", httpEntity11);
                                                httpEntity11.setStatus(200);
                                                apiValidator.validate(httpEntity11);
                                                System.out.println("[" + testName + "] Test #11 completato\n\n");
                                                System.out.println("[" + testName + "] Test #11-error (Risposta PUT con body json corretto)");
                                                TextHttpResponseEntity httpEntity11_error = new TextHttpResponseEntity();
                                                httpEntity11_error.setMethod(HttpRequestMethod.PUT);
                                                httpEntity11_error.setUrl("/pets");
                                                httpEntity11_error.setContent("{\"code\" : 234,  \"message\": \"Esempio di errore\" }");
                                                CoreTest.setContentType("application/json", httpEntity11_error);
                                                httpEntity11_error.setStatus(400);
                                                apiValidator.validate(httpEntity11_error);
                                                System.out.println("[" + testName + "] Test #11-error completato\n\n");
                                                System.out.println("[" + testName + "] Test #12-additionalProperties (Risposta PUT con body json errato)");
                                                TextHttpResponseEntity httpEntity12_additionalProperties = new TextHttpResponseEntity();
                                                httpEntity12_additionalProperties.setMethod(HttpRequestMethod.PUT);
                                                httpEntity12_additionalProperties.setUrl("/pets");
                                                httpEntity12_additionalProperties.setContent("{\"name\" : \"aaa\", \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1 , \"a\":\"b\"}");
                                                CoreTest.setContentType("application/json", httpEntity12_additionalProperties);
                                                httpEntity12_additionalProperties.setStatus(200);
                                                try {
                                                    apiValidator.validate(httpEntity12_additionalProperties);
                                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                }
                                                catch (ValidatorException e24) {
                                                    String msgErroreAtteso13;
                                                    System.out.println("[" + testName + "] Errore trovato: " + e24.getMessage());
                                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                        String string = msgErroreAtteso13 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "- [ERROR][] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                        if (!e24.getMessage().contains(msgErroreAtteso13)) {
                                                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso13 + "':" + e24.getMessage());
                                                        }
                                                    } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                        msgErroreAtteso13 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                                        if (!e24.getMessage().contains(msgErroreAtteso13)) {
                                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso13 + "':" + e24.getMessage());
                                                        }
                                                    }
                                                    System.out.println("[" + testName + "] Test #12-additionalProperties completato\n\n");
                                                    System.out.println("[" + testName + "] Test #12-required (Risposta PUT con body json errato)");
                                                    TextHttpResponseEntity httpEntity12_required = new TextHttpResponseEntity();
                                                    httpEntity12_required.setMethod(HttpRequestMethod.PUT);
                                                    httpEntity12_required.setUrl("/pets");
                                                    httpEntity12_required.setContent("{\"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1}");
                                                    CoreTest.setContentType("application/json", httpEntity12_required);
                                                    httpEntity12_required.setStatus(200);
                                                    try {
                                                        apiValidator.validate(httpEntity12_required);
                                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                    }
                                                    catch (ValidatorException e25) {
                                                        String msgErroreAtteso14;
                                                        System.out.println("[" + testName + "] Errore trovato: " + e25.getMessage());
                                                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                            String string = msgErroreAtteso14 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'name' is required." : "- [ERROR][] Object has missing required properties ([\"name\"])";
                                                            if (!e25.getMessage().contains(msgErroreAtteso14)) {
                                                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso14 + "':" + e25.getMessage());
                                                            }
                                                        } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                            msgErroreAtteso14 = "$.name: is missing but it is required";
                                                            if (!e25.getMessage().contains(msgErroreAtteso14)) {
                                                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso14 + "':" + e25.getMessage());
                                                            }
                                                        }
                                                        System.out.println("[" + testName + "] Test #12-required completato\n\n");
                                                        System.out.println("[" + testName + "] Test #12-error-additionalProperties (Risposta PUT con body json errato)");
                                                        TextHttpResponseEntity httpEntity12_error_additionalProperties = new TextHttpResponseEntity();
                                                        httpEntity12_error_additionalProperties.setMethod(HttpRequestMethod.PUT);
                                                        httpEntity12_error_additionalProperties.setUrl("/pets");
                                                        httpEntity12_error_additionalProperties.setContent("{\"code\" : 234, \"message\": \"Esempio di errore\", \"a\":\"b\"}");
                                                        CoreTest.setContentType("application/json", httpEntity12_error_additionalProperties);
                                                        httpEntity12_error_additionalProperties.setStatus(400);
                                                        try {
                                                            apiValidator.validate(httpEntity12_error_additionalProperties);
                                                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                        }
                                                        catch (ValidatorException e26) {
                                                            String msgErroreAtteso15;
                                                            System.out.println("[" + testName + "] Errore trovato: " + e26.getMessage());
                                                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                                String string = msgErroreAtteso15 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "[ERROR][RESPONSE][] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                                if (!e26.getMessage().contains(msgErroreAtteso15)) {
                                                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso15 + "':" + e26.getMessage());
                                                                }
                                                            } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                msgErroreAtteso15 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                                                if (!e26.getMessage().contains(msgErroreAtteso15)) {
                                                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso15 + "':" + e26.getMessage());
                                                                }
                                                            }
                                                            System.out.println("[" + testName + "] Test #12-error-additionalProperties completato\n\n");
                                                            System.out.println("[" + testName + "] Test #12-error-required (Risposta PUT con body json errato)");
                                                            TextHttpResponseEntity httpEntity12_error_required = new TextHttpResponseEntity();
                                                            httpEntity12_error_required.setMethod(HttpRequestMethod.PUT);
                                                            httpEntity12_error_required.setUrl("/pets");
                                                            httpEntity12_error_required.setContent("{\"message\": \"Esempio di errore\"}");
                                                            CoreTest.setContentType("application/json", httpEntity12_error_required);
                                                            httpEntity12_error_required.setStatus(400);
                                                            try {
                                                                apiValidator.validate(httpEntity12_error_required);
                                                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                            }
                                                            catch (ValidatorException e27) {
                                                                String msgErroreAtteso16;
                                                                System.out.println("[" + testName + "] Errore trovato: " + e27.getMessage());
                                                                if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                                    String string = msgErroreAtteso16 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'code' is required." : "[ERROR][RESPONSE][] Object has missing required properties ([\"code\"])";
                                                                    if (!e27.getMessage().contains(msgErroreAtteso16)) {
                                                                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso16 + "':" + e27.getMessage());
                                                                    }
                                                                } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                    msgErroreAtteso16 = "$.code: is missing but it is required";
                                                                    if (!e27.getMessage().contains(msgErroreAtteso16)) {
                                                                        throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso16 + "':" + e27.getMessage());
                                                                    }
                                                                }
                                                                System.out.println("[" + testName + "] Test #12-error-required completato\n\n");
                                                                System.out.println("[" + testName + "] Test #13 (Richiesta DELETE con body json corretto)");
                                                                TextHttpRequestEntity httpEntity13 = new TextHttpRequestEntity();
                                                                httpEntity13.setMethod(HttpRequestMethod.DELETE);
                                                                httpEntity13.setUrl("/pets");
                                                                if (bodyInDelete) {
                                                                    httpEntity13.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"] }");
                                                                    CoreTest.setContentType("application/json", httpEntity13);
                                                                }
                                                                apiValidator.validate(httpEntity13);
                                                                System.out.println("[" + testName + "] Test #13 completato\n\n");
                                                                if (bodyInDelete) {
                                                                    System.out.println("[" + testName + "] Test #14-additionalProperties (Richiesta DELETE con body json errato)");
                                                                    TextHttpRequestEntity httpEntity14_additionalProperties = new TextHttpRequestEntity();
                                                                    httpEntity14_additionalProperties.setMethod(HttpRequestMethod.DELETE);
                                                                    httpEntity14_additionalProperties.setUrl("/pets");
                                                                    httpEntity14_additionalProperties.setContent("{\"name\" : \"aaa\", \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"a\":\"b\"}");
                                                                    CoreTest.setContentType("application/json", httpEntity14_additionalProperties);
                                                                    try {
                                                                        apiValidator.validate(httpEntity14_additionalProperties);
                                                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                                    }
                                                                    catch (ValidatorException e28) {
                                                                        System.out.println("[" + testName + "] Errore trovato: " + e28.getMessage());
                                                                        if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                            String msgErroreAtteso17;
                                                                            String string = msgErroreAtteso17 = OpenAPILibrary.json_schema.equals(openAPILibrary) ? "$.a: is not defined in the schema and the schema does not allow additional properties" : "[ERROR][REQUEST][DELETE /pets @body] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                                            if (!e28.getMessage().contains(msgErroreAtteso17)) {
                                                                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso17 + "':" + e28.getMessage());
                                                                            }
                                                                        }
                                                                        System.out.println("[" + testName + "] Test #14-additionalProperties completato\n\n");
                                                                        System.out.println("[" + testName + "] Test #14-required (Richiesta DELETE con body json errato)");
                                                                        TextHttpRequestEntity httpEntity14_required = new TextHttpRequestEntity();
                                                                        httpEntity14_required.setMethod(HttpRequestMethod.DELETE);
                                                                        httpEntity14_required.setUrl("/pets");
                                                                        httpEntity14_required.setContent("{ \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"]}");
                                                                        CoreTest.setContentType("application/json", httpEntity14_required);
                                                                        try {
                                                                            apiValidator.validate(httpEntity14_required);
                                                                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                                        }
                                                                        catch (ValidatorException e29) {
                                                                            System.out.println("[" + testName + "] Errore trovato: " + e29.getMessage());
                                                                            if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                                String msgErroreAtteso18;
                                                                                String string = msgErroreAtteso18 = OpenAPILibrary.json_schema.equals(openAPILibrary) ? "$.name: is missing but it is required" : "[ERROR][REQUEST][DELETE /pets @body] Object has missing required properties ([\"name\"])";
                                                                                if (!e29.getMessage().contains(msgErroreAtteso18)) {
                                                                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso18 + "':" + e29.getMessage());
                                                                                }
                                                                            }
                                                                            System.out.println("[" + testName + "] Test #14-required completato\n\n");
                                                                        }
                                                                    }
                                                                }
                                                                System.out.println("[" + testName + "] Test #15 (Risposta DELETE con body json corretto)");
                                                                TextHttpResponseEntity httpEntity15 = new TextHttpResponseEntity();
                                                                httpEntity15.setMethod(HttpRequestMethod.DELETE);
                                                                httpEntity15.setUrl("/pets");
                                                                httpEntity15.setContent("{\"name\" : \"aaa\",  \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1 }");
                                                                CoreTest.setContentType("application/json", httpEntity15);
                                                                httpEntity15.setStatus(200);
                                                                apiValidator.validate(httpEntity15);
                                                                System.out.println("[" + testName + "] Test #15 completato\n\n");
                                                                System.out.println("[" + testName + "] Test #15-error (Risposta DELETE con body json corretto)");
                                                                TextHttpResponseEntity httpEntity15_error = new TextHttpResponseEntity();
                                                                httpEntity15_error.setMethod(HttpRequestMethod.DELETE);
                                                                httpEntity15_error.setUrl("/pets");
                                                                httpEntity15_error.setContent("{\"code\" : 234,  \"message\": \"Esempio di errore\" }");
                                                                CoreTest.setContentType("application/json", httpEntity15_error);
                                                                httpEntity15_error.setStatus(400);
                                                                apiValidator.validate(httpEntity15_error);
                                                                System.out.println("[" + testName + "] Test #15-error completato\n\n");
                                                                System.out.println("[" + testName + "] Test #16-additionalProperties (Risposta DELETE con body json errato)");
                                                                TextHttpResponseEntity httpEntity16_additionalProperties = new TextHttpResponseEntity();
                                                                httpEntity16_additionalProperties.setMethod(HttpRequestMethod.DELETE);
                                                                httpEntity16_additionalProperties.setUrl("/pets");
                                                                httpEntity16_additionalProperties.setContent("{\"name\" : \"aaa\", \"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1 , \"a\":\"b\"}");
                                                                CoreTest.setContentType("application/json", httpEntity16_additionalProperties);
                                                                httpEntity16_additionalProperties.setStatus(200);
                                                                try {
                                                                    apiValidator.validate(httpEntity16_additionalProperties);
                                                                    throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                                }
                                                                catch (ValidatorException e30) {
                                                                    String msgErroreAtteso19;
                                                                    System.out.println("[" + testName + "] Errore trovato: " + e30.getMessage());
                                                                    if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                                        String string = msgErroreAtteso19 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "- [ERROR][] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                                        if (!e30.getMessage().contains(msgErroreAtteso19)) {
                                                                            throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso19 + "':" + e30.getMessage());
                                                                        }
                                                                    } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                        msgErroreAtteso19 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                                                        if (!e30.getMessage().contains(msgErroreAtteso19)) {
                                                                            throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso19 + "':" + e30.getMessage());
                                                                        }
                                                                    }
                                                                    System.out.println("[" + testName + "] Test #16 -additionalProperties completato\n\n");
                                                                    System.out.println("[" + testName + "] Test #16-required (Risposta DELETE con body json errato)");
                                                                    TextHttpResponseEntity httpEntity16_required = new TextHttpResponseEntity();
                                                                    httpEntity16_required.setMethod(HttpRequestMethod.DELETE);
                                                                    httpEntity16_required.setUrl("/pets");
                                                                    httpEntity16_required.setContent("{\"photoUrls\": [\"http:localhost:8080/a\",\"http:localhost:8080/b\"], \"id\" : 1}");
                                                                    CoreTest.setContentType("application/json", httpEntity16_required);
                                                                    httpEntity16_required.setStatus(200);
                                                                    try {
                                                                        apiValidator.validate(httpEntity16_required);
                                                                        throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                                    }
                                                                    catch (ValidatorException e31) {
                                                                        String msgErroreAtteso20;
                                                                        System.out.println("[" + testName + "] Errore trovato: " + e31.getMessage());
                                                                        if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                                            String string = msgErroreAtteso20 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'name' is required." : "- [ERROR][] Object has missing required properties ([\"name\"])";
                                                                            if (!e31.getMessage().contains(msgErroreAtteso20)) {
                                                                                throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso20 + "':" + e31.getMessage());
                                                                            }
                                                                        } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                            msgErroreAtteso20 = "$.name: is missing but it is required";
                                                                            if (!e31.getMessage().contains(msgErroreAtteso20)) {
                                                                                throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso20 + "':" + e31.getMessage());
                                                                            }
                                                                        }
                                                                        System.out.println("[" + testName + "] Test #16 -required completato\n\n");
                                                                        System.out.println("[" + testName + "] Test #16-error-additionalProperties (Risposta DELETE con body json errato)");
                                                                        TextHttpResponseEntity httpEntity16_error_additionalProperties = new TextHttpResponseEntity();
                                                                        httpEntity16_error_additionalProperties.setMethod(HttpRequestMethod.DELETE);
                                                                        httpEntity16_error_additionalProperties.setUrl("/pets");
                                                                        httpEntity16_error_additionalProperties.setContent("{\"code\" : 234, \"message\": \"Esempio di errore\", \"a\":\"b\"}");
                                                                        CoreTest.setContentType("application/json", httpEntity16_error_additionalProperties);
                                                                        httpEntity16_error_additionalProperties.setStatus(400);
                                                                        try {
                                                                            apiValidator.validate(httpEntity16_error_additionalProperties);
                                                                            throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                                        }
                                                                        catch (ValidatorException e32) {
                                                                            String msgErroreAtteso21;
                                                                            System.out.println("[" + testName + "] Errore trovato: " + e32.getMessage());
                                                                            if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                                                String string = msgErroreAtteso21 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Additional property 'a' is not allowed." : "[ERROR][RESPONSE][] Object instance has properties which are not allowed by the schema: [\"a\"]";
                                                                                if (!e32.getMessage().contains(msgErroreAtteso21)) {
                                                                                    throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso21 + "':" + e32.getMessage());
                                                                                }
                                                                            } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                                msgErroreAtteso21 = "$.a: is not defined in the schema and the schema does not allow additional properties";
                                                                                if (!e32.getMessage().contains(msgErroreAtteso21)) {
                                                                                    throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso21 + "':" + e32.getMessage());
                                                                                }
                                                                            }
                                                                            System.out.println("[" + testName + "] Test #16-error-additionalProperties completato\n\n");
                                                                            System.out.println("[" + testName + "] Test #16-error-required (Risposta DELETE con body json errato)");
                                                                            TextHttpResponseEntity httpEntity16_error_required = new TextHttpResponseEntity();
                                                                            httpEntity16_error_required.setMethod(HttpRequestMethod.DELETE);
                                                                            httpEntity16_error_required.setUrl("/pets");
                                                                            httpEntity16_error_required.setContent("{\"message\": \"Esempio di errore\"}");
                                                                            CoreTest.setContentType("application/json", httpEntity16_error_required);
                                                                            httpEntity16_error_required.setStatus(400);
                                                                            try {
                                                                                apiValidator.validate(httpEntity16_error_required);
                                                                                throw new Exception("Errore: Attesa " + ValidatorException.class.getName());
                                                                            }
                                                                            catch (ValidatorException e33) {
                                                                                System.out.println("[" + testName + "] Errore trovato: " + e33.getMessage());
                                                                                if (OpenAPILibrary.openapi4j.equals(openAPILibrary) || OpenAPILibrary.swagger_request_validator.equals(openAPILibrary)) {
                                                                                    String msgErroreAtteso22;
                                                                                    String string = msgErroreAtteso22 = OpenAPILibrary.openapi4j.equals(openAPILibrary) ? "body: Field 'code' is required." : "[ERROR][RESPONSE][] Object has missing required properties ([\"code\"])";
                                                                                    if (!e33.getMessage().contains(msgErroreAtteso22)) {
                                                                                        throw new Exception("Errore: atteso messaggio di errore che contenga '" + msgErroreAtteso22 + "':" + e33.getMessage());
                                                                                    }
                                                                                } else if (JsonValidatorAPI.ApiName.NETWORK_NT.equals((Object)config.getJsonValidatorAPI())) {
                                                                                    String msgErroreAtteso23 = "$.code: is missing but it is required";
                                                                                    if (!e33.getMessage().contains(msgErroreAtteso23)) {
                                                                                        throw new Exception("Errore: atteso messaggio di errore '" + msgErroreAtteso23 + "':" + e33.getMessage());
                                                                                    }
                                                                                }
                                                                                System.out.println("[" + testName + "] Test #16-error-required completato\n\n");
                                                                                apiValidator.close(LoggerWrapperFactory.getLogger(CoreTest.class), api, config);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                apiValidator.close(LoggerWrapperFactory.getLogger(CoreTest.class), api, config);
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("[" + testName + "] Errore durante l'esecuzione dei test: " + e.getMessage());
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private static void setContentType(String contentType, HttpBaseEntity<?> httpEntity) {
        httpEntity.setContentType(contentType);
        if (httpEntity.getHeaders() == null) {
            httpEntity.setHeaders(new HashMap<String, List<String>>());
        }
        httpEntity.getHeaders().remove("Content-Type");
        httpEntity.getHeaders().remove("Content-Type".toUpperCase());
        httpEntity.getHeaders().remove("Content-Type".toLowerCase());
        ArrayList<String> l = new ArrayList<String>();
        l.add(contentType);
        httpEntity.getHeaders().put("Content-Type", l);
    }
}

