/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.openapi.validator.OpenAPILibrary;
import org.openspcoop2.utils.openapi.validator.OpenapiApiValidatorConfig;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;

public class MainValidatorOpenAPI4 {
    public static void main(String[] args) throws Exception {
        OpenAPILibrary openApiLibrary = OpenAPILibrary.swagger_request_validator;
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration(Level.ERROR);
        if (args == null || args.length < 1) {
            throw new Exception("Usage: MainValidatorOpenAPI4 <file> [dirIncludes]");
        }
        String file = args[0].trim();
        File f = new File(file);
        if (!f.exists()) {
            throw new Exception("File '" + f.getAbsolutePath() + "' not exists");
        }
        if (!f.canRead()) {
            throw new Exception("File '" + f.getAbsolutePath() + "' cannot read");
        }
        File fDir = null;
        if (args.length > 1) {
            fDir = new File(args[1].trim());
            if (!fDir.exists()) {
                throw new Exception("File '" + fDir.getAbsolutePath() + "' not exists");
            }
            if (!fDir.canRead()) {
                throw new Exception("File '" + fDir.getAbsolutePath() + "' cannot read");
            }
            if (!fDir.isDirectory()) {
                throw new Exception("File '" + fDir.getAbsolutePath() + "' is not directory");
            }
        }
        boolean output = false;
        if (args.length > 2) {
            output = Boolean.valueOf(args[2]);
        }
        try {
            File[] files;
            URL url = f.toURI().toURL();
            ArrayList<ApiSchema> listApiSchema = null;
            if (fDir != null && (files = fDir.listFiles()) != null) {
                for (File fChild : files) {
                    if (!fChild.exists()) {
                        throw new Exception("File '" + fChild.getAbsolutePath() + "' not exists");
                    }
                    if (!fChild.canRead()) {
                        throw new Exception("File '" + fChild.getAbsolutePath() + "' cannot read");
                    }
                    if (fChild.getName().equals(f.getName())) continue;
                    ApiSchema apiSchema = null;
                    if (fChild.getName().toLowerCase().endsWith(".yaml")) {
                        apiSchema = new ApiSchema(fChild.getName(), FileSystemUtilities.readBytesFromFile(fChild), ApiSchemaType.YAML);
                    } else if (fChild.getName().toLowerCase().endsWith(".json")) {
                        apiSchema = new ApiSchema(fChild.getName(), FileSystemUtilities.readBytesFromFile(fChild), ApiSchemaType.JSON);
                    }
                    if (apiSchema == null) continue;
                    if (listApiSchema == null) {
                        listApiSchema = new ArrayList<ApiSchema>();
                    }
                    listApiSchema.add(apiSchema);
                }
            }
            ApiSchema[] schemas = null;
            if (listApiSchema != null && !listApiSchema.isEmpty()) {
                schemas = listApiSchema.toArray(new ApiSchema[1]);
            }
            IApiReader apiReader = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
            ApiReaderConfig config = new ApiReaderConfig();
            config.setProcessInclude(false);
            apiReader.init(LoggerWrapperFactory.getLogger(MainValidatorOpenAPI4.class), new File(url.toURI()), config, schemas);
            Api api = apiReader.read();
            IApiValidator apiValidator = ApiFactory.newApiValidator(ApiFormats.OPEN_API_3);
            OpenapiApiValidatorConfig configO = new OpenapiApiValidatorConfig();
            configO.setOpenApiValidatorConfig(new OpenapiLibraryValidatorConfig());
            configO.getOpenApiValidatorConfig().setOpenApiLibrary(openApiLibrary);
            apiValidator.init(LoggerWrapperFactory.getLogger(MainValidatorOpenAPI4.class), api, configO);
            System.err.println("Validazione effettuata con successo");
        }
        catch (Exception e) {
            if (output) {
                System.err.println("!ERRORE! Validazione fallita");
                e.printStackTrace(System.err);
            }
            throw e;
        }
    }
}

