/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.openapi.AbstractOpenapiApiReader;
import org.openspcoop2.utils.openapi.UniqueInterfaceGeneratorConfig;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.rest.ApiFormats;
import org.slf4j.Logger;

public class UniqueInterfaceGenerator {
    public static void main(String[] args) throws Exception {
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration(Level.ERROR);
        if (args == null || args.length < 4) {
            throw new Exception("Use: UniqueInterfaceGenerator <versioneOpenAPI> <destFile> <master> <attachmentsDir>");
        }
        String tipo = args[0].trim();
        ApiFormats format = ApiFormats.valueOf(tipo);
        String fileDest = args[1].trim();
        UniqueInterfaceGeneratorConfig config = new UniqueInterfaceGeneratorConfig();
        config.format = format;
        String fileMaster = args[2].trim();
        config.master = FileSystemUtilities.readFile(fileMaster);
        File fMaster = new File(fileMaster);
        String ext = null;
        try {
            ext = fileMaster.substring(fileMaster.lastIndexOf(".") + 1, fileMaster.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.yaml = "yaml".equalsIgnoreCase(ext);
        HashMap<String, String> attachments = new HashMap<String, String>();
        File fDir = new File(args[3].trim());
        if (!fDir.isDirectory()) {
            throw new Exception("attachmentsDir [" + fDir.getAbsolutePath() + "] is not directory");
        }
        File[] files = fDir.listFiles();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (files[j].getName().equals(fMaster.getName()) || files[j].isDirectory()) continue;
                attachments.put(files[j].getName(), FileSystemUtilities.readFile(files[j]));
            }
        }
        config.attachments = attachments;
        ArrayList<String> blackListParameters = null;
        ArrayList<String> blackListComponents = null;
        if (args.length > 5) {
            String blackListComponentsArgs;
            String blackListParametersArgs = args[4].trim();
            if (blackListParametersArgs != null) {
                blackListParameters = new ArrayList<String>();
                if (blackListParametersArgs.contains(",")) {
                    String[] tmp;
                    for (String s : tmp = blackListParametersArgs.split(",")) {
                        blackListParameters.add(s);
                    }
                } else {
                    blackListParameters.add(blackListParametersArgs);
                }
            }
            if ((blackListComponentsArgs = args[5].trim()) != null) {
                blackListComponents = new ArrayList<String>();
                if (blackListComponentsArgs.contains(",")) {
                    String[] tmp;
                    for (String s : tmp = blackListComponentsArgs.split(",")) {
                        blackListComponents.add(s);
                    }
                } else {
                    blackListComponents.add(blackListComponentsArgs);
                }
            }
        }
        UniqueInterfaceGenerator.generate(fileDest, config, blackListParameters, blackListComponents, true, null);
    }

    private static void debug(boolean debug, Logger log, String msg) {
        if (debug) {
            if (log != null) {
                log.debug(msg);
            } else {
                System.out.println(msg);
            }
        }
    }

    public static void generate(String fileDest, UniqueInterfaceGeneratorConfig config, List<String> blackListParameters, List<String> blackListComponents, boolean debug, Logger log) throws Exception {
        String schemaRebuild = UniqueInterfaceGenerator.generate(config, blackListParameters, blackListComponents, debug, log);
        try (FileOutputStream fout = new FileOutputStream(fileDest);){
            fout.write(schemaRebuild.getBytes());
            fout.flush();
        }
    }

    public static String generate(UniqueInterfaceGeneratorConfig config, List<String> blackListParameters, List<String> blackListComponents, boolean debug, Logger log) throws Exception {
        Header value;
        Map maps;
        SwaggerParseResult pr = null;
        ParseOptions parseOptions = new ParseOptions();
        pr = ApiFormats.SWAGGER_2.equals(config.format) ? new SwaggerConverter().readContents(config.master, null, parseOptions) : new OpenAPIV3Parser().readContents(config.master, null, parseOptions);
        StringBuilder sbParseWarningResult = new StringBuilder();
        OpenAPI api = AbstractOpenapiApiReader.parseResult(LoggerWrapperFactory.getLogger(UniqueInterfaceGenerator.class), pr, sbParseWarningResult);
        if (api.getComponents() == null) {
            api.setComponents(new Components());
        }
        Map<String, String> attachments = config.attachments;
        for (String attachName : attachments.keySet()) {
            String attach = attachments.get(attachName);
            UniqueInterfaceGenerator.debug(debug, log, "Merge [" + attachName + "] ...");
            pr = ApiFormats.SWAGGER_2.equals(config.format) ? new SwaggerConverter().readContents(attach, null, parseOptions) : new OpenAPIV3Parser().readContents(attach, null, parseOptions);
            OpenAPI apiInternal = AbstractOpenapiApiReader.parseResult(LoggerWrapperFactory.getLogger(UniqueInterfaceGenerator.class), pr, sbParseWarningResult);
            if (apiInternal.getComponents() != null) {
                Object value2;
                int mapsSize;
                Map maps2;
                if (apiInternal.getComponents().getCallbacks() != null) {
                    maps2 = apiInternal.getComponents().getCallbacks();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (Callback)maps2.get(key);
                            api.getComponents().addCallbacks(key, value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " callback");
                }
                if (apiInternal.getComponents().getExamples() != null) {
                    maps2 = apiInternal.getComponents().getExamples();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (Example)maps2.get(key);
                            api.getComponents().addExamples(key, (Example)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " example");
                }
                if (apiInternal.getComponents().getExtensions() != null) {
                    maps2 = apiInternal.getComponents().getExtensions();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = maps2.get(key);
                            api.getComponents().addExtension(key, value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " extensions");
                }
                if (apiInternal.getComponents().getHeaders() != null) {
                    maps2 = apiInternal.getComponents().getHeaders();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (Header)maps2.get(key);
                            api.getComponents().addHeaders(key, (Header)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " header");
                }
                if (apiInternal.getComponents().getLinks() != null) {
                    maps2 = apiInternal.getComponents().getLinks();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (Link)maps2.get(key);
                            api.getComponents().addLinks(key, (Link)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " link");
                }
                if (apiInternal.getComponents().getParameters() != null) {
                    maps2 = apiInternal.getComponents().getParameters();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            if (blackListParameters != null && blackListParameters.contains(key)) {
                                UniqueInterfaceGenerator.debug(debug, log, "Parameter '" + key + "' skipped");
                                continue;
                            }
                            value2 = (Parameter)maps2.get(key);
                            api.getComponents().addParameters(key, (Parameter)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " parameter");
                }
                if (apiInternal.getComponents().getRequestBodies() != null) {
                    maps2 = apiInternal.getComponents().getRequestBodies();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (RequestBody)maps2.get(key);
                            api.getComponents().addRequestBodies(key, (RequestBody)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " requestBody");
                }
                if (apiInternal.getComponents().getResponses() != null) {
                    maps2 = apiInternal.getComponents().getResponses();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (ApiResponse)maps2.get(key);
                            api.getComponents().addResponses(key, (ApiResponse)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + "] response");
                }
                if (apiInternal.getComponents().getSchemas() != null) {
                    maps2 = apiInternal.getComponents().getSchemas();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            if (blackListComponents != null && blackListComponents.contains(key)) {
                                UniqueInterfaceGenerator.debug(debug, log, "Component '" + key + "' skipped");
                                continue;
                            }
                            value2 = (Schema)maps2.get(key);
                            api.getComponents().addSchemas(key, (Schema)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " schema");
                }
                if (apiInternal.getComponents().getSecuritySchemes() != null) {
                    maps2 = apiInternal.getComponents().getSecuritySchemes();
                    mapsSize = 0;
                    if (maps2 != null && !maps2.isEmpty()) {
                        mapsSize = maps2.size();
                        for (String key : maps2.keySet()) {
                            value2 = (SecurityScheme)maps2.get(key);
                            api.getComponents().addSecuritySchemes(key, (SecurityScheme)value2);
                        }
                    }
                    UniqueInterfaceGenerator.debug(debug, log, "\t" + mapsSize + " security schema");
                }
            }
            UniqueInterfaceGenerator.debug(debug, log, "Merge [" + attachName + "] ok");
        }
        api.setExtensions(null);
        api.getComponents().setExtensions(null);
        if (api.getComponents().getHeaders() != null && (maps = api.getComponents().getHeaders()) != null && !maps.isEmpty()) {
            for (String key : maps.keySet()) {
                value = (Header)maps.get(key);
                value.setExplode(null);
                value.setStyle(null);
            }
        }
        if (api.getComponents().getParameters() != null && (maps = api.getComponents().getParameters()) != null && !maps.isEmpty()) {
            for (String key : maps.keySet()) {
                value = (Parameter)maps.get(key);
                value.setExplode(null);
                value.setStyle(null);
                UniqueInterfaceGenerator.checkSchema(0, "Parameter-" + key, value.getSchema());
            }
        }
        if (api.getComponents().getSchemas() != null && (maps = api.getComponents().getSchemas()) != null && !maps.isEmpty()) {
            for (String key : maps.keySet()) {
                value = (Schema)maps.get(key);
                Object sorgente = "";
                sorgente = value.getName() != null ? (String)sorgente + value.getName() : (String)sorgente + "RootSchema";
                UniqueInterfaceGenerator.checkSchema(0, (String)sorgente, value);
            }
        }
        JsonNode jsonNode = null;
        String s = null;
        if (config.yaml) {
            s = YAMLUtils.getObjectWriter().writeValueAsString((Object)api);
            jsonNode = YAMLUtils.getInstance().getAsNode(s);
        } else {
            s = JSONUtils.getObjectWriter().writeValueAsString((Object)api);
            jsonNode = JSONUtils.getInstance().getAsNode(s);
        }
        JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
        List<String> refPath = engine.getStringMatchPattern(jsonNode, "$..$ref");
        String schemaRebuild = s;
        schemaRebuild = UniqueInterfaceGenerator.replace(refPath, schemaRebuild, true);
        schemaRebuild = UniqueInterfaceGenerator.replace(refPath, schemaRebuild, false);
        if (schemaRebuild.startsWith("---")) {
            schemaRebuild = schemaRebuild.substring("---".length());
        }
        if (schemaRebuild.startsWith("\n")) {
            schemaRebuild = schemaRebuild.substring("\n".length());
        }
        String extensions = "extensions:\n    ";
        schemaRebuild = schemaRebuild.replace(extensions, "");
        String ext = "    x-";
        String extCorrect = "  x-";
        while (schemaRebuild.contains(ext)) {
            schemaRebuild = schemaRebuild.replace(ext, extCorrect);
        }
        return schemaRebuild;
    }

    private static String replace(List<String> refPath, String schemaRebuild, boolean usePrefixChar) {
        if (refPath != null && !refPath.isEmpty()) {
            for (String ref : refPath) {
                String destraRep;
                String rep;
                if (!schemaRebuild.contains(ref) || ref.startsWith("#")) continue;
                String destra = ref.substring(ref.indexOf("#"));
                String refForReplace = ref;
                if (usePrefixChar) {
                    rep = "\"" + refForReplace + "\"";
                    destraRep = "\"" + destra + "\"";
                    while (schemaRebuild.contains(rep)) {
                        schemaRebuild = schemaRebuild.replace(rep, destraRep);
                    }
                    rep = "'" + refForReplace + "'";
                    destraRep = "'" + destra + "'";
                    while (schemaRebuild.contains(rep)) {
                        schemaRebuild = schemaRebuild.replace(rep, destraRep);
                    }
                } else {
                    while (schemaRebuild.contains(refForReplace)) {
                        schemaRebuild = schemaRebuild.replace(refForReplace, destra);
                    }
                }
                if (!refForReplace.startsWith("./") || refForReplace.length() <= 2) continue;
                refForReplace = refForReplace.substring(2);
                if (usePrefixChar) {
                    rep = "\"" + refForReplace + "\"";
                    destraRep = "\"" + destra + "\"";
                    while (schemaRebuild.contains(rep)) {
                        schemaRebuild = schemaRebuild.replace(rep, destraRep);
                    }
                    rep = "'" + refForReplace + "'";
                    destraRep = "'" + destra + "'";
                    while (schemaRebuild.contains(rep)) {
                        schemaRebuild = schemaRebuild.replace(rep, destraRep);
                    }
                    continue;
                }
                while (schemaRebuild.contains(refForReplace)) {
                    schemaRebuild = schemaRebuild.replace(refForReplace, destra);
                }
            }
        }
        return schemaRebuild;
    }

    private static int checkSchema(int profondita, String sorgente, Schema<?> schema) {
        if (profondita > 1000) {
            return profondita;
        }
        Map properties = schema.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (String key : properties.keySet()) {
                Schema value = (Schema)properties.get(key);
                String sorgenteInterno = sorgente + ".";
                sorgenteInterno = value.getName() != null ? sorgenteInterno + value.getName() : sorgenteInterno + "schemaProfondita" + profondita;
                int n = UniqueInterfaceGenerator.checkSchema(profondita + 1, sorgenteInterno, value);
            }
        }
        return profondita;
    }
}

