/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mail.MailAttach;

public class MailBinaryAttach
extends MailAttach {
    private byte[] content;
    private InputStream inputStream;

    public MailBinaryAttach(String name, byte[] content, String contentType) {
        super(name, contentType);
        this.content = content;
    }

    public MailBinaryAttach(String name, InputStream inputStream, String contentType) {
        super(name, contentType);
        this.inputStream = inputStream;
    }

    public MailBinaryAttach(String name, byte[] content) {
        this(name, content, null);
    }

    public MailBinaryAttach(String name, InputStream inputStream) {
        this(name, inputStream, null);
    }

    public byte[] getContent() throws UtilsException {
        if (this.content == null) {
            return Utilities.getAsByteArray(this.inputStream);
        }
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return new ByteArrayInputStream(this.content);
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }
}

