/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mail;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mail.Mail;
import org.openspcoop2.utils.mail.MailAttach;
import org.openspcoop2.utils.mail.MailBinaryAttach;
import org.openspcoop2.utils.mail.MailTextAttach;
import org.openspcoop2.utils.mail.Sender;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.slf4j.Logger;

public class CommonsMailSender
extends Sender {
    protected CommonsMailSender(Logger log) {
        super(log);
    }

    @Override
    public void send(Mail mail, boolean debug) throws UtilsException {
        ArrayList<File> filesAllegati = new ArrayList<File>();
        try {
            boolean attach = mail.getBody().getAttachments() != null && mail.getBody().getAttachments().size() > 0;
            Object email = null;
            email = attach ? new MultiPartEmail() : new SimpleEmail();
            email.setSocketConnectionTimeout(this.getConnectionTimeout());
            email.setSocketTimeout(this.getReadTimeout());
            email.setHostName(mail.getServerHost());
            email.setSmtpPort(mail.getServerPort());
            if (mail.getUsername() != null) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(mail.getUsername(), mail.getPassword()));
            }
            if (mail.getSslConfig() != null) {
                email.setSSLCheckServerIdentity(mail.getSslConfig().isHostnameVerifier());
                email.setSSLOnConnect(true);
                StringBuilder bf = new StringBuilder();
                SSLUtilities.setSSLContextIntoJavaProperties(mail.getSslConfig(), bf);
                if (debug) {
                    this.log.debug(bf.toString());
                }
                email.setStartTLSEnabled(mail.isStartTls());
            }
            email.setFrom(mail.getFrom());
            email.addTo(mail.getTo());
            List<String> ccList = mail.getCc();
            if (ccList != null && ccList.size() > 0) {
                for (String cc : ccList) {
                    email.addCc(cc);
                }
            }
            email.setSubject(mail.getSubject());
            if (attach) {
                if (mail.getBody().getMessage() != null) {
                    email.setMsg(mail.getBody().getMessage());
                }
                for (MailAttach mailAttach : mail.getBody().getAttachments()) {
                    EmailAttachment attachment = new EmailAttachment();
                    File fTmp = null;
                    if (mailAttach instanceof MailTextAttach) {
                        MailTextAttach text = (MailTextAttach)mailAttach;
                        fTmp = FileSystemUtilities.createTempFile("mailTextAttach", ".txt");
                        FileSystemUtilities.writeFile(fTmp, text.getContent().getBytes());
                    } else {
                        MailBinaryAttach bin = (MailBinaryAttach)mailAttach;
                        fTmp = FileSystemUtilities.createTempFile("mailTextAttach", ".bin");
                        FileSystemUtilities.writeFile(fTmp, bin.getContent());
                    }
                    attachment.setPath(fTmp.getAbsolutePath());
                    filesAllegati.add(fTmp);
                    attachment.setDisposition("attachment");
                    attachment.setDescription(mailAttach.getName());
                    attachment.setName(mailAttach.getName());
                    email.attach(attachment);
                }
            } else {
                email.setMsg(mail.getBody().getMessage());
            }
            email.setDebug(debug);
            if (mail.getUserAgent() != null) {
                email.addHeader("User-Agent", mail.getUserAgent());
            }
            if (mail.getMessageIdDomain() != null) {
                email.addHeader("Message-ID", "<" + UUID.randomUUID().toString() + "@" + mail.getMessageIdDomain() + ">");
            }
            if (mail.getContentLanguage() != null) {
                email.addHeader("Content-Language", mail.getContentLanguage());
            }
            if (attach) {
                email.buildMimeMessage();
                email.sendMimeMessage();
            } else {
                email.send();
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            for (File file : filesAllegati) {
                try {
                    if (file.delete()) continue;
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

