/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.logger;

import java.lang.reflect.Constructor;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.logger.ILogReader;

public class LogReaderFactory {
    private static Class<ILogReader> loggerImpl = null;
    private static Object[] parameters = null;
    private static Class<?>[] parameterTypes = null;

    public static void initialize(String implementationClassName, Object ... pars) throws UtilsException, ClassNotFoundException {
        Class<ILogReader> c = Class.forName(implementationClassName);
        LogReaderFactory.initialize(c, pars);
    }

    public static void initialize(Class<ILogReader> implementationClass, Object ... pars) throws UtilsException {
        try {
            loggerImpl = implementationClass;
            parameters = pars;
            if (parameters != null) {
                parameterTypes = new Class[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    LogReaderFactory.parameterTypes[i] = parameters[i].getClass();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Expected class assignable from " + ILogReader.class.getName() + ". Found: " + implementationClass.getName() + " . Error: " + e.getMessage(), e);
        }
    }

    public static ILogReader newReader() throws UtilsException {
        if (loggerImpl == null) {
            throw new UtilsException("LogReaderFactory not Initialized");
        }
        try {
            Constructor<ILogReader> c = loggerImpl.getConstructor(parameterTypes);
            ILogReader reader = c.newInstance(parameters);
            reader.initReader();
            return reader;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

