/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.logger;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.logger.DiagnosticProperties;
import org.openspcoop2.utils.logger.IContext;
import org.openspcoop2.utils.logger.ILogger;
import org.openspcoop2.utils.logger.constants.LowSeverity;
import org.openspcoop2.utils.logger.constants.Severity;

public class DiagnosticManager {
    private static final String CONTEXT = "context.";
    private static final String DYNAMIC_OBJECT = "object.";
    private DiagnosticProperties diagnosticProperties;
    private IContext context;
    private ILogger loggerForCallback;

    protected DiagnosticManager(Properties diagnosticProperties, IContext context, boolean throwExceptionPlaceholderFailedResolution, ILogger loggerForCallback) throws UtilsException {
        this.diagnosticProperties = DiagnosticProperties.getInstance(diagnosticProperties, throwExceptionPlaceholderFailedResolution);
        this.context = context;
        this.loggerForCallback = loggerForCallback;
    }

    private DiagnosticManager() {
    }

    public DiagnosticManager clone(IContext newContext) {
        DiagnosticManager dmNew = new DiagnosticManager();
        dmNew.context = newContext;
        dmNew.diagnosticProperties = this.diagnosticProperties.clone();
        dmNew.loggerForCallback = this.loggerForCallback;
        return dmNew;
    }

    public List<String> getFunctions() {
        ArrayList<String> keys = null;
        if (!this.diagnosticProperties.getMappingFunctionToCode().isEmpty()) {
            keys = new ArrayList<String>();
            for (String key : this.diagnosticProperties.getMappingFunctionToCode().keySet()) {
                keys.add(key);
            }
        }
        return keys;
    }

    public String getDefaultFunction() {
        return this.diagnosticProperties.getDefaultFunction();
    }

    public String getDefaultCode(String function, LowSeverity severity) throws UtilsException {
        if (!this.diagnosticProperties.getMappingFunctionToCode().containsKey(function)) {
            throw new UtilsException("Function [" + function + "] undefined");
        }
        return this.diagnosticProperties.getMappingFunctionToCode().get(function) + this.diagnosticProperties.getMappingSeverityToCode().get(severity);
    }

    public String getCode(String code) throws UtilsException {
        if (this.diagnosticProperties.getMappingFullCodeToFullString().containsKey(code)) {
            return code;
        }
        if (this.diagnosticProperties.getMappingStringCodeToDiagnostic().containsKey(code)) {
            return this.diagnosticProperties.getMappingStringCodeToDiagnostic().get((Object)code).functionCode + this.diagnosticProperties.getMappingStringCodeToDiagnostic().get((Object)code).code;
        }
        throw new UtilsException("Diagnostic with code [" + code + "] undefined");
    }

    public String getHumanCode(String code) throws UtilsException {
        if (this.diagnosticProperties.getMappingStringCodeToDiagnostic().containsKey(code)) {
            return code;
        }
        if (this.diagnosticProperties.getMappingFullCodeToFullString().containsKey(code)) {
            return this.diagnosticProperties.getMappingFullCodeToFullString().get(code);
        }
        throw new UtilsException("Diagnostic with code [" + code + "] undefined");
    }

    public Severity getSeverity(String code) throws UtilsException {
        String codeString = null;
        if (this.diagnosticProperties.getMappingFullCodeToFullString().containsKey(code)) {
            codeString = this.diagnosticProperties.getMappingFullCodeToFullString().get(code);
        }
        if (codeString == null && this.diagnosticProperties.getMappingStringCodeToDiagnostic().containsKey(code)) {
            codeString = code;
        }
        if (codeString == null) {
            throw new UtilsException("Diagnostic with code [" + code + "] undefined");
        }
        return this.diagnosticProperties.getMappingStringCodeToDiagnostic().get((Object)codeString).severity;
    }

    public String getMessage(String code, String ... params) throws UtilsException {
        String codeString = null;
        if (this.diagnosticProperties.getMappingFullCodeToFullString().containsKey(code)) {
            codeString = this.diagnosticProperties.getMappingFullCodeToFullString().get(code);
        }
        if (codeString == null && this.diagnosticProperties.getMappingStringCodeToDiagnostic().containsKey(code)) {
            codeString = code;
        }
        if (codeString == null) {
            throw new UtilsException("Diagnostic with code [" + code + "] undefined");
        }
        return this.replacePlaceholders(code, this.diagnosticProperties.getMappingStringCodeToDiagnostic().get((Object)codeString).message, null, params);
    }

    public String getMessage(String code, Object o) throws UtilsException {
        String codeString = null;
        if (this.diagnosticProperties.getMappingFullCodeToFullString().containsKey(code)) {
            codeString = this.diagnosticProperties.getMappingFullCodeToFullString().get(code);
        }
        if (codeString == null && this.diagnosticProperties.getMappingStringCodeToDiagnostic().containsKey(code)) {
            codeString = code;
        }
        if (codeString == null) {
            throw new UtilsException("Diagnostic with code [" + code + "] undefined");
        }
        return this.replacePlaceholders(code, this.diagnosticProperties.getMappingStringCodeToDiagnostic().get((Object)codeString).message, o, new String[0]);
    }

    public String getFunction(String code) throws UtilsException {
        String codeString = null;
        if (this.diagnosticProperties.getMappingFullCodeToFullString().containsKey(code)) {
            codeString = this.diagnosticProperties.getMappingFullCodeToFullString().get(code);
        }
        if (codeString == null && this.diagnosticProperties.getMappingStringCodeToDiagnostic().containsKey(code)) {
            codeString = code;
        }
        if (codeString == null) {
            throw new UtilsException("Diagnostic with code [" + code + "] undefined");
        }
        return this.diagnosticProperties.getMappingStringCodeToDiagnostic().get((Object)codeString).functionString;
    }

    private String replacePlaceholders(String diagnostic, String msg, Object dinamycObject, String ... params) throws UtilsException {
        if (msg != null && msg.length() > 2) {
            int index1 = msg.indexOf("{");
            int index2 = msg.indexOf("}", index1 + 1);
            if (index1 < 0 || index2 < 0) {
                return msg;
            }
        }
        if (msg == null) {
            return msg;
        }
        StringBuilder bf = new StringBuilder();
        StringBuilder keyword = new StringBuilder();
        boolean separator = false;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if ('{' == ch || '}' == ch) {
                if (!separator) {
                    separator = true;
                    continue;
                }
                String valoreRimpiazzato = this.getValue(diagnostic, keyword.toString(), dinamycObject, params);
                if (valoreRimpiazzato == null) {
                    if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                        throw new UtilsException("Placeholder [{" + keyword.toString() + "}] resolution failed");
                    }
                    bf.append("(???Placeholder [{" + keyword.toString() + "] return null value)");
                } else {
                    bf.append(valoreRimpiazzato);
                }
                keyword.delete(0, keyword.length());
                separator = false;
                continue;
            }
            if (separator) {
                keyword.append(ch);
                continue;
            }
            bf.append(ch);
        }
        return bf.toString();
    }

    private String getValue(String diagnostic, String key, Object dinamycObject, String ... params) throws UtilsException {
        if (key.startsWith(CONTEXT)) {
            if (this.context == null) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] required context");
                }
                return "(???Placeholder [" + key + "] required context)";
            }
            return this.readValueInObject(diagnostic, this.context, key.substring(CONTEXT.length(), key.length()), key);
        }
        if (key.startsWith(DYNAMIC_OBJECT)) {
            if (dinamycObject == null) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] required dynamic parameter");
                }
                return "(???Placeholder [" + key + "] required dynamic parameter)";
            }
            return this.readValueInObject(diagnostic, dinamycObject, key.substring(DYNAMIC_OBJECT.length(), key.length()), key);
        }
        try {
            int intValue = Integer.parseInt(key);
            if (intValue < 0) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] unsupported");
                }
                return "(???Placeholder [" + key + "] unsupported)";
            }
            if (params == null || params.length <= 0) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] required parameters");
                }
                return "(???Placeholder [" + key + "] required parameters)";
            }
            if (intValue >= params.length) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] grather then parameters size:" + params.length);
                }
                return "(???Placeholder [" + key + "] grather then parameters size:" + params.length + ")";
            }
            return params[intValue];
        }
        catch (Exception e) {
            if (e instanceof UtilsException) {
                throw (UtilsException)e;
            }
            try {
                String value;
                if (this.loggerForCallback != null && (value = this.loggerForCallback.getLogParam(key)) != null) {
                    return value;
                }
            }
            catch (Exception eCallback) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] callback resolution failed: " + eCallback.getMessage(), eCallback);
                }
                return "(???Placeholder [" + key + "] callback resolution failed: " + eCallback.getMessage() + ")";
            }
            if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + key + "] unsupported: " + e.getMessage(), e);
            }
            return "(???Placeholder [" + key + "] unsupported: " + e.getMessage() + ")";
        }
    }

    private String readValueInObject(String diagnostic, Object o, String name, String placeholderOriginale) throws UtilsException {
        String fieldName = name;
        String position = null;
        if (name.contains(".")) {
            fieldName = name.substring(0, name.indexOf("."));
        }
        String methodName = new String(fieldName);
        if (fieldName.endsWith("]") && fieldName.contains("[")) {
            try {
                position = fieldName.substring(fieldName.indexOf("[") + 1, fieldName.length() - 1);
                methodName = fieldName.substring(0, fieldName.indexOf("["));
            }
            catch (Exception e) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("Errore durante l'identificazione del parametro di posizionamento [" + fieldName + "]: " + e.getMessage(), e);
                }
                return "(???Placeholder [" + placeholderOriginale + "] uncorrect, errore durante l'identificazione del parametro di posizionamento [" + fieldName + "]: " + e.getMessage() + ")";
            }
        }
        String getMethod = "get" + ("" + methodName.charAt(0)).toUpperCase();
        if (methodName.length() > 1) {
            getMethod = getMethod + methodName.substring(1);
        }
        Method m = null;
        try {
            m = o.getClass().getMethod(getMethod, new Class[0]);
        }
        catch (Throwable e) {
            if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                throw new UtilsException("(diagnostic:" + diagnostic + ") Method [" + o.getClass().getName() + "." + getMethod + "()] not found: " + e.getMessage(), e);
            }
            return "(???Placeholder [" + placeholderOriginale + "] Method [" + o.getClass().getName() + "." + getMethod + "()] not found: " + e.getMessage() + ")";
        }
        Object ret = null;
        try {
            ret = m.invoke(o, new Object[0]);
        }
        catch (Throwable e) {
            if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                throw new UtilsException("(diagnostic:" + diagnostic + ") Invocation method [" + o.getClass().getName() + "." + getMethod + "()] failed: " + e.getMessage(), e);
            }
            return "(???Placeholder [" + placeholderOriginale + "] Invocation method [" + o.getClass().getName() + "." + getMethod + "()] failed: " + e.getMessage() + ")";
        }
        if (ret != null && (ret instanceof List || ret instanceof Map || ret instanceof Object[])) {
            if (position == null) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object without position");
                }
                return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object without position)";
            }
            if (ret instanceof List || ret instanceof Object[]) {
                int index = -1;
                try {
                    index = Integer.parseInt(position);
                }
                catch (Exception e) {
                    if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                        throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value (not integer?): " + e.getMessage() + " )");
                    }
                    return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value (not integer?): " + e.getMessage() + " )";
                }
                if (ret instanceof List) {
                    List list = (List)ret;
                    if (list.size() <= index) {
                        if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                            throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value " + index + " (list size:" + list.size() + ") )");
                        }
                        return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value " + index + " (list size:" + list.size() + ") )";
                    }
                    ret = list.get(index);
                } else if (ret instanceof Object[]) {
                    Object[] arrayObj = (Object[])ret;
                    if (arrayObj.length <= index) {
                        if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                            throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value " + index + " (array size:" + arrayObj.length + ") )");
                        }
                        return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value " + index + " (array size:" + arrayObj.length + ") )";
                    }
                    ret = arrayObj[index];
                }
            } else if (ret instanceof Map) {
                Map map = (Map)ret;
                if (!map.containsKey(position)) {
                    if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                        throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position [" + position + "] not exists as key in map )");
                    }
                    return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position [" + position + "] not exists as key in map )";
                }
                ret = map.get(position);
            }
        }
        if (name.contains(".")) {
            if (ret == null) {
                if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                    throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return null object");
                }
                return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return null object)";
            }
            return this.readValueInObject(diagnostic, ret, name.substring((fieldName + ".").length(), name.length()), placeholderOriginale);
        }
        String finalValue = null;
        if (ret != null) {
            if (ret instanceof Date) {
                SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
                finalValue = dateformat.format((Date)ret);
            } else {
                if (ret instanceof byte[]) {
                    int max = 5120;
                    return Utilities.convertToPrintableText((byte[])ret, max);
                }
                finalValue = ret.toString();
            }
        } else {
            if (this.diagnosticProperties.isThrowExceptionPlaceholderFailedResolution()) {
                throw new UtilsException("(diagnostic:" + diagnostic + ") Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return null object");
            }
            return "(???Placeholder [" + placeholderOriginale + "] uncorrect, method [" + o.getClass().getName() + "." + getMethod + "()] return null object)";
        }
        return finalValue;
    }
}

