/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGenerator;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;

public abstract class AbstractReturnGeneratedKeyGenerator
implements IKeyGenerator {
    protected Connection connection;
    protected IKeyGeneratorObject type;
    protected long idTraccia;

    public AbstractReturnGeneratedKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        this.connection = connection;
        this.type = type;
    }

    @Override
    public boolean isReturnGeneratedKeySupported() {
        return true;
    }

    @Override
    public boolean useReturnGeneratedKeyColumnNameInResultSet() {
        return false;
    }

    @Override
    public String getColunmKeyName() throws KeyGeneratorException {
        switch (this.type.getType()) {
            case DEFAULT: {
                return "id";
            }
            case CUSTOM: {
                return ((CustomKeyGeneratorObject)this.type).getColumnNameId();
            }
        }
        throw new KeyGeneratorException("Tipo di KeyGeneratorObjects non gestito: " + this.type);
    }

    @Override
    public long generateKey() throws KeyGeneratorException {
        throw new KeyGeneratorException("ReturnGeneratedKey supported");
    }

    @Override
    public long getReturnGeneratedKey(PreparedStatement stmt) throws KeyGeneratorException {
        ResultSet rs = null;
        try {
            rs = stmt.getGeneratedKeys();
            if (!rs.next()) {
                throw new Exception("ID autoincrementale non ottenuto via JDBC3.0");
            }
            this.idTraccia = this.useReturnGeneratedKeyColumnNameInResultSet() ? rs.getLong(this.getColunmKeyName()) : rs.getLong(1);
            if (this.idTraccia <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto: is null?");
            }
            long l = this.idTraccia;
            return l;
        }
        catch (Exception e) {
            throw new KeyGeneratorException("Errore durante la generazione della chiave via JDBC3.0: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

