/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jaxrs;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JodaLocalDateConverter
implements ParamConverter<LocalDate> {
    private static final Logger log = LoggerFactory.getLogger(JodaLocalDateConverter.class);
    private DateTimeZone timeZone = null;

    public JodaLocalDateConverter(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public LocalDate fromString(String date) {
        try {
            DateTimeFormatter formatter = ISODateTimeFormat.dateOptionalTimeParser().withZone(this.timeZone);
            LocalDate ld = formatter.parseLocalDate(date);
            return ld;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new WebApplicationException("Converter '" + date + "' to org.joda.time.DateTime failed: " + ex, (Throwable)ex, 400);
        }
    }

    public String toString(LocalDate t) {
        try {
            DateTimeFormatter formatter = ISODateTimeFormat.dateOptionalTimeParser().withZone(this.timeZone);
            return formatter.print((ReadablePartial)t);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new WebApplicationException("Converter org.joda.time.DateTime to String failed: " + ex, (Throwable)ex, 400);
        }
    }
}

