/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jaxrs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.TimeZone;

public class JacksonJsonProviderCustomized
extends JacksonJsonProvider {
    private static boolean failOnMissingExternalTypeIdProperty = false;

    public static boolean isFailOnMissingExternalTypeIdProperty() {
        return failOnMissingExternalTypeIdProperty;
    }

    public static void setFailOnMissingExternalTypeIdProperty(boolean failOnMissingExternalTypeIdProperty) {
        JacksonJsonProviderCustomized.failOnMissingExternalTypeIdProperty = failOnMissingExternalTypeIdProperty;
    }

    public static ObjectMapper getObjectMapper(boolean prettyPrint, TimeZone timeZone) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setTimeZone(timeZone);
        mapper.registerModule((Module)new JodaModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        if (prettyPrint) {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, failOnMissingExternalTypeIdProperty);
        return mapper;
    }

    public JacksonJsonProviderCustomized() {
        super(JacksonJsonProviderCustomized.getObjectMapper(false, TimeZone.getDefault()));
    }

    public JacksonJsonProviderCustomized(boolean prettyPrint) {
        super(JacksonJsonProviderCustomized.getObjectMapper(prettyPrint, TimeZone.getDefault()));
    }

    public JacksonJsonProviderCustomized(String timeZoneId) {
        super(JacksonJsonProviderCustomized.getObjectMapper(false, TimeZone.getTimeZone(timeZoneId)));
    }

    public JacksonJsonProviderCustomized(String timeZoneId, boolean prettyPrint) {
        super(JacksonJsonProviderCustomized.getObjectMapper(prettyPrint, TimeZone.getTimeZone(timeZoneId)));
    }
}

