/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.notifier.StreamingHandler;
import org.openspcoop2.utils.io.notifier.unblocked.AbstractStreamingHandler;
import org.openspcoop2.utils.io.notifier.unblocked.PipedInputOutputStreamHandler;
import org.slf4j.Logger;

public class NotifierInputStreamParams {
    private boolean bufferEnabled = false;
    private Map<String, StreamingHandler> streamingHandlers = new HashMap<String, StreamingHandler>();
    private List<String> streamingHandlersIds = new ArrayList<String>();
    private boolean throwStreamingHandlerException = true;
    private Logger log = null;

    public boolean isBufferEnabled() {
        return this.bufferEnabled;
    }

    public void setBufferEnabled(boolean bufferEnabled) {
        this.bufferEnabled = bufferEnabled;
    }

    public boolean isThrowStreamingHandlerException() {
        return this.throwStreamingHandlerException;
    }

    public void setThrowStreamingHandlerException(boolean throwStreamingHandlerException) {
        this.throwStreamingHandlerException = throwStreamingHandlerException;
    }

    public void addStreamingHandler(StreamingHandler streamingHandler) throws UtilsException {
        String idStreamingHandler = streamingHandler.getID();
        if (this.streamingHandlers.containsKey(idStreamingHandler)) {
            throw new UtilsException("Streaming handler with id [" + idStreamingHandler + "] already registered");
        }
        this.streamingHandlers.put(idStreamingHandler, streamingHandler);
        this.streamingHandlersIds.add(idStreamingHandler);
    }

    public void addStreamingHandler(String idStreamingHandler, AbstractStreamingHandler stremingHandler, Logger log) throws UtilsException {
        if (this.streamingHandlers.containsKey(idStreamingHandler)) {
            throw new UtilsException("Streaming handler with id [" + idStreamingHandler + "] already registered");
        }
        try {
            PipedInputOutputStreamHandler handler = new PipedInputOutputStreamHandler(idStreamingHandler, stremingHandler, log);
            this.streamingHandlers.put(idStreamingHandler, handler);
            this.streamingHandlersIds.add(idStreamingHandler);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public StreamingHandler getStreamingHandler(String idStreamingHandler) throws UtilsException {
        if (!this.streamingHandlers.containsKey(idStreamingHandler)) {
            throw new UtilsException("Streaming handler with id [" + idStreamingHandler + "] not exists");
        }
        return this.streamingHandlers.get(idStreamingHandler);
    }

    public StreamingHandler removeStreamingHandler(String idStreamingHandler) throws UtilsException {
        if (!this.streamingHandlers.containsKey(idStreamingHandler)) {
            throw new UtilsException("Streaming handler with id [" + idStreamingHandler + "] not exists");
        }
        for (int i = 0; i < this.streamingHandlersIds.size(); ++i) {
            if (!this.streamingHandlersIds.get(i).equals(idStreamingHandler)) continue;
            this.streamingHandlersIds.remove(i);
        }
        return this.streamingHandlers.remove(idStreamingHandler);
    }

    public List<String> getStreamingHandlerIds() {
        return this.streamingHandlersIds;
    }

    public int sizeStreamingHandlers() {
        return this.streamingHandlers.size();
    }

    public Map<String, StreamingHandler> getStreamingHandlers() {
        return this.streamingHandlers;
    }

    public void setStreamingHandlers(Map<String, StreamingHandler> streamingHandlers) {
        this.streamingHandlers = streamingHandlers;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

