/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.serial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;

public class InfoStatistics {
    private int errorSerializableAccess = 0;
    private List<Throwable> exceptionOccurs = new ArrayList<Throwable>();
    private List<String> _exceptionOccursDistincts = new ArrayList<String>();
    private Map<String, Integer> _occurs = new HashMap<String, Integer>();
    private Semaphore semaphore = new Semaphore("InfoStatistics");

    public int getErrorSerializableAccess() {
        return this.errorSerializableAccess;
    }

    public List<Throwable> getExceptionOccurs() {
        return this.exceptionOccurs;
    }

    public int getNumber(Throwable e) {
        return this._occurs.get(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorSerializableAccess(Throwable e) {
        SemaphoreLock lock = this.semaphore.acquireThrowRuntime("addErrorSerializableAccess");
        try {
            Throwable msgE = Utilities.getInnerNotEmptyMessageException(e);
            String msg = null;
            msg = msgE != null ? msgE.getMessage() : e.toString();
            if (msg == null) {
                msg = "NullException";
            }
            ++this.errorSerializableAccess;
            if (!this._exceptionOccursDistincts.contains(msg)) {
                this._exceptionOccursDistincts.add(msg);
                this.exceptionOccurs.add(e);
                this._occurs.put(msg, 1);
            } else {
                int occur = this._occurs.remove(msg);
                this._occurs.put(msg, ++occur);
            }
        }
        finally {
            this.semaphore.release(lock, "addErrorSerializableAccess");
        }
    }

    public void clear() {
        this.errorSerializableAccess = 0;
        this.exceptionOccurs.clear();
        this._exceptionOccursDistincts.clear();
    }
}

