/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.serial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.id.serial.IDSerialGenerator_alphanumeric;
import org.openspcoop2.utils.id.serial.IDSerialGenerator_numeric;

public class IDSerialGeneratorBuffer {
    private static Semaphore semaphore = new Semaphore("IDSerialGeneratorBuffer");
    private static Map<String, List<String>> buffer = new HashMap<String, List<String>>();

    private static String getPrefix(Class<?> cIdSerialGenerator) {
        if (cIdSerialGenerator.isAssignableFrom(IDSerialGenerator_alphanumeric.class)) {
            return "A_";
        }
        if (cIdSerialGenerator.isAssignableFrom(IDSerialGenerator_numeric.class)) {
            return "N_";
        }
        return "U_";
    }

    private static String getKey(Class<?> cIdSerialGenerator, String relativeInfo) {
        StringBuilder bf = new StringBuilder();
        bf.append(IDSerialGeneratorBuffer.getPrefix(cIdSerialGenerator));
        if (relativeInfo != null) {
            bf.append(relativeInfo);
        } else {
            bf.append("@_NONRELATIVE_@");
        }
        return bf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String nextValue(Class<?> cIdSerialGenerator, String relativeInfo) {
        String key = IDSerialGeneratorBuffer.getKey(cIdSerialGenerator, relativeInfo);
        SemaphoreLock lock = semaphore.acquireThrowRuntime("nextValue");
        try {
            String v;
            if (buffer.size() <= 0 || !buffer.containsKey(key)) {
                String string = null;
                return string;
            }
            List<String> l = buffer.get(key);
            if (l == null || l.size() <= 0) {
                String string = null;
                return string;
            }
            if (l.size() == 1) {
                l = buffer.remove(key);
            }
            String string = v = l.remove(0);
            return string;
        }
        finally {
            semaphore.release(lock, "nextValue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void putAll(List<String> valuesGenerated, Class<?> cIdSerialGenerator, String relativeInfo) {
        String key = IDSerialGeneratorBuffer.getKey(cIdSerialGenerator, relativeInfo);
        SemaphoreLock lock = semaphore.acquireThrowRuntime("putAll");
        try {
            List<Object> l = null;
            if (buffer.containsKey(key)) {
                l = buffer.get(key);
            } else {
                l = new ArrayList();
                buffer.put(key, l);
            }
            l.addAll(valuesGenerated);
        }
        finally {
            semaphore.release(lock, "putAll");
        }
    }

    protected static void clearBuffer() {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("clearBuffer");
        try {
            if (buffer != null && buffer.size() > 0) {
                buffer.clear();
            }
        }
        finally {
            semaphore.release(lock, "clearBuffer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearBuffer(Class<?> cIdSerialGenerator) {
        String prefix = IDSerialGeneratorBuffer.getPrefix(cIdSerialGenerator);
        SemaphoreLock lock = semaphore.acquireThrowRuntime("clearBuffer_class");
        try {
            if (buffer != null && buffer.size() > 0) {
                ArrayList<String> remove = new ArrayList<String>();
                for (String key : buffer.keySet()) {
                    if (!key.startsWith(prefix)) continue;
                    remove.add(key);
                }
                while (!remove.isEmpty()) {
                    buffer.remove(remove.remove(0));
                }
            }
        }
        finally {
            semaphore.release(lock, "clearBuffer_class");
        }
    }
}

