/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateEngineType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;

public class IDUtilities {
    private static long uniqueSerialNumber;
    private static Semaphore semaphore_getUniqueSerialNumber;
    private static final char[] symbols;
    private static final SecureRandom random;
    private static final Map<String, char[]> mapRandom;
    private static Semaphore semaphore_generateDateTime;

    public static long getUniqueSerialNumber() {
        return IDUtilities.getUniqueSerialNumber("anonymous", null);
    }

    public static long getUniqueSerialNumber(String methodName) {
        return IDUtilities.getUniqueSerialNumber(methodName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueSerialNumber(String methodName, String idTransazione) {
        SemaphoreLock lock = semaphore_getUniqueSerialNumber.acquireThrowRuntime(methodName, idTransazione);
        try {
            if (uniqueSerialNumber + 1L > Long.MAX_VALUE) {
                uniqueSerialNumber = 0L;
            }
            long l = ++uniqueSerialNumber;
            return l;
        }
        finally {
            semaphore_getUniqueSerialNumber.release(lock, methodName, idTransazione);
        }
    }

    private static synchronized char[] getBufferForRandom(int length) {
        String key = "" + length;
        if (mapRandom.containsKey(key)) {
            return mapRandom.get(key);
        }
        char[] buf = new char[length];
        mapRandom.put(key, buf);
        return buf;
    }

    public static String generateAlphaNumericRandomString(int length) {
        char[] buf = IDUtilities.getBufferForRandom(length);
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = symbols[random.nextInt(symbols.length)];
        }
        return new String(buf);
    }

    public static String generateDateTime(String format, int syncMs) {
        return IDUtilities.generateDateTime(DateUtils.getDEFAULT_DATA_ENGINE_TYPE(), format, syncMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDateTime(DateEngineType type, String format, int syncMs) {
        SemaphoreLock lock = semaphore_generateDateTime.acquireThrowRuntime("generateDateTime");
        try {
            Utilities.sleep(syncMs);
            String string = DateUtils.getTimeFormatter(type, format).format(DateManager.getDate());
            return string;
        }
        finally {
            semaphore_generateDateTime.release(lock, "generateDateTime");
        }
    }

    public static String generateDateTime_ISO_8601_TZ(String format, int syncMs) {
        return IDUtilities.generateDateTime_ISO_8601_TZ(DateUtils.getDEFAULT_DATA_ENGINE_TYPE(), format, syncMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDateTime_ISO_8601_TZ(DateEngineType type, String format, int syncMs) {
        SemaphoreLock lock = semaphore_generateDateTime.acquireThrowRuntime("generateDateTime_ISO_8601_TZ");
        try {
            Utilities.sleep(syncMs);
            String string = DateUtils.getDateTimeFormatter_ISO_8601_TZ(type, format).format(DateManager.getDate());
            return string;
        }
        finally {
            semaphore_generateDateTime.release(lock, "generateDateTime_ISO_8601_TZ");
        }
    }

    static {
        char ch;
        uniqueSerialNumber = 0L;
        semaphore_getUniqueSerialNumber = new Semaphore("IDUtilities.getUniqueSerialNumber");
        StringBuilder tmp = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        symbols = tmp.toString().toCharArray();
        random = new SecureRandom();
        mapRandom = new ConcurrentHashMap<String, char[]>();
        semaphore_generateDateTime = new Semaphore("IDUtilities.generateDateTime");
    }
}

