/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import java.util.ArrayList;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.ApacheGeneratorConfiguration;
import org.openspcoop2.utils.id.ApacheIdentifierGenerator;
import org.openspcoop2.utils.id.apache.serial.EnumTypeGenerator;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class ApacheClient {
    public static void main(String[] args) throws Exception {
        ApacheClient.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test() throws Exception {
        int i;
        ApacheIdentifierGenerator generator = new ApacheIdentifierGenerator();
        ApacheGeneratorConfiguration config = new ApacheGeneratorConfiguration();
        config.setType(EnumTypeGenerator.PREFIXED_ALPHANUMERIC);
        config.setPrefix("PREFIX");
        config.setSize("PREFIX".length() + 3);
        config.setStartDigit(Character.valueOf('3'));
        config.setEndDigit(Character.valueOf('9'));
        config.setStartLetter(Character.valueOf('b'));
        config.setEndLetter(Character.valueOf('z'));
        config.setEnableLowerCaseLetter(true);
        config.setEnableUpperCaseLetter(true);
        config.setWrap(false);
        generator.initialize(config);
        ArrayList<String> check = new ArrayList<String>();
        String v = null;
        try {
            for (i = 0; i < 10000; ++i) {
                v = generator.newID().toString();
                if (!RegularExpressionEngine.isMatch(v, "^[a-zA-Z0-9]*$")) {
                    throw new UtilsException("Deve essere fornito [a-zA-Z0-9] trovato [" + v + "]");
                }
                if (check.contains(v)) {
                    throw new Exception("Valore [" + v + "] gia generato");
                }
                check.add(v);
                if (i < 20) {
                    System.out.println("VALORE [" + i + "]: " + v);
                    continue;
                }
                if (i % 50 != 0) continue;
                System.out.println("VALORE [" + i + "]: " + v);
            }
            System.out.println("VALORE LAST [" + i + "]: " + v);
        }
        catch (Throwable throwable) {
            System.out.println("VALORE LAST [" + i + "]: " + v);
            throw throwable;
        }
    }
}

