/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.dch;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.dch.DataContentHandlerManager;
import org.slf4j.Logger;

public class MailcapActivationReader {
    private static Map<String, String> mimeTypes = new HashMap<String, String>();

    public static void initDataContentHandler(Logger log, boolean forceLoadMailcap) throws UtilsException {
        try {
            DataContentHandlerManager dchManager = new DataContentHandlerManager(log);
            List<String> typesRegistrati = dchManager.readMimeTypesRegistrati(true);
            InputStream is = MailcapActivationReader.class.getResourceAsStream("/META-INF/mailcap");
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<Object> en = prop.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                int index = key.indexOf(";;");
                if (index == -1) {
                    throw new Exception("Entry " + key + (String)prop.get(key) + " definita con un formato scorretto [;;] (vedi javax/activation/MailcapCommandMap api)");
                }
                String keyMime = key.substring(0, index);
                keyMime = keyMime.trim();
                String value = (String)prop.get(key);
                index = value.indexOf("=");
                if (index == -1) {
                    throw new Exception("Entry " + key + (String)prop.get(key) + " definita con un formato scorretto [=] (vedi javax/activation/MailcapCommandMap api)");
                }
                value = value.substring(index + 1, value.length());
                value = value.trim();
                mimeTypes.put(keyMime, value);
                if (!typesRegistrati.contains(keyMime)) {
                    if (forceLoadMailcap) {
                        log.info("DataContentHandler per mime-type " + keyMime + " non risulta registrato, caricamento in corso ...");
                        URL url = MailcapActivationReader.class.getResource("/META-INF/mailcap");
                        byte[] mailcap = Utilities.getAsByteArray(url);
                        dchManager.addMimeTypesIntoMailcap(mailcap);
                    } else {
                        log.error("DataContentHandler per mime-type " + keyMime + " non risulta registrato");
                    }
                }
                log.info("Caricato nel core di OpenSPCoop (!!differente dal MailcapEngine!!) DataContentHandler per mime-type " + keyMime + " gestito tramite la classe " + value);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static boolean existsDataContentHandler(String mimeType) {
        return mimeTypes.containsKey(mimeType);
    }
}

