/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.openspcoop2.utils.date.DateType;
import org.openspcoop2.utils.date.DateUtils;

public class DateTimeFormatterWrapper
extends SimpleDateFormat {
    private static final long serialVersionUID = 1L;
    private DateType dataType;
    private String format;
    private boolean timeZone;
    private TimeZone zone;

    public DateTimeFormatterWrapper(DateType dataType, String format, boolean timeZone) {
        this.dataType = dataType;
        this.format = format;
        this.timeZone = timeZone;
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        this.zone = zone;
    }

    @Override
    public Date parse(String source) throws ParseException {
        try {
            switch (this.dataType) {
                case JAVA_UTIL_DATE: 
                case JAVA_UTIL_DATE_TIME: 
                case JAVA_UTIL_TIME: {
                    SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                    if (this.timeZone) {
                        sdf.setCalendar(Calendar.getInstance());
                    } else if (this.zone != null) {
                        sdf.setTimeZone(this.zone);
                    }
                    return sdf.parse(source);
                }
                case JAVA_TIME_DATE: {
                    return DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDate(this.format, source));
                }
                case JAVA_TIME_DATE_TIME: {
                    return DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDateTime(this.format, source));
                }
                case JAVA_TIME_TIME: {
                    return DateUtils.convertToDateViaInstant(DateUtils.parseToLocalTime(this.format, source));
                }
                case JODA_DATE: 
                case JODA_DATE_TIME: 
                case JODA_TIME: {
                    return DateUtils.convertToDate(DateUtils.parseToJodaDateTime(this.format, source));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("[" + this.dataType + "] " + e.getMessage(), e);
        }
        throw new RuntimeException("[" + this.dataType + "] unsupported");
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            switch (this.dataType) {
                case JAVA_UTIL_DATE: 
                case JAVA_UTIL_DATE_TIME: 
                case JAVA_UTIL_TIME: {
                    SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                    if (this.timeZone) {
                        sdf.setCalendar(Calendar.getInstance());
                    } else if (this.zone != null) {
                        sdf.setTimeZone(this.zone);
                    }
                    toAppendTo.append(sdf.format(date));
                    return toAppendTo;
                }
                case JAVA_TIME_DATE: 
                case JAVA_TIME_DATE_TIME: 
                case JAVA_TIME_TIME: {
                    toAppendTo.append(DateUtils.getDateTimeFormatter(this.format).format(DateUtils.convertToZonedDateTimeViaInstant(date)));
                    return toAppendTo;
                }
                case JODA_DATE: 
                case JODA_DATE_TIME: 
                case JODA_TIME: {
                    toAppendTo.append(DateUtils.convertToJodaDateTime(date).toString(DateUtils.getJodaDateTimeFormatter(this.format)));
                    return toAppendTo;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("[" + this.dataType + "] " + e.getMessage(), e);
        }
        throw new RuntimeException("[" + this.dataType + "] unsupported");
    }
}

