/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.datasource.test;

import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.datasource.DataSource;
import org.openspcoop2.utils.datasource.DataSourceFactory;
import org.openspcoop2.utils.datasource.DataSourceParams;

public class ExampleServletInitListener
implements ServletContextListener {
    private static boolean initialized = false;
    public static final String ID_APPLICATIVO_RUNTIME = "Esempio1RuntimeProdotto";
    public static final String ID_APPLICATIVO_CONFIGURAZIONE = "Esempio2ConfigurazioneProdotto";
    public static String UUID_RUNTIME = null;
    public static String UUID_CONFIGURAZIONE = null;
    public static String JNDI_NAME_RUNTIME = null;
    public static String JNDI_NAME_CONFIGURAZIONE = null;

    public static boolean isInitialized() {
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        Properties datasourceJndiContextExample2;
        String datasourceJndiNameExample2;
        Properties datasourceJndiContextExample1;
        String datasourceJndiNameExample1;
        TipiDatabase databaseType;
        block18: {
            databaseType = null;
            datasourceJndiNameExample1 = null;
            datasourceJndiContextExample1 = null;
            datasourceJndiNameExample2 = null;
            datasourceJndiContextExample2 = null;
            try {
                InputStream is = ExampleServletInitListener.class.getResourceAsStream("/example.datasource.properties");
                try {
                    if (is != null) {
                        Properties p = new Properties();
                        p.load(is);
                        String tmpDatabaseType = p.getProperty("databaseType");
                        if (tmpDatabaseType != null) {
                            databaseType = TipiDatabase.toEnumConstant(tmpDatabaseType = tmpDatabaseType.trim());
                            if (databaseType == null) {
                                throw new RuntimeException("Property [databaseType] with wrong value [" + tmpDatabaseType + "]");
                            }
                        } else {
                            throw new RuntimeException("Property [databaseType] not found");
                        }
                        datasourceJndiNameExample1 = p.getProperty("example1.datasource.jndiName");
                        if (datasourceJndiNameExample1 == null) {
                            throw new RuntimeException("Property [example1.datasource.jndiName] not found");
                        }
                        JNDI_NAME_RUNTIME = datasourceJndiNameExample1 = datasourceJndiNameExample1.trim();
                        datasourceJndiContextExample1 = Utilities.readProperties("example1.datasource.jndiContext.", p);
                        datasourceJndiNameExample2 = p.getProperty("example2.datasource.jndiName");
                        if (datasourceJndiNameExample2 == null) {
                            throw new RuntimeException("Property [example2.datasource.jndiName] not found");
                        }
                        JNDI_NAME_CONFIGURAZIONE = datasourceJndiNameExample2 = datasourceJndiNameExample2.trim();
                        datasourceJndiContextExample2 = Utilities.readProperties("example2.datasource.jndiContext.", p);
                        break block18;
                    }
                    throw new RuntimeException("Property [example.datasource.properties] not found");
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception p) {}
                }
            }
            catch (Exception is) {
                // empty catch block
            }
        }
        try {
            DataSourceParams dsParams = new DataSourceParams();
            dsParams.setBindJmx(true);
            dsParams.setWrapOriginalMethods(true);
            dsParams.setDatabaseType(databaseType);
            System.out.println("Inizializzo datasource example 1 ...");
            dsParams.setApplicativeId(ID_APPLICATIVO_RUNTIME);
            DataSource dsExample1 = DataSourceFactory.newInstance(datasourceJndiNameExample1, datasourceJndiContextExample1, dsParams);
            UUID_RUNTIME = dsExample1.getUuidDatasource();
            System.out.println("Inizializzazione datasource example 1 effettuata con uuid: " + UUID_RUNTIME);
            System.out.println("Inizializzo datasource example 2 ...");
            dsParams.setApplicativeId(ID_APPLICATIVO_CONFIGURAZIONE);
            DataSource dsExample2 = DataSourceFactory.newInstance(datasourceJndiNameExample2, datasourceJndiContextExample2, dsParams);
            UUID_CONFIGURAZIONE = dsExample2.getUuidDatasource();
            System.out.println("Inizializzazione datasource example 2 effettuata con uuid: " + UUID_CONFIGURAZIONE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        initialized = true;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        System.out.println("Undeploy in corso...");
        initialized = false;
        UUID_RUNTIME = null;
        UUID_CONFIGURAZIONE = null;
        try {
            DataSourceFactory.closeResources();
            System.out.println("Undeploy effettuato.");
        }
        catch (Exception e) {
            System.err.println("Undeploy effettuato con errore: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

