/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import java.security.Provider;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.salt.SaltGenerator;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.JasyptCustomSaltGenerator;

public class JasyptCustomDigesterConfig
implements DigesterConfig {
    private CryptConfig config;
    private JasyptCustomSaltGenerator customSaltGenerator;

    public JasyptCustomDigesterConfig(CryptConfig config, JasyptCustomSaltGenerator customSaltGenerator) {
        this.config = config;
        this.customSaltGenerator = customSaltGenerator;
    }

    public String getAlgorithm() {
        String digestAlgorithm = this.config.getDigestAlgorithm();
        if (digestAlgorithm == null) {
            digestAlgorithm = "SHA-256";
        }
        return digestAlgorithm;
    }

    public Boolean getInvertPositionOfPlainSaltInEncryptionResults() {
        return false;
    }

    public Boolean getInvertPositionOfSaltInMessageBeforeDigesting() {
        return false;
    }

    public Integer getIterations() {
        if (this.config.getIteration() != null && this.config.getIteration() > 0) {
            return (int)this.config.getIteration();
        }
        return null;
    }

    public Integer getPoolSize() {
        return null;
    }

    public Provider getProvider() {
        return null;
    }

    public String getProviderName() {
        return null;
    }

    public SaltGenerator getSaltGenerator() {
        return this.customSaltGenerator;
    }

    public Integer getSaltSizeBytes() {
        if (this.config.getSaltLength() != null && this.config.getSaltLength() > 0) {
            return (int)this.config.getSaltLength();
        }
        return null;
    }

    public Boolean getUseLenientSaltSizeCheck() {
        return false;
    }
}

