/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.codec.digest.Sha2Crypt;
import org.apache.commons.codec.digest.UnixCrypt;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.crypt.CodecType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.random.RandomGenerator;
import org.slf4j.Logger;

public class CodecCrypt
implements ICrypt {
    private static final String ITERATOR = "rounds=";
    private Logger log;
    private CodecType type;
    private CryptConfig config;
    private RandomGenerator randomGenerator;

    public CodecCrypt(CodecType type) {
        this.type = type;
        if (this.type == null) {
            this.type = CodecType.SHA2_BASED_UNIX_CRYPT_SHA256;
        }
    }

    @Override
    public void init(Logger log, CryptConfig config) {
        this.log = log;
        this.config = config;
        if (this.config == null) {
            this.config = new CryptConfig();
        }
        this.randomGenerator = new RandomGenerator(this.config.isUseSecureRandom(), this.config.getAlgorithmSecureRandom());
    }

    @Override
    public String crypt(String password) throws UtilsException {
        Integer saltLength = this.config.getSaltLength();
        if (saltLength == null) {
            switch (this.type) {
                case LIBC_CRYPT_MD5: 
                case LIBC_CRYPT_MD5_APACHE: {
                    saltLength = 8;
                    break;
                }
                case SHA2_BASED_UNIX_CRYPT_SHA256: 
                case SHA2_BASED_UNIX_CRYPT_SHA512: {
                    saltLength = 16;
                    break;
                }
                case DES_UNIX_CRYPT: {
                    saltLength = 2;
                }
            }
        }
        if (this.randomGenerator == null) {
            throw new UtilsException("RandomGenerator undefined");
        }
        String salt = this.randomGenerator.nextRandom(saltLength);
        if (!CodecType.DES_UNIX_CRYPT.equals((Object)this.type)) {
            StringBuilder sb = new StringBuilder();
            String prefix = this.type.getPrefix();
            if (salt.startsWith(prefix) && salt.length() > prefix.length()) {
                salt = salt.substring(prefix.length());
            }
            sb.append(prefix);
            if (this.config.getIteration() != null && this.config.getIteration() > 0 && (CodecType.SHA2_BASED_UNIX_CRYPT_SHA256.equals((Object)this.type) || CodecType.SHA2_BASED_UNIX_CRYPT_SHA512.equals((Object)this.type)) && !salt.startsWith(ITERATOR)) {
                sb.append(ITERATOR).append(this.config.getIteration()).append("$");
                sb.append(salt);
            } else {
                sb.append(salt);
            }
            if (!salt.endsWith("$")) {
                sb.append("$");
            }
            salt = sb.toString();
        }
        return this._crypt(password, salt);
    }

    @Override
    public boolean check(String password, String pwcrypt) {
        try {
            boolean checkPwS = false;
            String newPw = this._crypt(password, pwcrypt);
            if (newPw.equals(pwcrypt)) {
                checkPwS = true;
            }
            return checkPwS;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.error("Verifica password '" + pwcrypt + "' fallita: " + e.getMessage(), e);
            }
            return false;
        }
    }

    private String _crypt(String password, String salt) throws UtilsException {
        byte[] keyBytes = null;
        try {
            keyBytes = password.getBytes(this.config.getCharsetName());
        }
        catch (Throwable e) {
            throw new UtilsException(e.getMessage(), e);
        }
        switch (this.type) {
            case LIBC_CRYPT_MD5: {
                if (salt != null) {
                    return Md5Crypt.md5Crypt((byte[])keyBytes, (String)salt);
                }
                return Md5Crypt.md5Crypt((byte[])keyBytes);
            }
            case LIBC_CRYPT_MD5_APACHE: {
                if (salt != null) {
                    return Md5Crypt.apr1Crypt((byte[])keyBytes, (String)salt);
                }
                return Md5Crypt.apr1Crypt((byte[])keyBytes);
            }
            case SHA2_BASED_UNIX_CRYPT_SHA256: {
                if (salt != null) {
                    return Sha2Crypt.sha256Crypt((byte[])keyBytes, (String)salt);
                }
                return Sha2Crypt.sha256Crypt((byte[])keyBytes);
            }
            case SHA2_BASED_UNIX_CRYPT_SHA512: {
                if (salt != null) {
                    return Sha2Crypt.sha512Crypt((byte[])keyBytes, (String)salt);
                }
                return Sha2Crypt.sha512Crypt((byte[])keyBytes);
            }
            case DES_UNIX_CRYPT: {
                if (salt != null) {
                    return UnixCrypt.crypt((byte[])keyBytes, (String)salt);
                }
                return UnixCrypt.crypt((byte[])keyBytes);
            }
        }
        throw new UtilsException("Unsupported type '" + this.type + "'");
    }
}

