/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.hsm;

import java.io.File;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.slf4j.Logger;

public class HSMKeystore
implements Serializable {
    private static final long serialVersionUID = -3572589461109860459L;
    private transient Boolean uniqueProviderInstance;
    private transient Provider providerInstance;
    private String id;
    private String provider;
    private boolean providerAdd = false;
    private String configFile;
    private String config;
    private String pin;
    private String keystoreTypeLabel;
    private String keystoreType;
    private boolean usableAsTrustStore = false;
    private boolean usableAsSecretKeyStore = false;

    protected HSMKeystore(String id, Properties p, Logger log, boolean accessKeystore) throws UtilsException {
        this.id = id;
        if (p == null || p.isEmpty()) {
            log.error("Properties is null");
        }
        String prefix = "Property 'hsm." + id;
        String uncorrect = "' uncorrect: ";
        if (p == null || p.isEmpty()) {
            throw new UtilsException("Properties 'hsm." + id + ".*' undefined");
        }
        this.provider = HSMKeystore.getProperty(id, p, "provider", accessKeystore);
        String tmp = HSMKeystore.getProperty(id, p, "provider.add", false);
        if (tmp != null) {
            try {
                this.providerAdd = Boolean.parseBoolean(tmp);
            }
            catch (Exception e) {
                throw new UtilsException(prefix + ".provider.add" + uncorrect + e.getMessage(), e);
            }
        }
        this.configFile = HSMKeystore.getProperty(id, p, "provider.configFile", false);
        this.config = HSMKeystore.getProperty(id, p, "provider.config", false);
        this.pin = HSMKeystore.getProperty(id, p, "pin", accessKeystore);
        this.keystoreType = HSMKeystore.getProperty(id, p, "keystoreType", accessKeystore);
        this.keystoreTypeLabel = HSMKeystore.getProperty(id, p, "keystoreType.label", true);
        tmp = HSMKeystore.getProperty(id, p, "usableAsTrustStore", false);
        if (tmp != null) {
            try {
                this.usableAsTrustStore = Boolean.parseBoolean(tmp);
            }
            catch (Exception e) {
                throw new UtilsException(prefix + ".usableAsTrustStore" + uncorrect + e.getMessage(), e);
            }
        }
        if ((tmp = HSMKeystore.getProperty(id, p, "usableAsSecretKeyStore", false)) != null) {
            try {
                this.usableAsSecretKeyStore = Boolean.parseBoolean(tmp);
            }
            catch (Exception e) {
                throw new UtilsException(prefix + ".usableAsSecretKeyStore" + uncorrect + e.getMessage(), e);
            }
        }
    }

    private static String getProperty(String id, Properties p, String name, boolean required) throws UtilsException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new UtilsException("Property 'hsm." + id + "." + name + "' notFound");
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getProvider() {
        return this.provider;
    }

    public boolean isProviderAdd() {
        return this.providerAdd;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfig() {
        return this.config;
    }

    public String getKeystoreTypeLabel() {
        return this.keystoreTypeLabel;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getPrefixForLog() {
        return "[Keystore '" + this.getId() + "' type:" + this.getKeystoreTypeLabel() + "] ";
    }

    public void init(Logger log, boolean uniqueProviderInstance) throws UtilsException {
        if (this.uniqueProviderInstance == null) {
            this.initInstance(log, uniqueProviderInstance);
        }
    }

    private synchronized void initInstance(Logger log, boolean uniqueProviderInstance) throws UtilsException {
        if (this.uniqueProviderInstance == null) {
            Provider providerNew = this.newProviderInstance();
            if (this.isProviderAdd()) {
                Provider providerCheck = null;
                try {
                    providerCheck = Security.getProvider(providerNew.getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (providerCheck == null) {
                    Security.addProvider(providerNew);
                    String d = "Registered provider: " + providerNew.getName();
                    log.info(d);
                } else {
                    String d = "Loaded provider (not registered, already exists): " + providerNew.getName();
                    log.info(d);
                }
            } else {
                String d = "Loaded provider: " + providerNew.getName();
                log.info(d);
            }
            this.uniqueProviderInstance = uniqueProviderInstance;
            if (this.uniqueProviderInstance != null && this.uniqueProviderInstance.booleanValue()) {
                this.providerInstance = providerNew;
            }
        }
    }

    private Provider newProviderInstance() throws UtilsException {
        Provider providerNew = Security.getProvider(this.getProvider());
        String prefix = this.getPrefixForLog();
        if (this.getConfigFile() != null) {
            File f = new File(this.getConfigFile());
            if (!f.exists()) {
                throw new UtilsException(prefix + "Configuration file '" + f.getAbsolutePath() + "' not exists");
            }
            if (!f.canRead()) {
                throw new UtilsException(prefix + "Configuration file '" + f.getAbsolutePath() + "' cannot read");
            }
            providerNew = providerNew.configure(this.getConfigFile());
        } else if (this.getConfig() != null) {
            providerNew = providerNew.configure(this.getConfig());
        }
        return providerNew;
    }

    public KeyStore getInstance() throws UtilsException {
        String prefix = this.getPrefixForLog();
        Provider providerInstanceGet = null;
        if (this.uniqueProviderInstance == null) {
            throw new UtilsException(prefix + "Provider not initialized");
        }
        if (this.uniqueProviderInstance.booleanValue()) {
            if (this.providerInstance == null) {
                throw new UtilsException(prefix + "Provider not initialized");
            }
            providerInstanceGet = this.providerInstance;
        } else {
            providerInstanceGet = this.newProviderInstance();
        }
        java.security.KeyStore hsmKeyStore = null;
        try {
            hsmKeyStore = java.security.KeyStore.getInstance(this.keystoreType, providerInstanceGet);
            hsmKeyStore.load(null, this.pin.toCharArray());
        }
        catch (Throwable t) {
            throw new UtilsException(prefix + t.getMessage(), t);
        }
        return new KeyStore(hsmKeyStore, true);
    }

    public boolean isUsableAsTrustStore() {
        return this.usableAsTrustStore;
    }

    public boolean isUsableAsSecretKeyStore() {
        return this.usableAsSecretKeyStore;
    }
}

