/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.slf4j.Logger;

public class BYOKRemoteConfig
implements Serializable {
    private static final long serialVersionUID = -3572589461109860459L;
    private String httpEndpoint;
    private String httpMethod;
    private Map<String, String> httpHeaders;
    private String httpPayloadPath;
    private String httpPayloadInLine;
    private String httpUsername;
    private String httpPassword;
    private Integer httpConnectionTimeout;
    private Integer httpReadTimeout;
    private boolean https = false;
    private boolean httpsHostnameVerifier = false;
    private boolean httpsServerAuth = false;
    private String httpsServerAuthTrustStorePath;
    private String httpsServerAuthTrustStoreType;
    private String httpsServerAuthTrustStorePassword;
    private String httpsServerAuthTrustStoreCrls;
    private String httpsServerAuthTrustStoreOcspPolicy;
    private boolean httpsClientAuth = false;
    private String httpsClientAuthKeyStorePath;
    private String httpsClientAuthKeyStoreType;
    private String httpsClientAuthKeyStorePassword;
    private String httpsClientAuthKeyAlias;
    private String httpsClientAuthKeyPassword;
    private boolean httpResponseBase64Encoded;
    private boolean httpResponseHexEncoded;
    private String httpResponseJsonPath;
    private boolean httpResponseJsonPathBase64Encoded;
    private boolean httpResponseJsonPathHexEncoded;

    protected BYOKRemoteConfig(String id, Properties p, Logger log, String byokPropertyPrefix) throws UtilsException {
        if (p == null || p.isEmpty()) {
            log.error("Properties is null");
            throw new UtilsException("Properties '" + byokPropertyPrefix + id + ".*' undefined");
        }
        this.httpEndpoint = BYOKConfig.getProperty(id, p, "http.endpoint", true, byokPropertyPrefix);
        this.httpMethod = BYOKConfig.getProperty(id, p, "http.method", true, byokPropertyPrefix);
        this.initHttpHeader(p);
        this.httpPayloadPath = BYOKConfig.getProperty(id, p, "http.payload.path", false, byokPropertyPrefix);
        this.httpPayloadInLine = BYOKConfig.getProperty(id, p, "http.payload.inline", false, byokPropertyPrefix);
        this.httpUsername = BYOKConfig.getProperty(id, p, "http.username", false, byokPropertyPrefix);
        this.httpPassword = BYOKConfig.getProperty(id, p, "http.password", false, byokPropertyPrefix);
        this.httpConnectionTimeout = BYOKConfig.getIntegerProperty(id, p, "http.connectionTimeout", false, byokPropertyPrefix);
        this.httpReadTimeout = BYOKConfig.getIntegerProperty(id, p, "http.readTimeout", false, byokPropertyPrefix);
        this.https = BYOKConfig.getBooleanProperty(id, p, "https", false, false, byokPropertyPrefix);
        this.httpsHostnameVerifier = BYOKConfig.getBooleanProperty(id, p, "https.hostnameVerifier", false, this.https, byokPropertyPrefix);
        this.httpsServerAuth = BYOKConfig.getBooleanProperty(id, p, "https.serverAuth", false, this.https, byokPropertyPrefix);
        this.httpsServerAuthTrustStorePath = BYOKConfig.getProperty(id, p, "https.serverAuth.trustStore.path", false, byokPropertyPrefix);
        this.httpsServerAuthTrustStoreType = BYOKConfig.getProperty(id, p, "https.serverAuth.trustStore.type", this.httpsServerAuth, byokPropertyPrefix);
        this.httpsServerAuthTrustStorePassword = BYOKConfig.getProperty(id, p, "https.serverAuth.trustStore.password", false, byokPropertyPrefix);
        this.httpsServerAuthTrustStoreCrls = BYOKConfig.getProperty(id, p, "https.serverAuth.trustStore.crls", false, byokPropertyPrefix);
        this.httpsServerAuthTrustStoreOcspPolicy = BYOKConfig.getProperty(id, p, "https.serverAuth.trustStore.ocspPolicy", false, byokPropertyPrefix);
        this.httpsClientAuth = BYOKConfig.getBooleanProperty(id, p, "https.clientAuth", false, false, byokPropertyPrefix);
        this.httpsClientAuthKeyStorePath = BYOKConfig.getProperty(id, p, "https.clientAuth.keyStore.path", false, byokPropertyPrefix);
        this.httpsClientAuthKeyStoreType = BYOKConfig.getProperty(id, p, "https.clientAuth.keyStore.type", this.httpsClientAuth, byokPropertyPrefix);
        this.httpsClientAuthKeyStorePassword = BYOKConfig.getProperty(id, p, "https.clientAuth.keyStore.password", false, byokPropertyPrefix);
        this.httpsClientAuthKeyAlias = BYOKConfig.getProperty(id, p, "https.clientAuth.key.alias", false, byokPropertyPrefix);
        this.httpsClientAuthKeyPassword = BYOKConfig.getProperty(id, p, "https.clientAuth.key.password", false, byokPropertyPrefix);
        this.httpResponseBase64Encoded = BYOKConfig.getBooleanProperty(id, p, "http.response.base64Encoded", false, false, byokPropertyPrefix);
        this.httpResponseHexEncoded = BYOKConfig.getBooleanProperty(id, p, "http.response.hexEncoded", false, false, byokPropertyPrefix);
        this.httpResponseJsonPath = BYOKConfig.getProperty(id, p, "http.response.jsonPath", false, byokPropertyPrefix);
        this.httpResponseJsonPathBase64Encoded = BYOKConfig.getBooleanProperty(id, p, "http.response.jsonPath.base64Encoded", false, false, byokPropertyPrefix);
        this.httpResponseJsonPathHexEncoded = BYOKConfig.getBooleanProperty(id, p, "http.response.jsonPath.hexEncoded", false, false, byokPropertyPrefix);
    }

    private void initHttpHeader(Properties p) {
        this.httpHeaders = new HashMap<String, String>();
        Enumeration<Object> enKeys = p.keys();
        while (enKeys.hasMoreElements()) {
            String key;
            Object object = enKeys.nextElement();
            if (!(object instanceof String) || !(key = (String)object).startsWith("http.header.") || key.length() <= "http.header.".length()) continue;
            String name = key.substring("http.header.".length());
            String value = p.getProperty(key);
            this.httpHeaders.put(name, value);
        }
    }

    public String getHttpEndpoint() {
        return this.httpEndpoint;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpPayloadInLine() {
        return this.httpPayloadInLine;
    }

    public String getHttpPayloadPath() {
        return this.httpPayloadPath;
    }

    public String getHttpUsername() {
        return this.httpUsername;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public Integer getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public Integer getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public boolean isHttps() {
        return this.https;
    }

    public boolean isHttpsHostnameVerifier() {
        return this.httpsHostnameVerifier;
    }

    public boolean isHttpsServerAuth() {
        return this.httpsServerAuth;
    }

    public String getHttpsServerAuthTrustStorePath() {
        return this.httpsServerAuthTrustStorePath;
    }

    public String getHttpsServerAuthTrustStoreType() {
        return this.httpsServerAuthTrustStoreType;
    }

    public String getHttpsServerAuthTrustStorePassword() {
        return this.httpsServerAuthTrustStorePassword;
    }

    public String getHttpsServerAuthTrustStoreCrls() {
        return this.httpsServerAuthTrustStoreCrls;
    }

    public String getHttpsServerAuthTrustStoreOcspPolicy() {
        return this.httpsServerAuthTrustStoreOcspPolicy;
    }

    public boolean isHttpsClientAuth() {
        return this.httpsClientAuth;
    }

    public String getHttpsClientAuthKeyStorePath() {
        return this.httpsClientAuthKeyStorePath;
    }

    public String getHttpsClientAuthKeyStoreType() {
        return this.httpsClientAuthKeyStoreType;
    }

    public String getHttpsClientAuthKeyStorePassword() {
        return this.httpsClientAuthKeyStorePassword;
    }

    public String getHttpsClientAuthKeyAlias() {
        return this.httpsClientAuthKeyAlias;
    }

    public String getHttpsClientAuthKeyPassword() {
        return this.httpsClientAuthKeyPassword;
    }

    public boolean isHttpResponseBase64Encoded() {
        return this.httpResponseBase64Encoded;
    }

    public boolean isHttpResponseHexEncoded() {
        return this.httpResponseHexEncoded;
    }

    public String getHttpResponseJsonPath() {
        return this.httpResponseJsonPath;
    }

    public boolean isHttpResponseJsonPathBase64Encoded() {
        return this.httpResponseJsonPathBase64Encoded;
    }

    public boolean isHttpResponseJsonPathHexEncoded() {
        return this.httpResponseJsonPathHexEncoded;
    }
}

