/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfig;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfigParameter;

public class BYOKProvider {
    public static final String BYOK_POLICY_UNDEFINED_EMPTY = "";
    public static final String BYOK_POLICY_UNDEFINED = "-";
    public static final String BYOK_POLICY_UNDEFINED_LABEL = "-";
    private static boolean unwrapKeystoreFileEnabled = true;
    private boolean byok = false;
    private List<String> byokTypes = new ArrayList<String>();
    private List<String> byokLabels = new ArrayList<String>();
    private Map<String, BYOKSecurityConfig> byokSecurity = new HashMap<String, BYOKSecurityConfig>();
    private static final String NO_BYOK = "--no_byok--";
    private static List<String> noBYOK = new ArrayList<String>();
    private static final String DEFAULT_BYOK = "Default";

    public static boolean isUnwrapKeystoreFileEnabled() {
        return unwrapKeystoreFileEnabled;
    }

    public static void setUnwrapKeystoreFileEnabled(boolean unwrapKeystoreFileEnabled) {
        BYOKProvider.unwrapKeystoreFileEnabled = unwrapKeystoreFileEnabled;
    }

    public static BYOKProvider getWrapInstance() throws UtilsException {
        return new BYOKProvider(true);
    }

    public static BYOKProvider getUnwrapInstance() throws UtilsException {
        return new BYOKProvider(false);
    }

    public boolean isByokEnabled() {
        return this.byok;
    }

    public boolean isUnwrapByokKeystoreEnabled() {
        return this.byok && unwrapKeystoreFileEnabled;
    }

    private BYOKProvider(boolean wrap) throws UtilsException {
        BYOKManager byokManager = BYOKManager.getInstance();
        SortedMap<String> sortedMap = wrap ? byokManager.getKeystoreWrapConfigTypesLabels() : byokManager.getKeystoreUnwrapConfigTypesLabels();
        boolean bl = this.byok = sortedMap != null && !sortedMap.isEmpty();
        if (this.byok) {
            boolean byokEnabled;
            ArrayList<String> byokTypesAdd = new ArrayList<String>();
            ArrayList<String> byokLabelsAdd = new ArrayList<String>();
            String typeDefault = null;
            if (!sortedMap.isEmpty()) {
                for (String type : sortedMap.keys()) {
                    if (!this.init(byokManager, type, byokTypesAdd, byokLabelsAdd, sortedMap)) continue;
                    typeDefault = type;
                }
            }
            boolean bl2 = byokEnabled = !byokTypesAdd.isEmpty();
            if (byokEnabled) {
                this.fillList(typeDefault, byokTypesAdd, byokLabelsAdd);
            }
        }
    }

    private boolean init(BYOKManager byokManager, String type, List<String> byokTypesAdd, List<String> byokLabelsAdd, SortedMap<String> sortedMap) throws UtilsException {
        boolean addDefault = false;
        String label = sortedMap.get(type);
        StringBuilder securityId = new StringBuilder();
        if (byokManager.isKMSUsedInSecurityUnwrapConfig(type, securityId)) {
            String secId = securityId.toString();
            BYOKSecurityConfig secConfig = byokManager.getKMSSecurityConfig(secId);
            if (BYOKManager.getSecurityRemoteEngineGovWayPolicy() != null && BYOKManager.getSecurityRemoteEngineGovWayPolicy().equals(secId)) {
                addDefault = true;
            }
            if (BYOKManager.getSecurityEngineGovWayPolicy() != null && BYOKManager.getSecurityEngineGovWayPolicy().equals(secId)) {
                if (BYOKManager.getSecurityRemoteEngineGovWayPolicy() != null) {
                    return false;
                }
                addDefault = true;
            }
            this.byokSecurity.put(type, secConfig);
            if (!addDefault) {
                byokTypesAdd.add(type);
                byokLabelsAdd.add(label);
            }
        } else {
            byokTypesAdd.add(type);
            byokLabelsAdd.add(label);
        }
        return addDefault;
    }

    private void fillList(String typeDefault, List<String> byokTypesAdd, List<String> byokLabelsAdd) {
        this.byokTypes.add(BYOK_POLICY_UNDEFINED_EMPTY);
        if (typeDefault != null) {
            this.byokTypes.add(typeDefault);
        }
        this.byokTypes.addAll(byokTypesAdd);
        this.byokLabels.add("-");
        if (typeDefault != null) {
            this.byokLabels.add(DEFAULT_BYOK);
        }
        this.byokLabels.addAll(byokLabelsAdd);
    }

    public List<String> getValues() {
        return this.byok ? this.byokTypes : noBYOK;
    }

    public List<String> getLabels() {
        return this.byok ? this.byokLabels : noBYOK;
    }

    public Map<String, String> getInputMap(String kmsId) {
        HashMap<String, String> inputMap = new HashMap<String, String>();
        BYOKSecurityConfig secConfig = this.byokSecurity.get(kmsId);
        if (secConfig != null && secConfig.getInputParameters() != null && !secConfig.getInputParameters().isEmpty()) {
            for (BYOKSecurityConfigParameter param : secConfig.getInputParameters()) {
                inputMap.put(param.getName(), param.getValue());
            }
        }
        return inputMap;
    }

    public static boolean isPolicyDefined(String kmsId) {
        return kmsId != null && StringUtils.isNotEmpty((String)kmsId) && !BYOK_POLICY_UNDEFINED_EMPTY.equals(kmsId) && !"-".equals(kmsId);
    }

    public static BYOKRequestParams getBYOKRequestParamsByUnwrapBYOKPolicy(String kmsId, Map<String, Object> dynamicMap) throws UtilsException {
        if (!BYOKProvider.isPolicyDefined(kmsId)) {
            return null;
        }
        BYOKProvider provider = BYOKProvider.getUnwrapInstance();
        Map<String, String> inputMap = provider.getInputMap(kmsId);
        return BYOKRequestParams.getBYOKRequestParamsByKmsId(kmsId, inputMap, dynamicMap);
    }

    static {
        noBYOK.add(NO_BYOK);
    }
}

