/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKConfigParameter;
import org.openspcoop2.utils.certificate.byok.BYOKEncryptionMode;
import org.openspcoop2.utils.certificate.byok.BYOKLocalConfig;
import org.openspcoop2.utils.certificate.byok.BYOKMode;
import org.openspcoop2.utils.certificate.byok.BYOKRemoteConfig;
import org.slf4j.Logger;

public class BYOKConfig
implements Serializable {
    private static final long serialVersionUID = -3572589461109860459L;
    private String id;
    private String type;
    private String label;
    private BYOKMode mode;
    private BYOKEncryptionMode encryptionMode;
    private List<String> inputParametersIds;
    private List<BYOKConfigParameter> inputParameters = new ArrayList<BYOKConfigParameter>();
    private BYOKRemoteConfig remoteConfig;
    private BYOKLocalConfig localConfig;

    protected BYOKConfig(String id, Properties p, Logger log, String byokPropertyPrefix) throws UtilsException {
        this.id = id;
        if (p == null || p.isEmpty()) {
            log.error("Properties is null");
            throw new UtilsException("Properties '" + byokPropertyPrefix + id + ".*' undefined");
        }
        this.type = BYOKConfig.getProperty(id, p, "type", true, byokPropertyPrefix);
        this.label = BYOKConfig.getProperty(id, p, "label", true, byokPropertyPrefix);
        String tmpMode = BYOKConfig.getProperty(id, p, "mode", true, byokPropertyPrefix);
        try {
            this.mode = BYOKMode.valueOf(tmpMode.toUpperCase());
        }
        catch (Exception e) {
            throw new UtilsException("Invalid property '" + byokPropertyPrefix + id + ".mode' enum value '" + tmpMode + "': " + e.getMessage());
        }
        tmpMode = BYOKConfig.getProperty(id, p, "encryptionMode", false, byokPropertyPrefix);
        if (tmpMode != null && StringUtils.isNotEmpty((String)tmpMode)) {
            try {
                this.encryptionMode = BYOKEncryptionMode.valueOf(tmpMode.toUpperCase());
            }
            catch (Exception e) {
                throw new UtilsException("Invalid property '" + byokPropertyPrefix + id + ".encryptionMode' enum value '" + tmpMode + "': " + e.getMessage());
            }
        } else {
            this.encryptionMode = BYOKEncryptionMode.REMOTE;
        }
        this.inputParametersIds = new ArrayList<String>();
        this.initInput(p, this.inputParametersIds);
        if (this.inputParametersIds != null && !this.inputParametersIds.isEmpty()) {
            for (String inputId : this.inputParametersIds) {
                String nameP = BYOKConfig.getProperty(id, p, "input." + inputId + ".name", true, byokPropertyPrefix);
                String labelP = BYOKConfig.getProperty(id, p, "input." + inputId + ".label", true, byokPropertyPrefix);
                this.inputParameters.add(new BYOKConfigParameter(inputId, nameP, labelP));
            }
        }
        if (BYOKEncryptionMode.REMOTE.equals((Object)this.encryptionMode)) {
            this.remoteConfig = new BYOKRemoteConfig(id, p, log, byokPropertyPrefix);
        } else {
            this.localConfig = new BYOKLocalConfig(id, p, log, this, byokPropertyPrefix);
        }
    }

    void initInput(Properties p, List<String> idKeystore) {
        Enumeration<Object> enKeys = p.keys();
        while (enKeys.hasMoreElements()) {
            Object object = enKeys.nextElement();
            if (!(object instanceof String)) continue;
            String key = (String)object;
            this.initInput(key, "input.", idKeystore);
        }
    }

    void initInput(String key, String prefix, List<String> idKeystore) {
        String idK;
        int indeoOf;
        String tmp;
        if (key.startsWith(prefix) && key.length() > prefix.length() && (tmp = key.substring(prefix.length())) != null && tmp.contains(".") && (indeoOf = tmp.indexOf(".")) > 0 && !idKeystore.contains(idK = tmp.substring(0, indeoOf))) {
            idKeystore.add(idK);
        }
    }

    static String getProperty(String id, Properties p, String name, boolean required, String byokPropertyPrefix) throws UtilsException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new UtilsException("Property '" + byokPropertyPrefix + id + "." + name + "' notFound");
        }
        return null;
    }

    static Integer getIntegerProperty(String id, Properties p, String name, boolean required, String byokPropertyPrefix) throws UtilsException {
        String v = BYOKConfig.getProperty(id, p, name, required, byokPropertyPrefix);
        if (v != null && StringUtils.isNotEmpty((String)v)) {
            try {
                return Integer.valueOf(v);
            }
            catch (Exception e) {
                throw new UtilsException("Invalid integer property '" + byokPropertyPrefix + id + "." + name + "' value '" + e.getMessage() + "': " + e.getMessage());
            }
        }
        return null;
    }

    static Boolean getBooleanProperty(String id, Properties p, String name, boolean required, Boolean defaultValue, String byokPropertyPrefix) throws UtilsException {
        String v = BYOKConfig.getProperty(id, p, name, required, byokPropertyPrefix);
        if (v != null && StringUtils.isNotEmpty((String)v)) {
            try {
                return Boolean.parseBoolean(v);
            }
            catch (Exception e) {
                throw new UtilsException("Invalid boolean property '" + byokPropertyPrefix + id + "." + name + "' value '" + e.getMessage() + "': " + e.getMessage());
            }
        }
        return defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public String getPrefixForLog() {
        return "[KMS '" + this.getId() + "' type:" + this.type + " label:" + this.label + "] ";
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public BYOKMode getMode() {
        return this.mode;
    }

    public BYOKEncryptionMode getEncryptionMode() {
        return this.encryptionMode;
    }

    public List<String> getInputParametersIds() {
        return this.inputParametersIds;
    }

    public List<BYOKConfigParameter> getInputParameters() {
        return this.inputParameters;
    }

    public BYOKRemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public BYOKLocalConfig getLocalConfig() {
        return this.localConfig;
    }
}

