/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.openspcoop2.utils.UtilsException;

public class SymmetricKeyUtils {
    public static final String ALGO_AES = "AES";
    public static final String ALGO_RIJNDAEL = "Rijndael";
    private String algorithm;

    public static SymmetricKeyUtils getInstance() {
        return new SymmetricKeyUtils();
    }

    public static SymmetricKeyUtils getInstance(String algo) {
        return new SymmetricKeyUtils(algo);
    }

    public SymmetricKeyUtils() {
        this(ALGO_AES);
    }

    public SymmetricKeyUtils(String algorithm) {
        this.algorithm = algorithm;
    }

    public SecretKey getSecretKey(byte[] secretKey) throws UtilsException {
        try {
            return new SecretKeySpec(secretKey, this.algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

