/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.PEMReader;

public class KeyUtils {
    public static final String ALGO_RSA = "RSA";
    public static final String ALGO_DSA = "DSA";
    public static final String ALGO_DH = "DH";
    public static final String ALGO_EC = "EC";
    private KeyFactory kf;

    public static KeyUtils getInstance() throws UtilsException {
        return new KeyUtils();
    }

    public static KeyUtils getInstance(String algo) throws UtilsException {
        return new KeyUtils(algo);
    }

    public KeyUtils() throws UtilsException {
        this(ALGO_RSA);
    }

    public KeyUtils(String algo) throws UtilsException {
        try {
            this.kf = KeyFactory.getInstance(algo);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public PublicKey readPublicKeyPEMFormat(byte[] publicKey) throws UtilsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PublicKey readPublicKeyDERFormat(byte[] publicKey) throws UtilsException {
        try {
            X509EncodedKeySpec specPub = new X509EncodedKeySpec(publicKey);
            return this.kf.generatePublic(specPub);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PublicKey readCertificate(byte[] publicKey) throws UtilsException {
        String cert;
        PEMReader pemArchive = new PEMReader(publicKey);
        if (pemArchive.getCertificates() != null && !pemArchive.getCertificates().isEmpty() && (cert = pemArchive.getCertificates().get(0)) != null && StringUtils.isNotEmpty((String)cert)) {
            publicKey = cert.getBytes();
        }
        return ArchiveLoader.load(publicKey).getCertificate().getCertificate().getPublicKey();
    }

    public PublicKey getPublicKey(byte[] publicKey) throws UtilsException {
        String cert;
        PEMReader pemArchive = new PEMReader(publicKey);
        if (pemArchive.getPublicKey() != null) {
            return this.readPublicKeyPEMFormat(pemArchive.getPublicKey().getBytes());
        }
        if (pemArchive.getCertificates() != null && !pemArchive.getCertificates().isEmpty() && (cert = pemArchive.getCertificates().get(0)) != null && StringUtils.isNotEmpty((String)cert)) {
            return this.readCertificate(cert.getBytes());
        }
        try {
            return this.readPublicKeyDERFormat(publicKey);
        }
        catch (Exception e) {
            try {
                return this.readCertificate(publicKey);
            }
            catch (Exception ignore) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PrivateKey readPKCS1PrivateKeyPEMFormat(byte[] privateKey) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey, true, false, false);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
        }
        try (ByteArrayInputStream bin = new ByteArrayInputStream(privateKey);){
            PrivateKey privateKey2;
            try (InputStreamReader ir = new InputStreamReader(bin);){
                PEMParser pemParser = new PEMParser((Reader)ir);
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                Object object = pemParser.readObject();
                KeyPair kp = converter.getKeyPair((PEMKeyPair)object);
                privateKey2 = kp.getPrivate();
            }
            return privateKey2;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public PrivateKey readPKCS8PrivateKeyPEMFormat(byte[] privateKey) throws UtilsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PrivateKey readPKCS8PrivateKeyDERFormat(byte[] privateKey) throws UtilsException {
        try {
            PKCS8EncodedKeySpec specPriv = new PKCS8EncodedKeySpec(privateKey);
            return this.kf.generatePrivate(specPriv);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PrivateKey getPrivateKey(byte[] privateKey) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
            if (pemArchive.isPkcs1()) {
                return this.readPKCS1PrivateKeyPEMFormat(privateKey);
            }
            if (pemArchive.isPkcs8()) {
                return this.readPKCS8PrivateKeyPEMFormat(privateKey);
            }
        }
        return this.readPKCS8PrivateKeyDERFormat(privateKey);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PrivateKey readPKCS1EncryptedPrivateKeyPEMFormat(byte[] privateKey, String password) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey, true, false, false);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
        }
        try (ByteArrayInputStream bin = new ByteArrayInputStream(privateKey);){
            PrivateKey privateKey2;
            try (InputStreamReader ir = new InputStreamReader(bin);){
                PEMParser pemParser = new PEMParser((Reader)ir);
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                Object object = pemParser.readObject();
                PEMEncryptedKeyPair pair = (PEMEncryptedKeyPair)object;
                JcePEMDecryptorProviderBuilder jce = new JcePEMDecryptorProviderBuilder().setProvider("BC");
                PEMDecryptorProvider decProv = jce.build(password.toCharArray());
                KeyPair kp = converter.getKeyPair(pair.decryptKeyPair(decProv));
                privateKey2 = kp.getPrivate();
            }
            return privateKey2;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PrivateKey readPKCS8EncryptedPrivateKeyPEMFormat(byte[] privateKey, String password) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey, false, false, true);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
        }
        PKCS8EncryptedPrivateKeyInfo pair = null;
        try (ByteArrayInputStream bin = new ByteArrayInputStream(privateKey);
             InputStreamReader ir = new InputStreamReader(bin);){
            PEMParser parser = new PEMParser((Reader)ir);
            pair = (PKCS8EncryptedPrivateKeyInfo)parser.readObject();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return this.readPKCS8EncryptedPrivateKey(pair, password);
    }

    public PrivateKey readPKCS8EncryptedPrivateKeyDERFormat(byte[] privateKey, String password) throws UtilsException {
        PKCS8EncryptedPrivateKeyInfo pair = null;
        try {
            pair = new PKCS8EncryptedPrivateKeyInfo(privateKey);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return this.readPKCS8EncryptedPrivateKey(pair, password);
    }

    private PrivateKey readPKCS8EncryptedPrivateKey(PKCS8EncryptedPrivateKeyInfo pair, String password) throws UtilsException {
        try {
            JceOpenSSLPKCS8DecryptorProviderBuilder jce = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC");
            InputDecryptorProvider decProv = jce.build(password.toCharArray());
            PrivateKeyInfo keyInfo = pair.decryptPrivateKeyInfo(decProv);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            return converter.getPrivateKey(keyInfo);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PrivateKey getPrivateKey(byte[] privateKey, String password) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
            if (pemArchive.isPkcs8encrypted()) {
                return this.readPKCS8EncryptedPrivateKeyPEMFormat(privateKey, password);
            }
            if (pemArchive.isPkcs1()) {
                try {
                    return this.readPKCS1EncryptedPrivateKeyPEMFormat(privateKey, password);
                }
                catch (Exception e) {
                    try {
                        return this.readPKCS1PrivateKeyPEMFormat(privateKey);
                    }
                    catch (Exception ignore) {
                        throw new UtilsException(e.getMessage(), e);
                    }
                }
            }
            if (pemArchive.isPkcs8()) {
                return this.readPKCS8PrivateKeyPEMFormat(privateKey);
            }
        }
        try {
            return this.readPKCS8EncryptedPrivateKeyDERFormat(privateKey, password);
        }
        catch (Exception e) {
            try {
                return this.readPKCS8PrivateKeyDERFormat(privateKey);
            }
            catch (Exception ignore) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }
}

