/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class JWKPublicKeyConverter {
    public static final String KID_NULL = "#none#";

    public static void main(String[] args) throws UtilsException {
        if (args == null || args.length < 2) {
            throw new UtilsException("ERROR: argomenti non forniti (USAGE: JWKPublicKeyConverter pathPublicKey pathJWK [kid] [jwkset(true/false)] [pretty(true/false)])");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            String pathPublicKey = args[0];
            byte[] publicKey = FileSystemUtilities.readBytesFromFile(pathPublicKey);
            KeyUtils keyUtils = new KeyUtils("RSA");
            PublicKey pKey = keyUtils.getPublicKey(publicKey);
            String pathJWK = args[1];
            String kid = null;
            if (args.length > 2) {
                kid = args[2];
            }
            if (kid == null || StringUtils.isEmpty((String)kid)) {
                kid = UUID.randomUUID().toString();
            }
            if (KID_NULL.equals(kid)) {
                kid = null;
            }
            boolean jwks = true;
            if (args.length > 3) {
                String tmp = args[3];
                jwks = "true".equals(tmp);
            }
            boolean pretty = false;
            if (args.length > 4) {
                String tmp = args[4];
                pretty = "true".equals(tmp);
            }
            String json = JWKPublicKeyConverter.convert(pKey, kid, jwks, pretty);
            FileSystemUtilities.writeFile(pathJWK, json.getBytes());
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
    }

    public static String convert(PublicKey pKey, String kid, boolean jwks, boolean pretty) throws UtilsException {
        JWK jwk = new JWK(pKey, kid);
        String json = null;
        if (jwks) {
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            json = pretty ? jwkSet.getJsonPretty() : jwkSet.getJson();
        } else {
            json = pretty ? jwk.getJsonPretty() : jwk.getJson();
        }
        return json;
    }
}

