/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.ReasonFlags;

public class CRLDistributionPoint {
    protected List<GeneralName> crlIssuers = new ArrayList<GeneralName>();
    protected ReasonFlags reasonFlags;
    protected DistributionPointName distributionPointName;
    protected List<GeneralName> distributionPointNames = new ArrayList<GeneralName>();

    public DistributionPointName getObjectDistributionPointName() {
        return this.distributionPointName;
    }

    public int getDistributionPointType() {
        return this.distributionPointName != null ? this.distributionPointName.getType() : -1;
    }

    public List<GeneralName> getObjectDistributionPointNames() {
        return this.distributionPointNames;
    }

    public GeneralName getObjectDistributionPointName(int index) {
        return this.distributionPointNames != null && this.distributionPointNames.size() > index ? this.distributionPointNames.get(index) : null;
    }

    public List<String> getDistributionPointNames() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.distributionPointNames != null && !this.distributionPointNames.isEmpty()) {
            for (GeneralName o : this.distributionPointNames) {
                if (o.getName() == null) continue;
                s.add(o.getName().toString());
            }
        }
        return s;
    }

    public String getDistributionPointName(int index) {
        if (this.distributionPointNames != null && this.distributionPointNames.size() > index) {
            return this.distributionPointNames.get(index) != null && this.distributionPointNames.get(index).getName() != null ? this.distributionPointNames.get(index).getName().toString() : null;
        }
        return null;
    }

    public boolean containsDistributionPointName(String name) throws CertificateParsingException {
        return this.containsDistributionPointNameEngine(null, name);
    }

    public boolean containsDistributionPointName(int tagNum, String name) throws CertificateParsingException {
        return this.containsDistributionPointNameEngine(tagNum, name);
    }

    private boolean containsDistributionPointNameEngine(Integer tagNum, String name) throws CertificateParsingException {
        if (name == null) {
            throw new CertificateParsingException("Param name undefined");
        }
        if (this.distributionPointNames != null && !this.distributionPointNames.isEmpty()) {
            for (GeneralName o : this.distributionPointNames) {
                if (!this.isEquals(o, tagNum, name)) continue;
                return true;
            }
        }
        return false;
    }

    public ReasonFlags getReasonFlags() {
        return this.reasonFlags;
    }

    public List<GeneralName> getObjectCRLIssuers() {
        return this.crlIssuers;
    }

    public GeneralName getObjectCRLIssuer(int index) {
        return this.crlIssuers != null && this.crlIssuers.size() > index ? this.crlIssuers.get(index) : null;
    }

    public List<String> getCRLIssuers() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.crlIssuers != null && !this.crlIssuers.isEmpty()) {
            for (GeneralName o : this.crlIssuers) {
                if (o.getName() == null) continue;
                s.add(o.getName().toString());
            }
        }
        return s;
    }

    public String getCRLIssuer(int index) {
        if (this.crlIssuers != null && this.crlIssuers.size() > index) {
            return this.crlIssuers.get(index) != null && this.crlIssuers.get(index).getName() != null ? this.crlIssuers.get(index).getName().toString() : null;
        }
        return null;
    }

    public boolean containsCRLIssuer(String name) throws CertificateParsingException {
        return this.containsCRLIssuerEngine(null, name);
    }

    public boolean containsCRLIssuer(int tagNum, String name) throws CertificateParsingException {
        return this.containsCRLIssuerEngine(tagNum, name);
    }

    private boolean containsCRLIssuerEngine(Integer tagNum, String name) throws CertificateParsingException {
        if (name == null) {
            throw new CertificateParsingException("Param name undefined");
        }
        if (this.crlIssuers != null && !this.crlIssuers.isEmpty()) {
            for (GeneralName o : this.crlIssuers) {
                if (!this.isEquals(o, tagNum, name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEquals(GeneralName o, Integer tagNum, String name) {
        if (o.getName() != null && name.equals(o.getName().toString())) {
            if (tagNum == null) {
                return true;
            }
            if (tagNum.intValue() == o.getTagNo()) {
                return true;
            }
        }
        return false;
    }
}

